/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.BoundingVoid;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.picking.PickTarget;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.j3d.aviatrix3d.rendering.Cullable;

public class SwitchGroup
extends Group {
    private int selectedChild = -1;
    private PickTarget[] pickChild = new PickTarget[1];

    public void setChild(Node node, int n) throws InvalidWriteTimingException {
        super.setChild(node, n);
        this.cullList[0] = n == this.selectedChild && node instanceof Cullable ? (Cullable)((Object)node) : null;
    }

    public void removeChild(int n) throws InvalidWriteTimingException {
        if (this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n == this.selectedChild) {
            this.selectedChild = -1;
            this.cullList[0] = null;
        }
        super.removeChild(n);
    }

    public void removeAllChildren() throws InvalidWriteTimingException {
        super.removeAllChildren();
        this.cullList[0] = null;
        this.selectedChild = -1;
    }

    public Cullable[] getCullableChildren() {
        return this.cullList;
    }

    public int numCullableChildren() {
        return this.selectedChild < 0 ? 0 : 1;
    }

    protected void recomputeBounds() {
        if (this.selectedChild == -1 || this.childList[this.selectedChild] == null) {
            this.bounds = INVALID_BOUNDS;
            return;
        }
        BoundingVolume boundingVolume = this.childList[this.selectedChild].getBounds();
        if (boundingVolume instanceof BoundingVoid) {
            this.bounds = INVALID_BOUNDS;
            return;
        }
        boundingVolume.getExtents(this.wkVec1, this.wkVec2);
        if (this.bounds == null || this.bounds instanceof BoundingVoid) {
            this.bounds = new BoundingBox();
        }
        BoundingBox boundingBox = (BoundingBox)this.bounds;
        boundingBox.setMinimum(this.wkVec1);
        boundingBox.setMaximum(this.wkVec2);
    }

    public int numPickableChildren() {
        return this.pickChild[0] != null ? 1 : 0;
    }

    public PickTarget[] getPickableChildren() {
        return this.pickChild;
    }

    public PickTarget getPickableChild(int n) {
        return this.pickChild[0];
    }

    public void setActiveChild(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n > this.lastChild) {
            throw new IllegalArgumentException("Index is not valid");
        }
        this.selectedChild = n < 0 ? -1 : n;
        this.cullList[0] = n >= 0 && this.childList[n] instanceof Cullable ? (Cullable)((Object)this.childList[n]) : null;
        this.pickChild[0] = this.cullList[0] instanceof PickTarget ? (PickTarget)((Object)this.cullList[0]) : null;
    }

    public int getActiveChild() {
        return this.selectedChild;
    }
}

