/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import javax.media.opengl.GL;
import org.j3d.aviatrix3d.BufferState;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.rendering.BufferStateRenderable;

public class StencilBufferState
extends BufferState
implements BufferStateRenderable {
    private static final String INVALID_OP_MSG = "The operation requested is not a standard type: ";
    private static final String INVALID_FUNCTION_MSG = "The function requested is not a standard type: ";
    public static final short STENCIL_INCREMENT = 7682;
    public static final short STENCIL_DECREMENT = 7683;
    public static final short STENCIL_KEEP = 7680;
    public static final short STENCIL_INVERT = 5386;
    public static final short STENCIL_ZERO = 0;
    public static final short STENCIL_REPLACE = 7681;
    public static final int FUNCTION_NEVER = 512;
    public static final int FUNCTION_LESS = 513;
    public static final int FUNCTION_LESS_OR_EQUAL = 515;
    public static final int FUNCTION_GREATER = 516;
    public static final int FUNCTION_GREATER_OR_EQUAL = 518;
    public static final int FUNCTION_EQUAL = 514;
    public static final int FUNCTION_NOTEQUAL = 517;
    public static final int FUNCTION_ALWAYS = 519;
    private int compareMask = -1;
    private int writeMask = -1;
    private int referenceValue = 0;
    private int failOp = 7680;
    private int depthFailOp = 7680;
    private int depthPassOp = 7680;
    private int function = 519;
    private int clearMask = 0;
    private boolean clearState = true;

    public int getBufferType() {
        return 2;
    }

    public int getBufferBitMask() {
        return 1024;
    }

    public boolean checkClearBufferState() {
        return this.clearState;
    }

    public void setBufferState(GL gL) {
        gL.glClearStencil(this.clearMask);
        gL.glEnable(2960);
        gL.glStencilFunc(this.function, this.referenceValue, this.compareMask);
        gL.glStencilOp(this.failOp, this.depthFailOp, this.depthPassOp);
        gL.glStencilMask(this.writeMask);
    }

    public void updateBufferState(GL gL) {
        gL.glClearStencil(this.clearMask);
        gL.glStencilFunc(this.function, this.referenceValue, this.compareMask);
        gL.glStencilOp(this.failOp, this.depthFailOp, this.depthPassOp);
        gL.glStencilMask(this.writeMask);
    }

    public void clearBufferState(GL gL) {
        gL.glDisable(2960);
        gL.glStencilMask(-1);
        gL.glClearStencil(0);
    }

    public int compareTo(Object object) throws ClassCastException {
        StencilBufferState stencilBufferState = (StencilBufferState)object;
        return this.compareTo(stencilBufferState);
    }

    public boolean equals(Object object) {
        if (!(object instanceof StencilBufferState)) {
            return false;
        }
        return this.equals((StencilBufferState)object);
    }

    public void setClearBufferState(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.clearState = bl;
    }

    public void setClearMask(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.clearMask = n;
    }

    public int getClearMask() {
        return this.clearMask;
    }

    public void setFunctionCompareMask(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.compareMask = n;
    }

    public int getFunctionCompareMask() {
        return this.compareMask;
    }

    public void setStencilWriteMask(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.writeMask = n;
    }

    public int getStencilWriteMask() {
        return this.compareMask;
    }

    public void setFunctionReferenceValue(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.referenceValue = n;
    }

    public int getFunctionReferenceValue() {
        return this.referenceValue;
    }

    public void setStencilFailOperation(int n) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        switch (n) {
            case 0: 
            case 5386: 
            case 7680: 
            case 7681: 
            case 7682: 
            case 7683: {
                this.failOp = n;
                break;
            }
            default: {
                throw new IllegalArgumentException(INVALID_OP_MSG + n);
            }
        }
    }

    public int getStencilFailOperation() {
        return this.failOp;
    }

    public void setDepthFailOperation(int n) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        switch (n) {
            case 0: 
            case 5386: 
            case 7680: 
            case 7681: 
            case 7682: 
            case 7683: {
                this.depthFailOp = n;
                break;
            }
            default: {
                throw new IllegalArgumentException(INVALID_OP_MSG + n);
            }
        }
    }

    public int getDepthFailOperation() {
        return this.depthFailOp;
    }

    public void setDepthPassOperation(int n) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        switch (n) {
            case 0: 
            case 5386: 
            case 7680: 
            case 7681: 
            case 7682: 
            case 7683: {
                this.depthPassOp = n;
                break;
            }
            default: {
                throw new IllegalArgumentException(INVALID_OP_MSG + n);
            }
        }
    }

    public int getDepthPassOperation() {
        return this.depthPassOp;
    }

    public void setStencilFunction(int n) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        switch (n) {
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: {
                this.function = n;
                break;
            }
            default: {
                throw new IllegalArgumentException(INVALID_FUNCTION_MSG + n);
            }
        }
    }

    public int getStencilFunction() {
        return this.function;
    }

    public int compareTo(StencilBufferState stencilBufferState) {
        if (stencilBufferState == null) {
            return 1;
        }
        if (stencilBufferState == this) {
            return 0;
        }
        if (this.clearState != stencilBufferState.clearState) {
            return this.clearState ? 1 : -1;
        }
        if (this.compareMask != stencilBufferState.compareMask) {
            return this.compareMask < stencilBufferState.compareMask ? -1 : 1;
        }
        if (this.writeMask != stencilBufferState.writeMask) {
            return this.writeMask < stencilBufferState.writeMask ? -1 : 1;
        }
        if (this.clearMask != stencilBufferState.clearMask) {
            return this.clearMask < stencilBufferState.clearMask ? -1 : 1;
        }
        if (this.referenceValue != stencilBufferState.referenceValue) {
            return this.referenceValue < stencilBufferState.referenceValue ? -1 : 1;
        }
        if (this.failOp != stencilBufferState.failOp) {
            return this.failOp < stencilBufferState.failOp ? -1 : 1;
        }
        if (this.depthFailOp != stencilBufferState.depthFailOp) {
            return this.depthFailOp < stencilBufferState.depthFailOp ? -1 : 1;
        }
        if (this.depthPassOp != stencilBufferState.depthPassOp) {
            return this.depthPassOp < stencilBufferState.depthPassOp ? -1 : 1;
        }
        if (this.function != stencilBufferState.function) {
            return this.function < stencilBufferState.function ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(StencilBufferState stencilBufferState) {
        if (stencilBufferState == this) {
            return true;
        }
        return stencilBufferState != null && this.clearState == stencilBufferState.clearState && this.compareMask == stencilBufferState.compareMask && this.writeMask == stencilBufferState.writeMask && this.clearMask == stencilBufferState.clearMask && this.referenceValue == stencilBufferState.referenceValue && this.failOp == stencilBufferState.failOp && this.depthFailOp == stencilBufferState.depthFailOp && this.depthPassOp == stencilBufferState.depthPassOp && this.function == stencilBufferState.function;
    }
}

