/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import javax.media.opengl.GL;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.NodeComponent;
import org.j3d.aviatrix3d.rendering.AppearanceAttributeRenderable;

public class StencilAttributes
extends NodeComponent
implements AppearanceAttributeRenderable {
    private static final String INVALID_OP_MSG = "The operation requested is not a standard type: ";
    private static final String INVALID_FUNCTION_MSG = "The function requested is not a standard type: ";
    public static final short STENCIL_INCREMENT = 7682;
    public static final short STENCIL_DECREMENT = 7683;
    public static final short STENCIL_KEEP = 7680;
    public static final short STENCIL_INVERT = 5386;
    public static final short STENCIL_ZERO = 0;
    public static final short STENCIL_REPLACE = 7681;
    public static final int FUNCTION_NEVER = 512;
    public static final int FUNCTION_LESS = 513;
    public static final int FUNCTION_LESS_OR_EQUAL = 515;
    public static final int FUNCTION_GREATER = 516;
    public static final int FUNCTION_GREATER_OR_EQUAL = 518;
    public static final int FUNCTION_EQUAL = 514;
    public static final int FUNCTION_NOTEQUAL = 517;
    public static final int FUNCTION_ALWAYS = 519;
    private int compareMask = -1;
    private int writeMask = -1;
    private int referenceValue = 0;
    private int failOp = 7680;
    private int depthFailOp = 7680;
    private int depthPassOp = 7680;
    private int function = 519;

    public int getAttributeType() {
        return 6;
    }

    public void render(GL gL) {
        gL.glEnable(2960);
        gL.glStencilFunc(this.function, this.referenceValue, this.compareMask);
        gL.glStencilOp(this.failOp, this.depthFailOp, this.depthPassOp);
        gL.glStencilMask(this.writeMask);
    }

    public void postRender(GL gL) {
        gL.glDisable(2960);
        gL.glStencilFunc(519, 0, 0);
        gL.glStencilOp(7680, 7680, 7680);
        gL.glClearStencil(0);
    }

    public int compareTo(Object object) throws ClassCastException {
        StencilAttributes stencilAttributes = (StencilAttributes)object;
        return this.compareTo(stencilAttributes);
    }

    public boolean equals(Object object) {
        if (!(object instanceof StencilAttributes)) {
            return false;
        }
        return this.equals((StencilAttributes)object);
    }

    public void setFunctionCompareMask(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.compareMask = n;
    }

    public int getFunctionCompareMask() {
        return this.compareMask;
    }

    public void setStencilWriteMask(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.writeMask = n;
    }

    public int getStencilWriteMask() {
        return this.compareMask;
    }

    public void setFunctionReferenceValue(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.referenceValue = n;
    }

    public int getFunctionReferenceValue() {
        return this.referenceValue;
    }

    public void setStencilFailOperation(int n) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        switch (n) {
            case 0: 
            case 5386: 
            case 7680: 
            case 7681: 
            case 7682: 
            case 7683: {
                this.failOp = n;
                break;
            }
            default: {
                throw new IllegalArgumentException(INVALID_OP_MSG + n);
            }
        }
    }

    public int getStencilFailOperation() {
        return this.failOp;
    }

    public void setDepthFailOperation(int n) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        switch (n) {
            case 0: 
            case 5386: 
            case 7680: 
            case 7681: 
            case 7682: 
            case 7683: {
                this.depthFailOp = n;
                break;
            }
            default: {
                throw new IllegalArgumentException(INVALID_OP_MSG + n);
            }
        }
    }

    public int getDepthFailOperation() {
        return this.depthFailOp;
    }

    public void setDepthPassOperation(int n) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        switch (n) {
            case 0: 
            case 5386: 
            case 7680: 
            case 7681: 
            case 7682: 
            case 7683: {
                this.depthPassOp = n;
                break;
            }
            default: {
                throw new IllegalArgumentException(INVALID_OP_MSG + n);
            }
        }
    }

    public int getDepthPassOperation() {
        return this.depthPassOp;
    }

    public void setStencilFunction(int n) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        switch (n) {
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: {
                this.function = n;
                break;
            }
            default: {
                throw new IllegalArgumentException(INVALID_FUNCTION_MSG + n);
            }
        }
    }

    public int getStencilFunction() {
        return this.function;
    }

    public int compareTo(StencilAttributes stencilAttributes) {
        if (stencilAttributes == null) {
            return 1;
        }
        if (stencilAttributes == this) {
            return 0;
        }
        if (this.compareMask != stencilAttributes.compareMask) {
            return this.compareMask < stencilAttributes.compareMask ? -1 : 1;
        }
        if (this.writeMask != stencilAttributes.writeMask) {
            return this.writeMask < stencilAttributes.writeMask ? -1 : 1;
        }
        if (this.referenceValue != stencilAttributes.referenceValue) {
            return this.referenceValue < stencilAttributes.referenceValue ? -1 : 1;
        }
        if (this.failOp != stencilAttributes.failOp) {
            return this.failOp < stencilAttributes.failOp ? -1 : 1;
        }
        if (this.depthFailOp != stencilAttributes.depthFailOp) {
            return this.depthFailOp < stencilAttributes.depthFailOp ? -1 : 1;
        }
        if (this.depthPassOp != stencilAttributes.depthPassOp) {
            return this.depthPassOp < stencilAttributes.depthPassOp ? -1 : 1;
        }
        if (this.function != stencilAttributes.function) {
            return this.function < stencilAttributes.function ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(StencilAttributes stencilAttributes) {
        if (stencilAttributes == this) {
            return true;
        }
        return stencilAttributes != null && this.compareMask == stencilAttributes.compareMask && this.writeMask == stencilAttributes.writeMask && this.referenceValue == stencilAttributes.referenceValue && this.failOp == stencilAttributes.failOp && this.depthFailOp == stencilAttributes.depthFailOp && this.depthPassOp == stencilAttributes.depthPassOp && this.function == stencilAttributes.function;
    }
}

