/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.j3d.aviatrix3d.AudioComponent;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Leaf;
import org.j3d.aviatrix3d.iutil.AudioUpdateListener;
import org.j3d.aviatrix3d.rendering.AudioRenderable;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.j3d.aviatrix3d.rendering.LeafCullable;
import org.j3d.aviatrix3d.rendering.Renderable;

public abstract class Sound
extends Leaf
implements LeafCullable,
AudioRenderable,
AudioUpdateListener {
    protected AudioComponent soundSource;
    protected int format;
    protected int freq;
    protected boolean loop;
    protected int buffer;
    protected float pitch;
    protected int seq;
    protected boolean dataChanged = false;
    protected boolean playChanged = false;
    protected boolean paramsChanged = false;
    protected boolean playing = false;
    protected boolean paused = false;
    protected boolean enabled = false;
    protected IntBuffer values;

    public Sound() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.values = byteBuffer.asIntBuffer();
    }

    protected void markBoundsDirty() {
    }

    protected void recomputeBounds() {
    }

    public BoundingVolume getBounds() {
        return INVALID_BOUNDS;
    }

    public void audioUpdated(int n, int n2, int n3) {
        this.format = n;
        this.freq = n2;
        this.seq = n3;
        this.dataChanged = true;
    }

    public void paramsUpdated(boolean bl, float f) {
        this.pitch = f;
        this.loop = bl;
        this.paramsChanged = true;
    }

    public int getCullableType() {
        return 5;
    }

    public Renderable getRenderable() {
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isSpatialised() {
        return true;
    }

    public void setEnabled(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.enabled = bl;
    }

    public void startSound() throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (!this.playing || this.paused) {
            this.playChanged = true;
            this.playing = true;
            this.paused = false;
        }
    }

    public void stopSound() throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.playing) {
            this.playChanged = true;
            this.playing = false;
            this.paused = false;
        }
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void pauseSound() throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.playing && !this.paused) {
            this.playChanged = true;
            this.paused = true;
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setAudioSource(AudioComponent audioComponent) {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.soundSource = audioComponent;
        this.format = audioComponent.getFormat();
        this.freq = audioComponent.getFrequency();
        this.loop = audioComponent.getLoop();
        this.pitch = audioComponent.getPitch();
        audioComponent.addUpdateListener(this);
        this.dataChanged = true;
    }

    protected int compareTo(Sound sound) {
        if (this.enabled != sound.enabled) {
            return this.enabled ? 1 : -1;
        }
        if (this.playing != sound.playing) {
            return this.playing ? 1 : -1;
        }
        if (this.paused != sound.paused) {
            return this.paused ? 1 : -1;
        }
        if (this.loop != sound.loop) {
            return this.loop ? 1 : -1;
        }
        if (this.format != sound.format) {
            return this.format < sound.format ? -1 : 1;
        }
        if (this.freq != sound.freq) {
            return this.freq < sound.freq ? -1 : 1;
        }
        if (this.pitch != sound.pitch) {
            return this.pitch < sound.pitch ? -1 : 1;
        }
        return 0;
    }

    protected boolean equals(Sound sound) {
        return this.enabled == sound.enabled && this.playing == sound.playing && this.paused == sound.paused && this.loop == sound.loop && this.freq == sound.freq && this.pitch == sound.pitch;
    }
}

