/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import org.j3d.aviatrix3d.AlreadyParentedException;
import org.j3d.aviatrix3d.InternalLayerUpdateListener;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.SimpleScene;
import org.j3d.aviatrix3d.Viewport;
import org.j3d.aviatrix3d.rendering.SceneCullable;
import org.j3d.aviatrix3d.rendering.ViewportCullable;
import org.j3d.aviatrix3d.rendering.ViewportLayerCullable;

public class SimpleViewport
extends Viewport
implements ViewportCullable,
ViewportLayerCullable {
    protected static final String HAS_PARENT_MSG = "This scene already has a parent. Scenes cannot be shared amongst layers multiple times.";
    private SimpleScene scene;
    private boolean activeSoundLayer = false;
    private InternalUpdater internalUpdater;

    public SimpleViewport() {
        super(0);
    }

    public ViewportLayerCullable getCullableLayer(int n) {
        return this;
    }

    public boolean isAudioSource() {
        return this.activeSoundLayer;
    }

    public int numCullableChildren() {
        return this.scene != null ? 1 : 0;
    }

    public boolean isMultipassViewport() {
        return false;
    }

    public SceneCullable getCullableScene() {
        return this.scene instanceof SceneCullable ? this.scene : null;
    }

    public void setDimensions(int n, int n2, int n3, int n4) throws InvalidWriteTimingException {
        super.setDimensions(n, n2, n3, n4);
        if (this.scene != null) {
            this.scene.setViewportDimensions(n, n2, n3, n4);
        }
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        if (this.scene != null) {
            this.scene.setUpdateHandler(nodeUpdateHandler);
        }
    }

    protected void setLive(boolean bl) {
        super.setLive(bl);
        if (this.scene != null) {
            this.scene.setLive(bl);
        }
    }

    public void makeActiveSoundLayer() throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.activeSoundLayer = true;
        if (this.updateHandler != null) {
            if (this.internalUpdater == null) {
                this.internalUpdater = new InternalUpdater();
            }
            this.updateHandler.activeSoundLayerChanged(this.internalUpdater);
        }
    }

    public boolean isActiveSoundLayer() {
        return this.activeSoundLayer;
    }

    public void setScene(SimpleScene simpleScene) throws InvalidWriteTimingException, AlreadyParentedException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.scene = simpleScene;
        if (simpleScene == null) {
            return;
        }
        if (simpleScene.hasParent()) {
            throw new AlreadyParentedException(HAS_PARENT_MSG);
        }
        simpleScene.setUpdateHandler(this.updateHandler);
        simpleScene.setViewportDimensions(this.viewX, this.viewY, this.viewWidth, this.viewHeight);
        simpleScene.setLive(this.alive);
    }

    public SimpleScene getScene() {
        return this.scene;
    }

    private class InternalUpdater
    implements InternalLayerUpdateListener {
        private InternalUpdater() {
        }

        public void disableActiveAudioState() {
            SimpleViewport.this.activeSoundLayer = false;
        }
    }
}

