/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import org.j3d.aviatrix3d.AlreadyParentedException;
import org.j3d.aviatrix3d.InternalLayerUpdateListener;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Layer;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.Viewport2D;
import org.j3d.aviatrix3d.rendering.ViewportCullable;

public class SimpleLayer2D
extends Layer {
    private static final String HAS_PARENT_MSG = "This Layer already has a parent. Scenes cannot be shared amongst layers multiple times.";
    private Viewport2D viewport;
    private boolean activeSoundLayer = false;
    private InternalUpdater internalUpdater;

    public SimpleLayer2D() {
        super(2);
    }

    public ViewportCullable getCullableViewport(int n) {
        return this.viewport instanceof ViewportCullable ? this.viewport : null;
    }

    public int numCullableChildren() {
        return this.viewport != null ? 1 : 0;
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        if (this.viewport != null) {
            this.viewport.setUpdateHandler(nodeUpdateHandler);
        }
    }

    protected void setLive(boolean bl) {
        super.setLive(bl);
        if (this.viewport != null) {
            this.viewport.setLive(bl);
        }
    }

    public void makeActiveSoundLayer() throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.activeSoundLayer = true;
        if (this.updateHandler != null) {
            if (this.internalUpdater == null) {
                this.internalUpdater = new InternalUpdater();
            }
            this.updateHandler.activeSoundLayerChanged(this.internalUpdater);
        }
    }

    public boolean isActiveSoundLayer() {
        return this.activeSoundLayer;
    }

    public void setViewport(Viewport2D viewport2D) throws InvalidWriteTimingException, AlreadyParentedException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.viewport = viewport2D;
        if (viewport2D == null) {
            return;
        }
        if (viewport2D.hasParent()) {
            throw new AlreadyParentedException(HAS_PARENT_MSG);
        }
        viewport2D.setUpdateHandler(this.updateHandler);
        viewport2D.setLive(this.alive);
    }

    public Viewport2D getViewport() {
        return this.viewport;
    }

    private class InternalUpdater
    implements InternalLayerUpdateListener {
        private InternalUpdater() {
        }

        public void disableActiveAudioState() {
            SimpleLayer2D.this.activeSoundLayer = false;
        }
    }
}

