/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import org.j3d.aviatrix3d.AlreadyParentedException;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Layer;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.Viewport;
import org.j3d.aviatrix3d.rendering.ViewportCullable;

public class SimpleLayer
extends Layer {
    private static final String HAS_PARENT_MSG = "This Layer already has a parent. Scenes cannot be shared amongst layers multiple times.";
    private Viewport viewport;

    public SimpleLayer() {
        super(0);
    }

    public ViewportCullable getCullableViewport(int n) {
        return this.viewport instanceof ViewportCullable ? (ViewportCullable)((Object)this.viewport) : null;
    }

    public int numCullableChildren() {
        return this.viewport != null ? 1 : 0;
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        if (this.viewport != null) {
            this.viewport.setUpdateHandler(nodeUpdateHandler);
        }
    }

    protected void setLive(boolean bl) {
        super.setLive(bl);
        if (this.viewport != null) {
            this.viewport.setLive(bl);
        }
    }

    public void setViewport(Viewport viewport) throws InvalidWriteTimingException, AlreadyParentedException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.viewport = viewport;
        if (viewport == null) {
            return;
        }
        if (viewport.hasParent()) {
            throw new AlreadyParentedException(HAS_PARENT_MSG);
        }
        viewport.setUpdateHandler(this.updateHandler);
        viewport.setLive(this.alive);
    }

    public Viewport getViewport() {
        return this.viewport;
    }
}

