/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import org.j3d.aviatrix3d.AlreadyParentedException;
import org.j3d.aviatrix3d.CyclicSceneGraphStructureException;
import org.j3d.aviatrix3d.Group2D;
import org.j3d.aviatrix3d.InvalidNodeTypeException;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.Node2D;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.picking.InvalidPickTimingException;
import org.j3d.aviatrix3d.picking.NotPickableException;
import org.j3d.aviatrix3d.picking.PickRequest;
import org.j3d.aviatrix3d.picking.PickTarget;
import org.j3d.aviatrix3d.picking.PickableObject;
import org.j3d.aviatrix3d.picking.PickingManager;
import org.j3d.aviatrix3d.picking.SinglePickTarget;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.j3d.aviatrix3d.rendering.Cullable;
import org.j3d.aviatrix3d.rendering.SingleCullable;

public class SharedNode2D
extends Node2D
implements PickableObject,
SinglePickTarget,
SingleCullable {
    private static final String PICK_TIMING_MSG = "Picking not permitted right now. Picking is only permitted during the update observer callbacks.";
    private static final String PICKABLE_FALSE_MSG = "This node has been marked as not pickable by the user";
    private static final String NOT_GROUP_MSG = "Attempting to set a shared node into a node that is not a Group node or SharedNode2D instance";
    private static final String NULL_PARENT_ARRAY_MSG = "Cannot fetch parents as provided array is null";
    private static final int LIST_START_SIZE = 5;
    private static final int LIST_INCREMENT = 5;
    private Group2D[] parentList = new Group2D[5];
    private int lastParentList = 0;
    private int liveCount = 0;
    private Node2D sharedChild;
    private int pickFlags = -1;

    public Cullable getCullableChild() {
        if (this.sharedChild instanceof Cullable) {
            return (Cullable)((Object)this.sharedChild);
        }
        return null;
    }

    public boolean hasMultipleParents() {
        return true;
    }

    public Cullable getCullableParent() {
        return null;
    }

    protected void markBoundsDirty() {
        if (this.implicitBounds) {
            for (int i = 0; i < this.lastParentList; ++i) {
                this.parentList[i].markBoundsDirty();
            }
        }
    }

    protected void recomputeBounds() {
        if (!this.alive || !this.implicitBounds) {
            return;
        }
        this.bounds = this.sharedChild == null ? INVALID_BOUNDS : this.sharedChild.getBounds();
    }

    public void requestBoundsUpdate() {
        if (this.alive || !this.implicitBounds) {
            return;
        }
        this.sharedChild.requestBoundsUpdate();
        this.recomputeBounds();
    }

    protected void updateBounds() {
        if (!this.implicitBounds) {
            return;
        }
        this.recomputeBounds();
        for (int i = 0; i < this.lastParentList; ++i) {
            this.parentList[i].updateBounds();
        }
    }

    protected void setParent(Node node) throws AlreadyParentedException, InvalidNodeTypeException, CyclicSceneGraphStructureException {
        if (node != null && !(node instanceof Group2D) && !(node instanceof SharedNode2D)) {
            throw new InvalidNodeTypeException(NOT_GROUP_MSG);
        }
        for (int i = 0; i < this.lastParentList; ++i) {
            if (this.parentList[i] != node) continue;
            return;
        }
        this.checkForCyclicParent(node);
        this.resizeList();
        this.parentList[this.lastParentList++] = (Group2D)node;
    }

    protected void removeParent(Node node) {
        for (int i = 0; i < this.lastParentList; ++i) {
            if (this.parentList[i] != node) continue;
            int n = this.lastParentList - i;
            if (n != 0) {
                System.arraycopy(this.parentList, i, this.parentList, i + 1, n);
            }
            --this.lastParentList;
            break;
        }
    }

    public Node getParent() {
        return this.parentList[0];
    }

    protected void setLive(boolean bl) {
        if (bl) {
            ++this.liveCount;
        } else if (this.liveCount > 0) {
            --this.liveCount;
        }
        if (this.liveCount == 0 || !this.alive) {
            this.sharedChild.setLive(bl);
            super.setLive(bl);
        }
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        this.updateHandler = nodeUpdateHandler;
        if (this.sharedChild != null) {
            this.sharedChild.setUpdateHandler(nodeUpdateHandler);
        }
    }

    protected void checkForCyclicParent(SceneGraphObject sceneGraphObject) throws CyclicSceneGraphStructureException {
        if (sceneGraphObject == this) {
            throw new CyclicSceneGraphStructureException();
        }
        for (int i = 0; i < this.lastParentList; ++i) {
            this.parentList[i].checkForCyclicParent(sceneGraphObject);
        }
    }

    public void setPickMask(int n) {
        this.pickFlags = n;
    }

    public int getPickMask() {
        return this.pickFlags;
    }

    public void pickBatch(PickRequest[] pickRequestArray, int n) throws NotPickableException, InvalidPickTimingException {
        if (this.updateHandler == null || !this.updateHandler.isPickingPermitted()) {
            throw new InvalidPickTimingException(PICK_TIMING_MSG);
        }
        if (this.pickFlags == 0) {
            throw new NotPickableException(PICKABLE_FALSE_MSG);
        }
        PickingManager pickingManager = this.updateHandler.getPickingManager();
        pickingManager.pickBatch(this, pickRequestArray, n);
    }

    public void pickSingle(PickRequest pickRequest) throws NotPickableException, InvalidPickTimingException {
        if (this.updateHandler == null || !this.updateHandler.isPickingPermitted()) {
            throw new InvalidPickTimingException(PICK_TIMING_MSG);
        }
        if (this.pickFlags == 0) {
            throw new NotPickableException(PICKABLE_FALSE_MSG);
        }
        PickingManager pickingManager = this.updateHandler.getPickingManager();
        pickingManager.pickSingle(this, pickRequest);
    }

    public PickTarget getPickableChild() {
        return this.sharedChild instanceof PickTarget ? (PickTarget)((Object)this.sharedChild) : null;
    }

    public final int getPickTargetType() {
        return 2;
    }

    public boolean checkPickMask(int n) {
        return (this.pickFlags & n) != 0;
    }

    public BoundingVolume getPickableBounds() {
        return this.bounds;
    }

    public int numParents() {
        return this.lastParentList;
    }

    public void getParents(Node2D[] node2DArray) {
        if (node2DArray == null) {
            throw new NullPointerException(NULL_PARENT_ARRAY_MSG);
        }
        System.arraycopy(this.parentList, 0, node2DArray, 0, this.lastParentList);
    }

    public void setChild(Node2D node2D) throws CyclicSceneGraphStructureException {
        if (this.sharedChild != null) {
            this.sharedChild.setLive(false);
            this.sharedChild.removeParent(this);
        }
        this.sharedChild = node2D;
        if (this.sharedChild != null) {
            this.sharedChild.setParent(this);
            this.sharedChild.setLive(this.alive);
            this.sharedChild.setUpdateHandler(this.updateHandler);
        } else {
            this.bounds = INVALID_BOUNDS;
        }
    }

    public Node2D getChild() {
        return this.sharedChild;
    }

    private final void resizeList() {
        if (this.lastParentList + 1 == this.parentList.length) {
            int n = this.parentList.length;
            int n2 = n + 5;
            Group2D[] group2DArray = new Group2D[n2];
            System.arraycopy(this.parentList, 0, group2DArray, 0, n);
            this.parentList = group2DArray;
        }
    }
}

