/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import org.j3d.aviatrix3d.AlreadyParentedException;
import org.j3d.aviatrix3d.CyclicSceneGraphStructureException;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.InvalidNodeTypeException;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.TransformHierarchy;
import org.j3d.aviatrix3d.rendering.Cullable;

public class SharedGroup
extends Group {
    private static final String NOT_GROUP_MSG = "Attempting to set a shared group into a node that is not a group node instance";
    private static final int LIST_START_SIZE = 5;
    private static final int LIST_INCREMENT = 5;
    private Node[] parentList = new Node[5];
    private int lastParentList = 0;
    private int liveCount = 0;

    public boolean hasMultipleParents() {
        return true;
    }

    public Cullable getCullableParent() {
        return null;
    }

    protected void markBoundsDirty() {
        if (this.dirtyBoundsCount < this.lastChild) {
            ++this.dirtyBoundsCount;
        }
        if (this.implicitBounds && this.dirtyBoundsCount == 1) {
            for (int i = 0; i < this.lastParentList; ++i) {
                this.parentList[i].markBoundsDirty();
            }
        }
    }

    protected void updateBounds() {
        if (this.dirtyBoundsCount > 1) {
            --this.dirtyBoundsCount;
            return;
        }
        if (!this.implicitBounds) {
            return;
        }
        if (this.lastChild == 0) {
            this.bounds = INVALID_BOUNDS;
        } else {
            this.recomputeBounds();
        }
        this.dirtyBoundsCount = 0;
        for (int i = 0; i < this.lastParentList; ++i) {
            this.parentList[i].updateBounds();
        }
    }

    protected void setParent(Node node) throws AlreadyParentedException, InvalidNodeTypeException {
        if (node != null && !(node instanceof TransformHierarchy)) {
            throw new InvalidNodeTypeException(NOT_GROUP_MSG);
        }
        for (int i = 0; i < this.lastParentList; ++i) {
            if (this.parentList[i] != node) continue;
            return;
        }
        this.resizeList();
        this.parentList[this.lastParentList++] = node;
    }

    protected void removeParent(Node node) {
        for (int i = 0; i < this.lastParentList; ++i) {
            if (this.parentList[i] != node) continue;
            int n = this.lastParentList - i;
            if (n != 0) {
                System.arraycopy(this.parentList, i, this.parentList, i + 1, n);
            }
            --this.lastParentList;
            break;
        }
    }

    public Node getParent() {
        return this.parentList[0];
    }

    protected void setLive(boolean bl) {
        if (bl) {
            ++this.liveCount;
        } else if (this.liveCount > 0) {
            --this.liveCount;
        }
        if (this.liveCount == 0 || !this.alive) {
            super.setLive(bl);
        }
        this.dirtyBoundsCount = 0;
    }

    protected void checkForCyclicParent(SceneGraphObject sceneGraphObject) throws CyclicSceneGraphStructureException {
        if (sceneGraphObject == this) {
            throw new CyclicSceneGraphStructureException();
        }
        for (int i = 0; i < this.lastParentList; ++i) {
            this.parentList[i].checkForCyclicParent(sceneGraphObject);
        }
    }

    public int numParents() {
        return this.lastParentList;
    }

    public void getParents(Node[] nodeArray) {
        if (nodeArray == null) {
            throw new NullPointerException("Parent array is null");
        }
        System.arraycopy(this.parentList, 0, nodeArray, 0, this.lastParentList);
    }

    private final void resizeList() {
        if (this.lastParentList + 1 == this.parentList.length) {
            int n = this.parentList.length;
            int n2 = n + 5;
            Node[] nodeArray = new Node[n2];
            System.arraycopy(this.parentList, 0, nodeArray, 0, n);
            this.parentList = nodeArray;
        }
    }
}

