/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import javax.media.opengl.GL;
import org.j3d.aviatrix3d.Background;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.Shape3D;

public class ShapeBackground
extends Background {
    private Shape3D[] geometry = new Shape3D[5];
    private int numGeometry = 0;

    public ShapeBackground() {
        this(null);
    }

    public ShapeBackground(float[] fArray) {
        super(fArray);
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        for (int i = 0; i < this.numGeometry; ++i) {
            if (this.geometry[i] == null) continue;
            this.geometry[i].setUpdateHandler(nodeUpdateHandler);
        }
    }

    protected void setLive(boolean bl) {
        for (int i = 0; i < this.numGeometry; ++i) {
            if (this.geometry[i] == null) continue;
            this.geometry[i].setLive(bl);
        }
        super.setLive(bl);
    }

    public boolean is2D() {
        return false;
    }

    public void render(GL gL) {
        if (this.useClearColor) {
            gL.glClearColor(this.color[0], this.color[1], this.color[2], this.color[3]);
            gL.glClear(16384);
        }
        for (int i = 0; i < this.numGeometry; ++i) {
            if (!this.geometry[i].isVisible()) continue;
            this.geometry[i].render(gL);
            this.geometry[i].postRender(gL);
        }
    }

    public void postRender(GL gL) {
    }

    public int compareTo(Object object) throws ClassCastException {
        ShapeBackground shapeBackground = (ShapeBackground)object;
        return this.compareTo(shapeBackground);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShapeBackground)) {
            return false;
        }
        return this.equals((ShapeBackground)object);
    }

    public void addShape(Shape3D shape3D) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (shape3D == null) {
            return;
        }
        if (this.numGeometry == this.geometry.length) {
            Shape3D[] shape3DArray = new Shape3D[this.numGeometry + 5];
            System.arraycopy(this.geometry, 0, shape3DArray, 0, this.numGeometry);
            this.geometry = shape3DArray;
        }
        this.geometry[this.numGeometry++] = shape3D;
        if (shape3D.isLive() != this.alive) {
            shape3D.setLive(this.alive);
        }
        shape3D.setParent(this);
        shape3D.setUpdateHandler(this.updateHandler);
    }

    public Shape3D removeShape(int n) {
        int n2;
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n < 0 || n >= this.numGeometry) {
            throw new IllegalArgumentException("idx Is out of bounds");
        }
        Shape3D shape3D = this.geometry[n];
        if (this.geometry[n] != null) {
            this.geometry[n].setLive(false);
            this.geometry[n].removeParent(this);
        }
        if (n != (n2 = this.numGeometry - 1)) {
            System.arraycopy(this.geometry, n + 1, this.geometry, n, n2 - n);
        }
        this.geometry[n2] = null;
        --this.numGeometry;
        return shape3D;
    }

    public void setShape(Shape3D shape3D, int n) {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (shape3D == null) {
            throw new IllegalArgumentException("Null shape provided");
        }
        if (n < 0 || n >= this.numGeometry) {
            throw new IllegalArgumentException("idx Is out of bounds");
        }
        if (this.geometry[n] != null) {
            this.geometry[n].setLive(false);
            this.geometry[n].removeParent(this);
        }
        this.geometry[n] = shape3D;
        if (shape3D.isLive() != this.alive) {
            shape3D.setLive(this.alive);
        }
        shape3D.setParent(this);
        shape3D.setUpdateHandler(this.updateHandler);
    }

    public Shape3D getShape(int n) {
        if (n < 0 || n >= this.numGeometry) {
            throw new IllegalArgumentException("idx Is out of bounds");
        }
        return this.geometry[n];
    }

    public int compareTo(ShapeBackground shapeBackground) {
        if (shapeBackground == null) {
            return 1;
        }
        if (shapeBackground == this) {
            return 0;
        }
        int n = this.compareColor4(this.color, shapeBackground.color);
        if (n != 0) {
            return n;
        }
        for (int i = 0; i < 6; ++i) {
            if (this.geometry[i] == shapeBackground.geometry[i]) continue;
            if (this.geometry[i] == null) {
                return -1;
            }
            if (shapeBackground.geometry[i] == null) {
                return 1;
            }
            if (this.geometry[i] == shapeBackground.geometry[i]) continue;
            return this.geometry[i].hashCode() < shapeBackground.geometry[i].hashCode() ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(ShapeBackground shapeBackground) {
        if (shapeBackground == this) {
            return true;
        }
        if (shapeBackground == null) {
            return false;
        }
        if (!this.equalsColor4(this.color, shapeBackground.color)) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            if (this.geometry[i] == shapeBackground.geometry[i]) continue;
            return false;
        }
        return true;
    }
}

