/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import javax.media.opengl.GL;
import org.j3d.aviatrix3d.Appearance;
import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.BoundingVoid;
import org.j3d.aviatrix3d.CyclicSceneGraphStructureException;
import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Leaf;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.picking.InvalidPickTimingException;
import org.j3d.aviatrix3d.picking.NotPickableException;
import org.j3d.aviatrix3d.picking.PickRequest;
import org.j3d.aviatrix3d.picking.PickTarget;
import org.j3d.aviatrix3d.picking.PickableObject;
import org.j3d.aviatrix3d.picking.PickingManager;
import org.j3d.aviatrix3d.picking.SinglePickTarget;
import org.j3d.aviatrix3d.rendering.AppearanceRenderable;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.j3d.aviatrix3d.rendering.GeometryRenderable;
import org.j3d.aviatrix3d.rendering.LeafCullable;
import org.j3d.aviatrix3d.rendering.ObjectRenderable;
import org.j3d.aviatrix3d.rendering.Renderable;
import org.j3d.aviatrix3d.rendering.ShapeRenderable;

public class Shape3D
extends Leaf
implements PickableObject,
SinglePickTarget,
LeafCullable,
ShapeRenderable,
ObjectRenderable {
    private static final String PICK_TIMING_MSG = "Picking not permitted right now. Picking is only permitted during the update observer callbacks.";
    private static final String PICKABLE_FALSE_MSG = "This node has been marked as not pickable by the user";
    private Geometry geom;
    private Appearance app;
    private int pickFlags = -1;

    public int getCullableType() {
        return 4;
    }

    public Renderable getRenderable() {
        return this;
    }

    public boolean isVisible() {
        boolean bl = this.app != null ? this.app.isVisible() : true;
        boolean bl2 = this.geom != null ? this.geom.isVisible() : false;
        return bl2 && bl;
    }

    public boolean is2D() {
        return false;
    }

    public GeometryRenderable getGeometryRenderable() {
        return this.geom;
    }

    public AppearanceRenderable getAppearanceRenderable() {
        return this.app;
    }

    public void render(GL gL) {
        if (this.app != null) {
            this.app.render(gL);
        }
        if (this.geom != null) {
            this.geom.render(gL);
        }
    }

    public void postRender(GL gL) {
        if (this.app != null) {
            this.app.postRender(gL);
        }
    }

    protected void updateBounds() {
        this.recomputeBounds();
        if (this.parent != null) {
            this.parent.updateBounds();
        }
    }

    protected void recomputeBounds() {
        if (!this.implicitBounds) {
            return;
        }
        if (this.geom == null) {
            this.bounds = INVALID_BOUNDS;
        } else {
            if (this.bounds == null || this.bounds == INVALID_BOUNDS) {
                this.bounds = new BoundingBox();
            }
            BoundingBox boundingBox = (BoundingBox)this.bounds;
            BoundingVolume boundingVolume = this.geom.getBounds();
            if (boundingVolume instanceof BoundingVoid) {
                this.bounds = INVALID_BOUNDS;
            } else {
                float[] fArray = new float[3];
                float[] fArray2 = new float[3];
                boundingVolume.getExtents(fArray, fArray2);
                boundingBox.setMinimum(fArray);
                boundingBox.setMaximum(fArray2);
            }
        }
    }

    public void requestBoundsUpdate() {
        if (this.alive || !this.implicitBounds || this.geom == null || this.geom.isLive()) {
            return;
        }
        this.geom.recomputeBounds();
        this.recomputeBounds();
    }

    protected void setLive(boolean bl) {
        if (this.geom != null) {
            this.geom.setLive(bl);
        }
        if (this.app != null) {
            this.app.setLive(bl);
        }
        super.setLive(bl);
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        if (this.app != null) {
            this.app.setUpdateHandler(this.updateHandler);
        }
        if (this.geom != null) {
            this.geom.setUpdateHandler(this.updateHandler);
        }
    }

    protected void checkForCyclicChild(SceneGraphObject sceneGraphObject) throws CyclicSceneGraphStructureException {
        if (sceneGraphObject == this) {
            throw new CyclicSceneGraphStructureException();
        }
        if (this.app != null) {
            this.app.checkForCyclicChild(sceneGraphObject);
        }
    }

    public void setPickMask(int n) {
        this.pickFlags = n;
    }

    public int getPickMask() {
        return this.pickFlags;
    }

    public void pickBatch(PickRequest[] pickRequestArray, int n) throws NotPickableException, InvalidPickTimingException {
        if (this.updateHandler == null || !this.updateHandler.isPickingPermitted()) {
            throw new InvalidPickTimingException(PICK_TIMING_MSG);
        }
        if (this.pickFlags == 0) {
            throw new NotPickableException(PICKABLE_FALSE_MSG);
        }
        PickingManager pickingManager = this.updateHandler.getPickingManager();
        pickingManager.pickBatch(this, pickRequestArray, n);
    }

    public void pickSingle(PickRequest pickRequest) throws NotPickableException, InvalidPickTimingException {
        if (this.updateHandler == null || !this.updateHandler.isPickingPermitted()) {
            throw new InvalidPickTimingException(PICK_TIMING_MSG);
        }
        if (this.pickFlags == 0) {
            throw new NotPickableException(PICKABLE_FALSE_MSG);
        }
        PickingManager pickingManager = this.updateHandler.getPickingManager();
        pickingManager.pickSingle(this, pickRequest);
    }

    public PickTarget getPickableChild() {
        return this.geom instanceof PickTarget ? this.geom : null;
    }

    public final int getPickTargetType() {
        return 2;
    }

    public boolean checkPickMask(int n) {
        return (this.pickFlags & n) != 0;
    }

    public BoundingVolume getPickableBounds() {
        return this.bounds;
    }

    public int compareTo(Object object) throws ClassCastException {
        Shape3D shape3D = (Shape3D)object;
        return this.compareTo(shape3D);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Shape3D)) {
            return false;
        }
        return this.equals((Shape3D)object);
    }

    public Geometry getGeometry() {
        return this.geom;
    }

    public void setGeometry(Geometry geometry) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.geom != null) {
            this.geom.setLive(false);
            this.geom.removeParent(this);
        }
        this.geom = geometry;
        if (this.geom != null) {
            this.geom.addParent(this);
            this.geom.setLive(this.alive);
            this.geom.setUpdateHandler(this.updateHandler);
        }
    }

    public Appearance getAppearance() {
        return this.app;
    }

    public void setAppearance(Appearance appearance) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.app != null) {
            this.app.setLive(false);
        }
        this.app = appearance;
        if (this.app != null) {
            this.app.setLive(this.alive);
            this.app.setUpdateHandler(this.updateHandler);
        }
    }

    public int compareTo(Shape3D shape3D) {
        int n;
        if (shape3D == null) {
            return 1;
        }
        if (shape3D == this) {
            return 0;
        }
        if (this.app != shape3D.app) {
            if (this.app == null) {
                return -1;
            }
            if (shape3D.app == null) {
                return 1;
            }
            n = this.app.compareTo(shape3D.app);
            if (n != 0) {
                return n;
            }
        }
        if (this.geom != shape3D.geom) {
            if (this.geom == null) {
                return -1;
            }
            if (shape3D.geom == null) {
                return 1;
            }
            n = this.geom.compareTo(shape3D.geom);
            if (n != 0) {
                return n;
            }
        }
        return 0;
    }

    public boolean equals(Shape3D shape3D) {
        if (shape3D == this) {
            return true;
        }
        if (shape3D == null) {
            return false;
        }
        if (!(this.app == shape3D.app || this.app != null && this.app.equals(shape3D.app))) {
            return false;
        }
        return this.geom == shape3D.geom || this.geom != null && this.geom.equals(shape3D.geom);
    }
}

