/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.media.opengl.GL;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.NodeComponent;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.ShaderObject;
import org.j3d.aviatrix3d.rendering.DeletableRenderable;
import org.j3d.aviatrix3d.rendering.ShaderComponentRenderable;
import org.j3d.aviatrix3d.rendering.ShaderSourceRenderable;

public class ShaderProgram
extends NodeComponent
implements DeletableRenderable,
ShaderSourceRenderable,
ShaderComponentRenderable {
    private boolean logRequested = false;
    private HashMap<GL, Boolean> linked;
    private boolean confirmLink = false;
    private ArrayList<ShaderObject> pendingAdds;
    private ArrayList<ShaderObject> pendingDeletes;
    private ArrayList<ShaderObject> currentObjects = new ArrayList();
    private HashMap<String, Integer> attributeNames = new HashMap();
    private HashMap<GL, Integer> programIdMap = new HashMap();
    private String infoString;

    public ShaderProgram() {
        this.linked = new HashMap();
    }

    public int getComponentType() {
        return 4;
    }

    public boolean isValid(GL gL) {
        Integer n = this.programIdMap.get(gL);
        return n != null;
    }

    public int getProgramId(GL gL) {
        Integer n = this.programIdMap.get(gL);
        return n == null ? 0 : n;
    }

    public void render(GL gL) {
        Boolean bl = this.linked.get(gL);
        if (bl == null || !bl.booleanValue()) {
            return;
        }
        this.initialize(gL);
        Integer n = this.programIdMap.get(gL);
        if (n == null) {
            return;
        }
        gL.glUseProgramObjectARB(n.intValue());
    }

    public void postRender(GL gL) {
        gL.glUseProgramObjectARB(0);
    }

    public void initialize(GL gL) {
        int n;
        int n2;
        Boolean bl = this.linked.get(gL);
        if (bl != null && bl.booleanValue()) {
            return;
        }
        boolean bl2 = false;
        Integer n3 = this.programIdMap.get(gL);
        int n4 = 0;
        if (n3 == null) {
            n4 = gL.glCreateProgramObjectARB();
            this.programIdMap.put(gL, new Integer(n4));
            bl2 = true;
        } else {
            n4 = n3;
        }
        if (!bl2 && this.pendingDeletes != null) {
            n2 = this.pendingDeletes.size();
            for (n = 0; n < n2; ++n) {
                ShaderObject object2 = this.pendingDeletes.get(n);
                gL.glDetachObjectARB(n4, object2.getShaderId(gL));
            }
            this.pendingDeletes = null;
        }
        if (!bl2 && this.pendingAdds != null) {
            n2 = this.pendingAdds.size();
            for (n = 0; n < n2; ++n) {
                ShaderObject shaderObject = this.pendingAdds.get(n);
                if (!shaderObject.isCompiled(gL)) {
                    shaderObject.initialize(gL);
                }
                gL.glAttachObjectARB(n4, shaderObject.getShaderId(gL));
            }
            this.pendingAdds = null;
        }
        if (bl2) {
            n2 = this.currentObjects.size();
            for (n = 0; n < n2; ++n) {
                ShaderObject shaderObject = this.currentObjects.get(n);
                if (!shaderObject.isCompiled(gL)) {
                    shaderObject.initialize(gL);
                }
                gL.glAttachObjectARB(n4, shaderObject.getShaderId(gL));
            }
        }
        if (this.attributeNames.size() != 0) {
            Set<Map.Entry<String, Integer>> set = this.attributeNames.entrySet();
            for (Map.Entry<String, Integer> entry : set) {
                gL.glBindAttribLocationARB(n4, entry.getValue().intValue(), entry.getKey());
            }
        }
        gL.glLinkProgramARB(n4);
        if (this.confirmLink) {
            int[] nArray = new int[1];
            gL.glGetObjectParameterivARB(n4, 35714, nArray, 0);
            this.linked.put(gL, nArray[0] == 1 ? Boolean.TRUE : Boolean.FALSE);
        } else {
            this.linked.put(gL, Boolean.TRUE);
        }
    }

    public void fetchLogInfo(GL gL) {
        Integer n = this.programIdMap.get(gL);
        if (n == null) {
            return;
        }
        int n2 = n;
        int[] nArray = new int[1];
        gL.glGetObjectParameterivARB(n2, 35716, nArray, 0);
        if (nArray[0] > 0) {
            byte[] byArray = new byte[nArray[0]];
            gL.glGetInfoLogARB(n2, byArray.length, nArray, 0, byArray, 0);
            this.infoString = new String(byArray, 0, nArray[0]);
        } else {
            this.infoString = null;
        }
        this.logRequested = false;
    }

    public void cleanup(GL gL) {
        Integer n = this.programIdMap.remove(gL);
        if (n == null) {
            return;
        }
        int n2 = n;
        gL.glDeleteObjectARB(n2);
        this.linked.remove(gL);
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        int n = this.currentObjects.size();
        for (int i = 0; i < n; ++i) {
            ShaderObject shaderObject = this.currentObjects.get(i);
            shaderObject.setUpdateHandler(this.updateHandler);
        }
        if (this.linked.size() == 0 && this.updateHandler != null) {
            this.updateHandler.shaderRequiresInit(this, true);
        }
        if (this.logRequested && this.updateHandler != null) {
            this.updateHandler.shaderRequiresLogInfo(this, true);
        }
    }

    protected void setLive(boolean bl) {
        if (bl) {
            ++this.liveCount;
        } else if (this.liveCount > 0) {
            --this.liveCount;
        }
        if (this.liveCount == 0 || !this.alive) {
            int n = this.currentObjects.size();
            for (int i = 0; i < n; ++i) {
                ShaderObject shaderObject = this.currentObjects.get(i);
                shaderObject.setLive(bl);
            }
            super.setLive(bl);
            if (!bl && this.updateHandler != null) {
                this.updateHandler.requestDeletion(this);
            }
        }
    }

    public int compareTo(Object object) throws ClassCastException {
        ShaderProgram shaderProgram = (ShaderProgram)object;
        return this.compareTo(shaderProgram);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShaderProgram)) {
            return false;
        }
        return this.equals((ShaderProgram)object);
    }

    public void addShaderObject(ShaderObject shaderObject) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (!this.currentObjects.contains(shaderObject)) {
            if (this.pendingAdds == null) {
                this.pendingAdds = new ArrayList();
            }
            this.currentObjects.add(shaderObject);
            this.pendingAdds.add(shaderObject);
        }
    }

    public void removeShaderObject(ShaderObject shaderObject) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.currentObjects.contains(shaderObject)) {
            if (this.pendingDeletes == null) {
                this.pendingDeletes = new ArrayList();
            }
            this.currentObjects.remove(shaderObject);
            this.pendingDeletes.add(shaderObject);
        }
    }

    public int getNumShaderObjects() {
        return this.currentObjects.size();
    }

    public void getShaderObjects(ShaderObject[] shaderObjectArray) {
        this.currentObjects.toArray(shaderObjectArray);
    }

    public void link() throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.linked.clear();
        if (this.updateHandler != null) {
            this.updateHandler.shaderRequiresInit(this, false);
        }
    }

    public void requestInfoLog() throws InvalidWriteTimingException {
        if (this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.updateHandler != null) {
            this.updateHandler.shaderRequiresLogInfo(this, false);
        }
        this.logRequested = true;
    }

    public String getLastInfoLog() {
        return this.infoString;
    }

    public void bindAttributeName(String string, int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.attributeNames.put(string, new Integer(n));
    }

    public void requestLinkConfirmation(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.confirmLink = bl;
    }

    public boolean isLinkConfirmed() {
        return this.confirmLink;
    }

    public int compareTo(ShaderProgram shaderProgram) {
        if (shaderProgram == null) {
            return 1;
        }
        if (shaderProgram == this) {
            return 0;
        }
        return 0;
    }

    public boolean equals(ShaderProgram shaderProgram) {
        if (shaderProgram == this) {
            return true;
        }
        if (shaderProgram == null) {
            return false;
        }
        if (this.currentObjects.size() != shaderProgram.currentObjects.size()) {
            return false;
        }
        return false;
    }
}

