/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.util.HashMap;
import javax.media.opengl.GL;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.rendering.ShaderSourceRenderable;

public class ShaderObject
extends SceneGraphObject
implements ShaderSourceRenderable {
    private String[] sourceStrings;
    private HashMap<GL, Integer> objectIdMap;
    private boolean vertexSource;
    private HashMap<GL, Boolean> compiled;
    private boolean confirmCompile;
    private boolean logRequested;
    private String infoString;

    public ShaderObject(boolean bl) {
        this.vertexSource = bl;
        this.logRequested = false;
        this.confirmCompile = false;
        this.compiled = new HashMap();
        this.objectIdMap = new HashMap();
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        if (this.compiled.size() == 0 && this.updateHandler != null) {
            this.updateHandler.shaderRequiresInit(this, true);
        }
        if (this.logRequested && this.updateHandler != null) {
            this.updateHandler.shaderRequiresLogInfo(this, true);
        }
    }

    public void initialize(GL gL) {
        Boolean bl = this.compiled.get(gL);
        if (bl != null && bl.booleanValue() || this.sourceStrings == null) {
            return;
        }
        Integer n = this.objectIdMap.get(gL);
        int n2 = 0;
        if (n == null) {
            int n3 = this.vertexSource ? 35633 : 35632;
            n2 = gL.glCreateShaderObjectARB(n3);
            this.objectIdMap.put(gL, new Integer(n2));
        } else {
            n2 = n;
        }
        gL.glShaderSourceARB(n2, this.sourceStrings.length, this.sourceStrings, (int[])null, 0);
        gL.glCompileShaderARB(n2);
        if (this.confirmCompile) {
            int[] nArray = new int[1];
            gL.glGetObjectParameterivARB(n2, 35713, nArray, 0);
            this.compiled.put(gL, nArray[0] == 1 ? Boolean.TRUE : Boolean.FALSE);
        } else {
            this.compiled.put(gL, Boolean.TRUE);
        }
    }

    public void fetchLogInfo(GL gL) {
        Integer n = this.objectIdMap.get(gL);
        if (n == null) {
            return;
        }
        int n2 = n;
        int[] nArray = new int[1];
        gL.glGetObjectParameterivARB(n2, 35716, nArray, 0);
        if (nArray[0] > 0) {
            byte[] byArray = new byte[nArray[0]];
            gL.glGetInfoLogARB(n2, byArray.length, nArray, 0, byArray, 0);
            this.infoString = new String(byArray, 0, nArray[0]);
        } else {
            this.infoString = null;
        }
        this.logRequested = false;
    }

    public int compareTo(Object object) throws ClassCastException {
        ShaderObject shaderObject = (ShaderObject)object;
        return this.compareTo(shaderObject);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShaderObject)) {
            return false;
        }
        return this.equals((ShaderObject)object);
    }

    public boolean isVertexShader() {
        return this.vertexSource;
    }

    public void setSourceStrings(String[] stringArray, int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (stringArray == null || stringArray.length == 0 || n == 0) {
            this.sourceStrings = null;
        } else {
            this.sourceStrings = new String[n];
            System.arraycopy(stringArray, 0, this.sourceStrings, 0, n);
        }
    }

    public String[] getSourceStrings() {
        return this.sourceStrings;
    }

    public void clearSourceStrings() {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.sourceStrings = null;
    }

    public void compile() {
        this.compiled.clear();
        if (this.updateHandler != null) {
            this.updateHandler.shaderRequiresInit(this, false);
        }
    }

    public void requestInfoLog() throws InvalidWriteTimingException {
        if (this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.updateHandler != null) {
            this.updateHandler.shaderRequiresLogInfo(this, false);
        }
        this.logRequested = true;
    }

    public String getLastInfoLog() {
        return this.infoString;
    }

    public boolean isCompiled() {
        return this.compiled.size() != 0;
    }

    protected boolean isCompiled(GL gL) {
        Boolean bl = this.compiled.get(gL);
        return bl != null && bl != false;
    }

    public void markForDeletion() {
    }

    public void requestCompilationConfirmation(boolean bl) {
        this.confirmCompile = bl;
    }

    public boolean isCompilationConfirmed(boolean bl) {
        return this.confirmCompile;
    }

    protected int getShaderId(GL gL) {
        Integer n = this.objectIdMap.get(gL);
        return n == null ? 0 : n;
    }

    public int compareTo(ShaderObject shaderObject) {
        if (shaderObject == null) {
            return 1;
        }
        if (shaderObject == this) {
            return 0;
        }
        if (this.sourceStrings != shaderObject.sourceStrings) {
            if (this.sourceStrings == null) {
                return -1;
            }
            if (shaderObject.sourceStrings == null) {
                return 1;
            }
            for (int i = 0; i < this.sourceStrings.length; ++i) {
                int n = this.sourceStrings[i].compareTo(shaderObject.sourceStrings[i]);
                if (n == 0) continue;
                return n;
            }
        }
        return 0;
    }

    public boolean equals(ShaderObject shaderObject) {
        if (shaderObject == this) {
            return true;
        }
        if (shaderObject == null) {
            return false;
        }
        if (this.sourceStrings != shaderObject.sourceStrings) {
            if (this.sourceStrings == null || shaderObject.sourceStrings == null) {
                return false;
            }
            for (int i = 0; i < this.sourceStrings.length; ++i) {
                if (this.sourceStrings[i].equals(shaderObject.sourceStrings[i])) continue;
                return false;
            }
        }
        return true;
    }
}

