/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

class ShaderArgumentValue {
    static final int INT_ARRAY = 1;
    static final int FLOAT_ARRAY = 2;
    static final int MATRIX = 3;
    static final int SAMPLER = 4;
    int dataType;
    int[] intData;
    float[] floatData;
    int size;
    int count;
    boolean transposeMatrix;
    int uniformLocation = -1;

    ShaderArgumentValue() {
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShaderArgumentValue)) {
            return false;
        }
        return this.equals((ShaderArgumentValue)object);
    }

    public boolean equals(ShaderArgumentValue shaderArgumentValue) {
        if (shaderArgumentValue == this) {
            return true;
        }
        if (shaderArgumentValue == null) {
            return false;
        }
        if (this.dataType != shaderArgumentValue.dataType || this.size != shaderArgumentValue.size || this.count != shaderArgumentValue.count || this.transposeMatrix != shaderArgumentValue.transposeMatrix || this.uniformLocation != shaderArgumentValue.uniformLocation) {
            return false;
        }
        int n = this.count * this.size;
        switch (this.dataType) {
            case 1: {
                for (int i = 0; i < n; ++i) {
                    if (this.intData[i] == shaderArgumentValue.intData[i]) continue;
                    return false;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n; ++i) {
                    if (this.floatData[i] == shaderArgumentValue.floatData[i]) continue;
                    return false;
                }
                break;
            }
            case 3: {
                n *= this.size;
                for (int i = 0; i < n; ++i) {
                    if (this.floatData[i] == shaderArgumentValue.floatData[i]) continue;
                    return false;
                }
                break;
            }
            case 4: {
                if (this.intData[0] == shaderArgumentValue.intData[0]) break;
                return false;
            }
        }
        return true;
    }
}

