/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import org.j3d.aviatrix3d.CyclicSceneGraphStructureException;
import org.j3d.aviatrix3d.InvalidListenerSetTimingException;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.NodeUpdateListener;

public abstract class SceneGraphObject {
    protected static final String WRITE_TIMING_MSG = "Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.";
    protected static final String LISTENER_SET_NOT_LIVE_MESSAGE = "Attempting to set a listener to this node when it is not live. Listeners can only be set once the node is live. When it is not live just directly set the values.";
    protected NodeUpdateHandler updateHandler;
    private Object userData;
    protected boolean alive;

    public void setUserData(Object object) {
        this.userData = object;
    }

    public Object getUserData() {
        return this.userData;
    }

    public boolean isLive() {
        return this.alive;
    }

    protected void setLive(boolean bl) {
        this.alive = bl;
    }

    protected void checkForCyclicParent(SceneGraphObject sceneGraphObject) throws CyclicSceneGraphStructureException {
        if (sceneGraphObject == this) {
            throw new CyclicSceneGraphStructureException();
        }
    }

    protected void checkForCyclicChild(SceneGraphObject sceneGraphObject) throws CyclicSceneGraphStructureException {
        if (sceneGraphObject == this) {
            throw new CyclicSceneGraphStructureException();
        }
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        this.updateHandler = nodeUpdateHandler;
    }

    public void dataChanged(NodeUpdateListener nodeUpdateListener) throws InvalidListenerSetTimingException {
        if (!this.isLive()) {
            throw new InvalidListenerSetTimingException(LISTENER_SET_NOT_LIVE_MESSAGE);
        }
        if (this.updateHandler == null) {
            return;
        }
        this.updateHandler.dataChanged(nodeUpdateListener, this);
    }
}

