/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import org.j3d.aviatrix3d.Background;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.Scene;
import org.j3d.aviatrix3d.SharedGroup;
import org.j3d.aviatrix3d.SharedGroup2D;
import org.j3d.aviatrix3d.SharedNode;
import org.j3d.aviatrix3d.SharedNode2D;
import org.j3d.aviatrix3d.Viewpoint;

public class Scene2D
extends Scene {
    private static final String SHARED_VP_MSG = "The path from the root of the scene graph to the viewpoint contains a SharedGroup or SharedNode instance. This is not permitted.";
    private static final String SHARED_BG_MSG = "The path from the root of the scene graph to the background contains a SharedGroup or SharedNode instance. This is not permitted.";
    private Group renderableObjects;
    private Viewpoint currentViewpoint;
    private Background currentBackground;

    protected void setLive(boolean bl) {
        super.setLive(bl);
        if (this.renderableObjects != null) {
            this.renderableObjects.setLive(bl);
        }
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        if (this.renderableObjects != null) {
            this.renderableObjects.setUpdateHandler(nodeUpdateHandler);
        }
    }

    public void setRenderedGeometry(Group group) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isPickingPermitted() && this.renderableObjects != null) {
            this.renderableObjects.setUpdateHandler(null);
            this.renderableObjects.setLive(false);
        }
        this.renderableObjects = group;
        if (this.renderableObjects != null) {
            this.renderableObjects.setUpdateHandler(this.updateHandler);
            this.renderableObjects.setLive(this.alive);
        }
    }

    public Group getRenderedGeometry() {
        return this.renderableObjects;
    }

    public void setActiveView(Viewpoint viewpoint) throws InvalidWriteTimingException, IllegalArgumentException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (viewpoint != null) {
            for (Node node = viewpoint.getParent(); node != null; node = node.getParent()) {
                if (!(node instanceof SharedGroup) && !(node instanceof SharedNode) && !(node instanceof SharedGroup2D) && !(node instanceof SharedNode2D)) continue;
                throw new IllegalArgumentException(SHARED_VP_MSG);
            }
        }
        this.currentViewpoint = viewpoint;
    }

    public Viewpoint getActiveView() {
        return this.currentViewpoint;
    }

    public void setActiveBackground(Background background) throws InvalidWriteTimingException, IllegalArgumentException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (background != null) {
            for (Node node = background.getParent(); node != null; node = node.getParent()) {
                if (!(node instanceof SharedGroup) && !(node instanceof SharedNode) && !(node instanceof SharedGroup2D) && !(node instanceof SharedNode2D)) continue;
                throw new IllegalArgumentException(SHARED_BG_MSG);
            }
        }
        this.currentBackground = background;
    }

    public Background getActiveBackground() {
        return this.currentBackground;
    }
}

