/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import org.j3d.aviatrix3d.AccumulationBufferState;
import org.j3d.aviatrix3d.ColorBufferState;
import org.j3d.aviatrix3d.DepthBufferState;
import org.j3d.aviatrix3d.Fog;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.InternalLayerUpdateListener;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.SharedGroup;
import org.j3d.aviatrix3d.SharedNode;
import org.j3d.aviatrix3d.StencilBufferState;
import org.j3d.aviatrix3d.ViewEnvironment;
import org.j3d.aviatrix3d.Viewpoint;
import org.j3d.aviatrix3d.rendering.BufferStateRenderable;
import org.j3d.aviatrix3d.rendering.Cullable;
import org.j3d.aviatrix3d.rendering.EnvironmentCullable;
import org.j3d.aviatrix3d.rendering.LeafCullable;
import org.j3d.aviatrix3d.rendering.RenderPassCullable;
import org.j3d.aviatrix3d.rendering.ViewEnvironmentCullable;

public class RenderPass
extends SceneGraphObject
implements RenderPassCullable {
    private static final String SHARED_VP_MSG = "The path from the root of the scene graph to the viewpoint contains a SharedGroup or SharedNode instance. This is not permitted.";
    private ViewEnvironment viewEnvironment = new ViewEnvironment();
    private Group renderableObjects;
    private Viewpoint currentViewpoint;
    private Fog currentFog;
    private StencilBufferState stencilState;
    private DepthBufferState depthState;
    private ColorBufferState colorState;
    private AccumulationBufferState accumState;
    private boolean activeSoundLayer = false;
    private InternalUpdater internalUpdater;

    public boolean is2D() {
        return false;
    }

    public boolean isAudioSource() {
        return this.activeSoundLayer;
    }

    public ViewEnvironmentCullable getViewCullable() {
        return this.viewEnvironment;
    }

    public EnvironmentCullable getViewpointCullable() {
        return this.currentViewpoint;
    }

    public EnvironmentCullable getBackgroundCullable() {
        return null;
    }

    public LeafCullable getFogCullable() {
        return this.currentFog;
    }

    public Cullable getRootCullable() {
        return this.renderableObjects;
    }

    public BufferStateRenderable getColorBufferRenderable() {
        return this.colorState;
    }

    public BufferStateRenderable getDepthBufferRenderable() {
        return this.depthState;
    }

    public BufferStateRenderable getStencilBufferRenderable() {
        return this.stencilState;
    }

    public BufferStateRenderable getAccumBufferRenderable() {
        return this.accumState;
    }

    protected void setLive(boolean bl) {
        super.setLive(bl);
        if (this.renderableObjects != null) {
            this.renderableObjects.setLive(bl);
        }
        if (this.stencilState != null) {
            this.stencilState.setLive(bl);
        }
        if (this.depthState != null) {
            this.depthState.setLive(bl);
        }
        if (this.colorState != null) {
            this.colorState.setLive(bl);
        }
        if (this.accumState != null) {
            this.accumState.setLive(bl);
        }
        this.viewEnvironment.setLive(bl);
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        if (this.renderableObjects != null) {
            this.renderableObjects.setUpdateHandler(nodeUpdateHandler);
        }
        if (this.stencilState != null) {
            this.stencilState.setUpdateHandler(nodeUpdateHandler);
        }
        if (this.depthState != null) {
            this.depthState.setUpdateHandler(nodeUpdateHandler);
        }
        if (this.colorState != null) {
            this.colorState.setUpdateHandler(nodeUpdateHandler);
        }
        if (this.accumState != null) {
            this.accumState.setUpdateHandler(nodeUpdateHandler);
        }
        this.viewEnvironment.setUpdateHandler(nodeUpdateHandler);
    }

    public void makeActiveSoundLayer() throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.activeSoundLayer = true;
        if (this.updateHandler != null) {
            if (this.internalUpdater == null) {
                this.internalUpdater = new InternalUpdater();
            }
            this.updateHandler.activeSoundLayerChanged(this.internalUpdater);
        }
    }

    public boolean isActiveSoundLayer() {
        return this.activeSoundLayer;
    }

    public ViewEnvironment getViewEnvironment() {
        return this.viewEnvironment;
    }

    public void setRenderedGeometry(Group group) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isPickingPermitted() && this.renderableObjects != null) {
            this.renderableObjects.setUpdateHandler(null);
            this.renderableObjects.setLive(false);
        }
        this.renderableObjects = group;
        if (this.renderableObjects != null) {
            this.renderableObjects.setUpdateHandler(this.updateHandler);
            this.renderableObjects.setLive(this.alive);
        }
    }

    public Group getRenderedGeometry() {
        return this.renderableObjects;
    }

    public void setActiveView(Viewpoint viewpoint) throws InvalidWriteTimingException, IllegalArgumentException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        for (Node node = viewpoint.getParent(); node != null; node = node.getParent()) {
            if (!(node instanceof SharedGroup) && !(node instanceof SharedNode)) continue;
            throw new IllegalArgumentException(SHARED_VP_MSG);
        }
        this.currentViewpoint = viewpoint;
    }

    public Viewpoint getActiveView() {
        return this.currentViewpoint;
    }

    public void setStencilBufferState(StencilBufferState stencilBufferState) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.stencilState = stencilBufferState;
    }

    public StencilBufferState getStencilBufferState() {
        return this.stencilState;
    }

    public void setDepthBufferState(DepthBufferState depthBufferState) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.depthState = depthBufferState;
    }

    public DepthBufferState getDepthBufferState() {
        return this.depthState;
    }

    public void setColorBufferState(ColorBufferState colorBufferState) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.colorState = colorBufferState;
    }

    public ColorBufferState getColorBufferState() {
        return this.colorState;
    }

    public void setAccumulationBufferState(AccumulationBufferState accumulationBufferState) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.accumState = accumulationBufferState;
    }

    public AccumulationBufferState getAccumulationBufferState() {
        return this.accumState;
    }

    void setViewportDimensions(int n, int n2, int n3, int n4) {
        this.viewEnvironment.setViewportDimensions(n, n2, n3, n4);
    }

    private class InternalUpdater
    implements InternalLayerUpdateListener {
        private InternalUpdater() {
        }

        public void disableActiveAudioState() {
            RenderPass.this.activeSoundLayer = false;
        }
    }
}

