/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import net.java.games.joal.AL;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Sound;
import org.j3d.util.MatrixUtils;

public class PointSound
extends Sound {
    private int source;
    private Point3f position = new Point3f();
    private Point3f tmpPoint = new Point3f();
    private Matrix4f tmpMatrix = new Matrix4f();
    private MatrixUtils matrixUtils = new MatrixUtils();
    protected float refDistance = 0.0f;
    protected float maxDistance = Float.MAX_VALUE;
    protected float rolloffFactor = 1.0f;

    public void render(AL aL, Matrix4f matrix4f) {
        matrix4f.transform(this.position, this.tmpPoint);
        if (this.dataChanged) {
            this.buffer = this.soundSource.getBufferId(aL, this.seq);
            if (this.buffer == -1) {
                return;
            }
            this.dataChanged = false;
            this.playChanged = true;
            this.values.rewind();
            aL.alGenSources(1, this.values);
            this.source = this.values.get(0);
            if (aL.alGetError() != 0) {
                System.out.println("Error creating OpenAL Source");
            }
            aL.alSourcei(this.source, 4105, this.buffer);
            aL.alSourcef(this.source, 4128, this.refDistance);
            aL.alSourcef(this.source, 4129, this.rolloffFactor);
            aL.alSourcef(this.source, 4131, this.maxDistance);
            aL.alSourcef(this.source, 4099, 1.0f);
            aL.alSourcef(this.source, 4106, 1.0f);
            aL.alSource3f(this.source, 4100, this.tmpPoint.x, this.tmpPoint.y, this.tmpPoint.z);
            aL.alSourcei(this.source, 4103, this.loop ? 1 : 0);
            aL.alSourcef(this.source, 4099, this.pitch);
            if (aL.alGetError() != 0) {
                System.out.println("Error setting OpenAL Source params");
            }
        }
        if (this.paramsChanged) {
            aL.alSourcef(this.source, 4099, this.pitch);
            aL.alSourcei(this.source, 4103, this.loop ? 1 : 0);
            this.paramsChanged = false;
        }
        aL.alSource3f(this.source, 4100, this.tmpPoint.x, this.tmpPoint.y, this.tmpPoint.z);
        if (this.playChanged) {
            if (this.playing && this.paused) {
                aL.alSourcePlay(this.source);
            }
            if (this.playing) {
                if (this.paused) {
                    aL.alSourcePause(this.source);
                } else {
                    aL.alSourcePlay(this.source);
                }
            } else {
                aL.alSourceStop(this.source);
            }
            this.playChanged = false;
        } else if (this.playing) {
            this.values.rewind();
            aL.alGetSourcei(this.source, 4112, this.values);
            if (this.values.get(0) == 4116) {
                this.playing = false;
            }
        }
    }

    public void postRender(AL aL) {
    }

    public int compareTo(Object object) throws ClassCastException {
        PointSound pointSound = (PointSound)object;
        return this.compareTo(pointSound);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PointSound)) {
            return false;
        }
        return this.equals((PointSound)object);
    }

    public void setRefDistance(float f) {
        if (this.alive && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.refDistance = f;
    }

    public void setMaxDistance(float f) {
        if (this.alive && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.maxDistance = f;
    }

    public void setRolloffFactor(float f) {
        if (this.alive && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.rolloffFactor = f;
    }

    public int compareTo(PointSound pointSound) {
        if (pointSound == null) {
            return 1;
        }
        if (pointSound == this) {
            return 0;
        }
        return super.compareTo(pointSound);
    }

    public boolean equals(PointSound pointSound) {
        if (pointSound == this) {
            return true;
        }
        if (pointSound == null) {
            return false;
        }
        return super.equals(pointSound);
    }
}

