/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import javax.media.opengl.GL;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Light;

public class PointLight
extends Light {
    protected float[] position;
    protected float cAttenuation;
    protected float lAttenuation;
    protected float qAttenuation;

    public PointLight() {
        super(2);
        this.position = new float[4];
        this.position[3] = 1.0f;
        this.cAttenuation = 1.0f;
    }

    public PointLight(float[] fArray) throws IllegalArgumentException {
        super(2, fArray);
        this.position = new float[4];
        this.position[3] = 1.0f;
        this.cAttenuation = 1.0f;
    }

    public PointLight(float[] fArray, float[] fArray2) throws IllegalArgumentException {
        super(2, fArray);
        this.position = new float[]{fArray2[0], fArray2[1], fArray2[2], 1.0f};
        this.cAttenuation = 1.0f;
    }

    public void render(GL gL, Object object) {
        int n = (Integer)object;
        gL.glLightfv(n, 4608, this.ambientColor, 0);
        gL.glLightfv(n, 4610, this.specularColor, 0);
        gL.glLightfv(n, 4609, this.diffuseColor, 0);
        gL.glLightfv(n, 4611, this.position, 0);
        gL.glLightf(n, 4615, this.cAttenuation);
        gL.glLightf(n, 4616, this.lAttenuation);
        gL.glLightf(n, 4617, this.qAttenuation);
        gL.glEnable(n);
    }

    public void postRender(GL gL, Object object) {
        gL.glDisable(((Integer)object).intValue());
    }

    protected void markBoundsDirty() {
        if (this.parent != null) {
            this.parent.markBoundsDirty();
        }
    }

    public void setPosition(float[] fArray) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.position[0] = fArray[0];
        this.position[1] = fArray[1];
        this.position[2] = fArray[2];
    }

    public void setPosition(float f, float f2, float f3) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.position[0] = f;
        this.position[1] = f2;
        this.position[2] = f3;
    }

    public void getPosition(float[] fArray) {
        fArray[0] = this.position[0];
        fArray[1] = this.position[1];
        fArray[2] = this.position[2];
    }

    public void setAttenuation(float f, float f2, float f3) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.cAttenuation = f;
        this.lAttenuation = f2;
        this.qAttenuation = f3;
    }

    public void setAttenuation(float[] fArray) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.cAttenuation = fArray[0];
        this.lAttenuation = fArray[1];
        this.qAttenuation = fArray[2];
    }

    public void getAttenuation(float[] fArray) {
        fArray[0] = this.cAttenuation;
        fArray[1] = this.lAttenuation;
        fArray[2] = this.qAttenuation;
    }

    public int compareTo(Light light) {
        int n = super.compareTo(light);
        if (n != 0) {
            return n;
        }
        PointLight pointLight = (PointLight)light;
        if (this.cAttenuation != pointLight.cAttenuation) {
            return this.cAttenuation < pointLight.cAttenuation ? -1 : 1;
        }
        if (this.lAttenuation != pointLight.lAttenuation) {
            return this.lAttenuation < pointLight.lAttenuation ? -1 : 1;
        }
        if (this.qAttenuation != pointLight.qAttenuation) {
            return this.qAttenuation < pointLight.qAttenuation ? -1 : 1;
        }
        return this.compareColor3(this.position, pointLight.position);
    }
}

