/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.io.Serializable;
import java.util.HashMap;
import javax.media.opengl.GL;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.NodeComponent;
import org.j3d.aviatrix3d.rendering.AppearanceAttributeRenderable;

public class PointAttributes
extends NodeComponent
implements AppearanceAttributeRenderable {
    private static final String NO_POINT_SPRITE_MSG = "Video card incapable of supporting point sprites.";
    private static final String POINT_SIZE_MSG = "The point size must be greater than zero";
    private static final float[] DEFAULT_FACTORS = new float[]{1.0f, 1.0f, 1.0f};
    private static boolean hasPointSpriteAPI;
    private static boolean queryComplete;
    private float pointSize = 1.0f;
    private boolean antialias = false;
    private float minPointSize = 1.0f;
    private float maxPointSize = 1.0f;
    private float fadeThresholdSize = 1.0f;
    private boolean needAttenuation;
    private float[] attenuationFactors;
    private boolean stateChanged = true;
    private HashMap<GL, Integer> displayListMap = new HashMap(1);
    private boolean enablePointSprites = false;

    public int getAttributeType() {
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(GL gL) {
        Serializable serializable;
        if (!queryComplete) {
            hasPointSpriteAPI = gL.isExtensionAvailable("GL_ARB_point_sprite");
            queryComplete = true;
            if (!hasPointSpriteAPI) {
                System.out.println(NO_POINT_SPRITE_MSG);
            }
        }
        if (this.stateChanged) {
            serializable = this.displayListMap;
            synchronized (serializable) {
                this.displayListMap.clear();
                this.stateChanged = false;
            }
        }
        if ((serializable = this.displayListMap.get(gL)) == null) {
            serializable = new Integer(gL.glGenLists(1));
            gL.glNewList(((Integer)serializable).intValue(), 4864);
            gL.glPushAttrib(2);
            if (this.antialias) {
                gL.glEnable(2832);
            }
            if (this.pointSize != 1.0f) {
                gL.glPointSize(this.pointSize);
            }
            if (this.needAttenuation) {
                gL.glPointParameterfv(33065, this.attenuationFactors, 0);
            }
            if (this.minPointSize != 1.0f) {
                gL.glPointParameterf(33062, this.minPointSize);
            }
            if (this.maxPointSize != 1.0f) {
                gL.glPointParameterf(33063, this.maxPointSize);
            }
            if (this.fadeThresholdSize != 1.0f) {
                gL.glPointParameterf(33064, this.fadeThresholdSize);
            }
            if (hasPointSpriteAPI && this.enablePointSprites) {
                gL.glEnable(34913);
            }
            gL.glEndList();
            this.displayListMap.put(gL, (Integer)serializable);
        }
        gL.glCallList(((Integer)serializable).intValue());
    }

    public void postRender(GL gL) {
        if (this.antialias) {
            gL.glDisable(2832);
        }
        if (this.pointSize != 1.0f) {
            gL.glPointSize(1.0f);
        }
        if (this.needAttenuation) {
            gL.glPointParameterfv(33065, DEFAULT_FACTORS, 0);
        }
        if (this.minPointSize != 1.0f) {
            gL.glPointParameterf(33062, 1.0f);
        }
        if (this.maxPointSize != 1.0f) {
            gL.glPointParameterf(33063, 1.0f);
        }
        if (this.fadeThresholdSize != 1.0f) {
            gL.glPointParameterf(33064, 1.0f);
        }
        if (hasPointSpriteAPI && this.enablePointSprites) {
            gL.glDisable(34913);
        }
        gL.glPopAttrib();
    }

    public int compareTo(Object object) throws ClassCastException {
        PointAttributes pointAttributes = (PointAttributes)object;
        return this.compareTo(pointAttributes);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PointAttributes)) {
            return false;
        }
        return this.equals((PointAttributes)object);
    }

    public void setAntiAliased(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.antialias != bl) {
            this.antialias = bl;
            this.stateChanged = true;
        }
    }

    public boolean isAntiAliased() {
        return this.antialias;
    }

    public void setPointSize(float f) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException(POINT_SIZE_MSG);
        }
        if (this.pointSize != f) {
            this.pointSize = f;
            this.stateChanged = true;
        }
    }

    public float getPointSize() {
        return this.pointSize;
    }

    public void setFadeThresholdSize(float f) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException(POINT_SIZE_MSG);
        }
        if (this.fadeThresholdSize != f) {
            this.fadeThresholdSize = f;
            this.stateChanged = true;
        }
    }

    public float getFadeThresholdSize() {
        return this.fadeThresholdSize;
    }

    public void setMinPointSize(float f) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException(POINT_SIZE_MSG);
        }
        if (this.minPointSize != f) {
            this.minPointSize = f;
            this.stateChanged = true;
        }
    }

    public float getMinPointSize() {
        return this.minPointSize;
    }

    public void setMaxPointSize(float f) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException(POINT_SIZE_MSG);
        }
        if (this.maxPointSize != f) {
            this.maxPointSize = f;
            this.stateChanged = true;
        }
    }

    public float getMaxPointSize() {
        return this.maxPointSize;
    }

    public void setAttenuationFactors(float f, float f2, float f3) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.attenuationFactors == null) {
            this.attenuationFactors = new float[4];
        }
        this.attenuationFactors[0] = f;
        this.attenuationFactors[1] = f2;
        this.attenuationFactors[2] = f3;
        this.needAttenuation = f != 1.0f || f2 != 1.0f || f3 != 1.0f;
        this.stateChanged = true;
    }

    public void getAttenuationFactors(float[] fArray) {
        if (this.attenuationFactors == null) {
            return;
        }
        fArray[0] = this.attenuationFactors[0];
        fArray[1] = this.attenuationFactors[1];
        fArray[2] = this.attenuationFactors[2];
    }

    public void setPointSpriteEnabled(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.enablePointSprites = bl;
    }

    public boolean isPointSpriteEnabled() {
        return this.enablePointSprites;
    }

    public boolean isPointSpriteAllowed() {
        return hasPointSpriteAPI;
    }

    public int compareTo(PointAttributes pointAttributes) {
        if (pointAttributes == null) {
            return 1;
        }
        if (pointAttributes == this) {
            return 0;
        }
        if (this.antialias != pointAttributes.antialias) {
            return this.antialias ? 1 : -1;
        }
        if (this.pointSize != pointAttributes.pointSize) {
            return this.pointSize < pointAttributes.pointSize ? -1 : 1;
        }
        if (this.minPointSize != pointAttributes.minPointSize) {
            return this.pointSize < pointAttributes.pointSize ? -1 : 1;
        }
        if (this.maxPointSize != pointAttributes.maxPointSize) {
            return this.pointSize < pointAttributes.pointSize ? -1 : 1;
        }
        if (this.fadeThresholdSize != pointAttributes.fadeThresholdSize) {
            return this.fadeThresholdSize < pointAttributes.fadeThresholdSize ? -1 : 1;
        }
        if (this.needAttenuation != pointAttributes.needAttenuation) {
            return this.needAttenuation ? 1 : -1;
        }
        if (this.needAttenuation) {
            if (this.attenuationFactors[0] < pointAttributes.attenuationFactors[0]) {
                return -1;
            }
            if (this.attenuationFactors[0] > pointAttributes.attenuationFactors[0]) {
                return 1;
            }
            if (this.attenuationFactors[1] < pointAttributes.attenuationFactors[1]) {
                return -1;
            }
            if (this.attenuationFactors[1] > pointAttributes.attenuationFactors[1]) {
                return 1;
            }
            if (this.attenuationFactors[2] < pointAttributes.attenuationFactors[2]) {
                return -1;
            }
            if (this.attenuationFactors[2] > pointAttributes.attenuationFactors[2]) {
                return 1;
            }
            if (this.attenuationFactors[3] < pointAttributes.attenuationFactors[3]) {
                return -1;
            }
            if (this.attenuationFactors[3] > pointAttributes.attenuationFactors[3]) {
                return 1;
            }
        }
        return 0;
    }

    public boolean equals(PointAttributes pointAttributes) {
        if (pointAttributes == this) {
            return true;
        }
        if (pointAttributes == null || this.antialias != pointAttributes.antialias || this.pointSize != pointAttributes.pointSize || this.minPointSize != pointAttributes.minPointSize || this.maxPointSize != pointAttributes.maxPointSize || this.fadeThresholdSize != pointAttributes.fadeThresholdSize || this.needAttenuation != pointAttributes.needAttenuation) {
            return false;
        }
        return !this.needAttenuation || this.attenuationFactors[0] == pointAttributes.attenuationFactors[0] && this.attenuationFactors[1] == pointAttributes.attenuationFactors[1] && this.attenuationFactors[2] == pointAttributes.attenuationFactors[2] && this.attenuationFactors[3] == pointAttributes.attenuationFactors[3];
    }
}

