/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import javax.media.opengl.GL;
import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.BoundingVoid;
import org.j3d.aviatrix3d.CyclicSceneGraphStructureException;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Leaf2D;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.Raster;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.picking.InvalidPickTimingException;
import org.j3d.aviatrix3d.picking.NotPickableException;
import org.j3d.aviatrix3d.picking.PickRequest;
import org.j3d.aviatrix3d.picking.PickTarget;
import org.j3d.aviatrix3d.picking.PickableObject;
import org.j3d.aviatrix3d.picking.PickingManager;
import org.j3d.aviatrix3d.picking.SinglePickTarget;
import org.j3d.aviatrix3d.rendering.AppearanceRenderable;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.j3d.aviatrix3d.rendering.GeometryRenderable;
import org.j3d.aviatrix3d.rendering.LeafCullable;
import org.j3d.aviatrix3d.rendering.ObjectRenderable;
import org.j3d.aviatrix3d.rendering.Renderable;
import org.j3d.aviatrix3d.rendering.ShapeRenderable;

public class Pixmap
extends Leaf2D
implements PickableObject,
SinglePickTarget,
LeafCullable,
ShapeRenderable,
ObjectRenderable {
    private static final String PICK_TIMING_MSG = "Picking not permitted right now. Picking is only permitted during the update observer callbacks.";
    private static final String PICKABLE_FALSE_MSG = "This node has been marked as not pickable by the user";
    private int pickFlags = -1;
    private Raster geom;

    public int getCullableType() {
        return 4;
    }

    public Renderable getRenderable() {
        return this;
    }

    public boolean isVisible() {
        boolean bl = this.geom != null ? this.geom.isVisible() : false;
        return bl;
    }

    public boolean is2D() {
        return true;
    }

    public GeometryRenderable getGeometryRenderable() {
        return this.geom;
    }

    public AppearanceRenderable getAppearanceRenderable() {
        return null;
    }

    public void render(GL gL) {
        if (this.geom != null) {
            this.geom.render(gL);
        }
    }

    public void postRender(GL gL) {
    }

    protected void updateBounds() {
        this.recomputeBounds();
        if (this.parent != null) {
            this.parent.updateBounds();
        }
    }

    protected void markBoundsDirty() {
        if (this.parent != null) {
            this.parent.markBoundsDirty();
        }
    }

    protected void recomputeBounds() {
        if (!this.implicitBounds) {
            return;
        }
        if (this.geom == null) {
            this.bounds = INVALID_BOUNDS;
        } else {
            if (this.bounds == null || this.bounds == INVALID_BOUNDS) {
                this.bounds = new BoundingBox();
            }
            BoundingBox boundingBox = (BoundingBox)this.bounds;
            BoundingVolume boundingVolume = this.geom.getBounds();
            if (boundingVolume instanceof BoundingVoid) {
                this.bounds = INVALID_BOUNDS;
            } else {
                float[] fArray = new float[3];
                float[] fArray2 = new float[3];
                boundingVolume.getExtents(fArray, fArray2);
                boundingBox.setMinimum(fArray);
                boundingBox.setMaximum(fArray2);
            }
        }
    }

    public void requestBoundsUpdate() {
        if (this.alive || !this.implicitBounds || this.geom == null || this.geom.isLive()) {
            return;
        }
        this.geom.recomputeBounds();
        this.recomputeBounds();
    }

    protected void setLive(boolean bl) {
        if (this.geom != null) {
            this.geom.setLive(bl);
        }
        super.setLive(bl);
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        if (this.geom != null) {
            this.geom.setUpdateHandler(this.updateHandler);
        }
    }

    protected void checkForCyclicChild(SceneGraphObject sceneGraphObject) throws CyclicSceneGraphStructureException {
        if (sceneGraphObject == this) {
            throw new CyclicSceneGraphStructureException();
        }
    }

    public void setPickMask(int n) {
        this.pickFlags = n;
    }

    public int getPickMask() {
        return this.pickFlags;
    }

    public void pickBatch(PickRequest[] pickRequestArray, int n) throws NotPickableException, InvalidPickTimingException {
        if (this.updateHandler == null || !this.updateHandler.isPickingPermitted()) {
            throw new InvalidPickTimingException(PICK_TIMING_MSG);
        }
        if (this.pickFlags == 0) {
            throw new NotPickableException(PICKABLE_FALSE_MSG);
        }
        PickingManager pickingManager = this.updateHandler.getPickingManager();
        pickingManager.pickBatch(this, pickRequestArray, n);
    }

    public void pickSingle(PickRequest pickRequest) throws NotPickableException, InvalidPickTimingException {
        if (this.updateHandler == null || !this.updateHandler.isPickingPermitted()) {
            throw new InvalidPickTimingException(PICK_TIMING_MSG);
        }
        if (this.pickFlags == 0) {
            throw new NotPickableException(PICKABLE_FALSE_MSG);
        }
        PickingManager pickingManager = this.updateHandler.getPickingManager();
        pickingManager.pickSingle(this, pickRequest);
    }

    public PickTarget getPickableChild() {
        return this.geom instanceof PickTarget ? this.geom : null;
    }

    public final int getPickTargetType() {
        return 2;
    }

    public boolean checkPickMask(int n) {
        return (this.pickFlags & n) != 0;
    }

    public BoundingVolume getPickableBounds() {
        return this.bounds;
    }

    public int compareTo(Object object) throws ClassCastException {
        Pixmap pixmap = (Pixmap)object;
        return this.compareTo(pixmap);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Pixmap)) {
            return false;
        }
        return this.equals((Pixmap)object);
    }

    public Raster getRaster() {
        return this.geom;
    }

    public void setRaster(Raster raster) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.geom != null) {
            this.geom.setLive(false);
            this.geom.removeParent(this);
        }
        this.geom = raster;
        if (this.geom != null) {
            this.geom.addParent(this);
            this.geom.setLive(this.alive);
            this.geom.setUpdateHandler(this.updateHandler);
        }
    }

    public int compareTo(Pixmap pixmap) {
        if (pixmap == null) {
            return 1;
        }
        if (pixmap == this) {
            return 0;
        }
        if (this.geom != pixmap.geom) {
            if (this.geom == null) {
                return -1;
            }
            if (pixmap.geom == null) {
                return 1;
            }
            int n = this.geom.compareTo(pixmap.geom);
            if (n != 0) {
                return n;
            }
        }
        return 0;
    }

    public boolean equals(Pixmap pixmap) {
        if (pixmap == this) {
            return true;
        }
        if (pixmap == null) {
            return false;
        }
        return this.geom == pixmap.geom || this.geom != null && this.geom.equals(pixmap.geom);
    }
}

