/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import org.j3d.aviatrix3d.picking.PickRequest;
import org.j3d.aviatrix3d.rendering.BoundingVolume;

public class PickingUtils {
    private float[] wkVec1 = new float[4];
    private float[] wkVec2 = new float[4];

    public boolean checkIntersection(BoundingVolume boundingVolume, PickRequest pickRequest) {
        switch (pickRequest.pickGeometryType) {
            case 8: {
                return boundingVolume.checkIntersectionBox(pickRequest.origin, pickRequest.destination);
            }
            case 6: 
            case 7: {
                return boundingVolume.checkIntersectionCone(pickRequest.origin, pickRequest.destination, pickRequest.additionalData);
            }
            case 4: 
            case 5: {
                float f = pickRequest.origin[0] - pickRequest.destination[0];
                float f2 = pickRequest.origin[1] - pickRequest.destination[1];
                float f3 = pickRequest.origin[2] - pickRequest.destination[2];
                float f4 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
                if (f4 == 0.0f) {
                    return false;
                }
                this.wkVec1[0] = (pickRequest.origin[0] + pickRequest.destination[0]) * 0.5f;
                this.wkVec1[1] = (pickRequest.origin[1] + pickRequest.destination[0]) * 0.5f;
                this.wkVec1[2] = (pickRequest.origin[2] + pickRequest.destination[0]) * 0.5f;
                this.wkVec1[3] = 1.0f;
                this.wkVec2[0] = f;
                this.wkVec2[1] = f2;
                this.wkVec2[2] = f3;
                this.wkVec2[3] = 1.0f;
                float f5 = pickRequest.additionalData;
                return boundingVolume.checkIntersectionCylinder(this.wkVec1, this.wkVec2, f5, f4);
            }
            case 10: {
                break;
            }
            case 3: {
                this.wkVec1[0] = pickRequest.origin[0];
                this.wkVec1[1] = pickRequest.origin[1];
                this.wkVec1[2] = pickRequest.origin[2];
                this.wkVec1[3] = 1.0f;
                this.wkVec2[0] = pickRequest.destination[0];
                this.wkVec2[1] = pickRequest.destination[1];
                this.wkVec2[2] = pickRequest.destination[2];
                this.wkVec2[3] = 1.0f;
                return boundingVolume.checkIntersectionSegment(this.wkVec1, this.wkVec2);
            }
            case 1: {
                return boundingVolume.checkIntersectionPoint(pickRequest.origin);
            }
            case 2: {
                this.wkVec1[0] = pickRequest.origin[0];
                this.wkVec1[1] = pickRequest.origin[1];
                this.wkVec1[2] = pickRequest.origin[2];
                this.wkVec1[3] = 1.0f;
                this.wkVec2[0] = pickRequest.destination[0];
                this.wkVec2[1] = pickRequest.destination[1];
                this.wkVec2[2] = pickRequest.destination[2];
                this.wkVec2[3] = 1.0f;
                return boundingVolume.checkIntersectionRay(this.wkVec1, this.wkVec2);
            }
            case 9: {
                return boundingVolume.checkIntersectionSphere(pickRequest.origin, pickRequest.additionalData);
            }
        }
        return false;
    }
}

