/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.util.HashMap;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import org.j3d.aviatrix3d.CyclicSceneGraphStructureException;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Layer;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.OffscreenTextureSource;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.Texture;
import org.j3d.aviatrix3d.TextureSource;
import org.j3d.aviatrix3d.rendering.LayerCullable;
import org.j3d.aviatrix3d.rendering.OffscreenBufferDescriptor;
import org.j3d.aviatrix3d.rendering.OffscreenBufferRenderable;
import org.j3d.aviatrix3d.rendering.OffscreenCullable;

public class OffscreenTexture2D
extends Texture
implements OffscreenTextureSource,
OffscreenCullable,
OffscreenBufferRenderable {
    private int height;
    private int boundaryModeT;
    private Layer[] layers;
    private int numLayers;
    private float[] clearColor;
    private boolean repaintNeeded;
    private final GLCapabilities capabilities;
    private HashMap<Object, OffscreenBufferDescriptor> displayListMap;
    private final boolean needsTextureCopy;
    private HashMap<GL, Integer> textureIdMap;

    public OffscreenTexture2D(GLCapabilities gLCapabilities, int n, int n2) {
        super(3553);
        if (gLCapabilities == null) {
            throw new IllegalArgumentException("Capabilities must be provided");
        }
        this.capabilities = (GLCapabilities)gLCapabilities.clone();
        this.height = n2;
        this.width = n;
        boolean bl = this.needsTextureCopy = !gLCapabilities.getPbufferRenderToTexture();
        if (this.needsTextureCopy) {
            this.textureIdMap = new HashMap();
        }
        this.numSources = 0;
        this.clearColor = new float[4];
        this.boundaryModeT = 10496;
        this.displayListMap = new HashMap();
        this.layers = new Layer[0];
        int n3 = gLCapabilities.getRedBits();
        int n4 = gLCapabilities.getGreenBits();
        int n5 = gLCapabilities.getBlueBits();
        int n6 = gLCapabilities.getAlphaBits();
        int n7 = gLCapabilities.getDepthBits();
        this.format = n7 != 0 ? 6402 : (n6 != 0 ? (n5 != 0 ? 6408 : (n3 != 0 ? 6410 : 6406)) : (n5 != 0 ? 6407 : 32841));
    }

    public OffscreenTexture2D(GLCapabilities gLCapabilities, int n, int n2, int n3) {
        super(3553);
        if (gLCapabilities == null) {
            throw new IllegalArgumentException("Capabilities must be provided");
        }
        this.capabilities = (GLCapabilities)gLCapabilities.clone();
        this.height = n2;
        this.width = n;
        this.format = n3;
        boolean bl = this.needsTextureCopy = !gLCapabilities.getPbufferRenderToTexture();
        if (this.needsTextureCopy) {
            this.textureIdMap = new HashMap();
        }
        this.numSources = 0;
        this.clearColor = new float[4];
        this.boundaryModeT = 10496;
        this.displayListMap = new HashMap();
        this.layers = new Layer[0];
    }

    public LayerCullable getCullableLayer(int n) {
        if (n < 0 || n >= this.numLayers) {
            return null;
        }
        if (this.layers[n] == null) {
            return null;
        }
        return this.layers[n].getCullable(0);
    }

    public int numCullableChildren() {
        return this.numLayers;
    }

    public OffscreenBufferRenderable getOffscreenRenderable() {
        return this;
    }

    boolean hasValidData() {
        return true;
    }

    public void setSources(int n, int n2, TextureSource[] textureSourceArray, int n3) throws InvalidWriteTimingException {
    }

    public GLCapabilities getGLSetup() {
        return this.capabilities;
    }

    public OffscreenBufferDescriptor getBuffer(Object object) {
        return this.displayListMap.get(object);
    }

    public void registerBuffer(Object object, OffscreenBufferDescriptor offscreenBufferDescriptor) {
        this.displayListMap.put(object, offscreenBufferDescriptor);
    }

    public void unregisterBuffer(Object object) {
        this.displayListMap.remove(object);
    }

    public void bindBuffer(GLContext gLContext) {
        if (this.needsTextureCopy) {
            return;
        }
    }

    public void unbindBuffer(GLContext gLContext) {
        if (this.needsTextureCopy) {
            return;
        }
    }

    public void render(GL gL) {
        if (!this.stateChanged.getState(gL)) {
            return;
        }
        this.stateChanged.put(gL, false);
        gL.glTexParameteri(3553, 10242, this.boundaryModeS);
        gL.glTexParameteri(3553, 10243, this.boundaryModeT);
        int n = 0;
        switch (this.magFilter) {
            case 0: 
            case 2: {
                n = 9728;
                break;
            }
            case 1: 
            case 3: {
                n = 9729;
                break;
            }
            default: {
                System.out.println("Unknown mode in MagFilter: " + this.magFilter);
            }
        }
        gL.glTexParameteri(3553, 10240, n);
        switch (this.minFilter) {
            case 0: 
            case 2: {
                n = 9728;
                break;
            }
            case 3: {
                n = 9729;
                break;
            }
            case 5: {
                n = 9987;
                break;
            }
            case 4: {
                n = 9984;
                break;
            }
            case 1: {
                n = this.numSources > 1 ? 9987 : 9729;
                break;
            }
            default: {
                System.out.println("Unknown mode in MinFilter: " + this.minFilter);
            }
        }
        gL.glTexParameteri(3553, 10241, n);
        if (this.anisotropicMode != 0) {
            gL.glTexParameterf(3553, 34046, this.anisotropicDegree);
        }
        if (this.priority >= 0.0f) {
            gL.glTexParameterf(3553, 32870, this.priority);
        }
        if (this.borderColor != null) {
            gL.glTexParameterfv(3553, 4100, this.borderColor, 0);
        }
        if (this.format == 6402) {
            gL.glTexParameterf(3553, 34891, (float)this.depthComponentMode);
            gL.glTexParameterf(3553, 34892, (float)this.compareMode);
            gL.glTexParameterf(3553, 34893, (float)this.compareFunction);
        }
    }

    public void postRender(GL gL) {
        if (this.needsTextureCopy) {
            Integer n = this.textureIdMap.get(gL);
            gL.glBindTexture(3553, n.intValue());
            gL.glCopyTexSubImage2D(3553, 0, 0, 0, 0, 0, this.width, this.height);
        }
    }

    protected void checkForCyclicChild(SceneGraphObject sceneGraphObject) throws InvalidWriteTimingException, CyclicSceneGraphStructureException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (sceneGraphObject == this) {
            throw new CyclicSceneGraphStructureException();
        }
        for (int i = 0; i < this.numLayers; ++i) {
            if (this.layers[i] == null) continue;
            this.layers[i].checkForCyclicChild(sceneGraphObject);
        }
    }

    protected void setLive(boolean bl) {
        if (bl) {
            ++this.liveCount;
        } else if (this.liveCount > 0) {
            --this.liveCount;
        }
        if (this.liveCount == 0 || !this.alive) {
            super.setLive(bl);
            for (int i = 0; i < this.numLayers; ++i) {
                if (this.layers[i] == null) continue;
                this.layers[i].setLive(bl);
            }
        }
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        for (int i = 0; i < this.numLayers; ++i) {
            if (this.layers[i] == null) continue;
            this.layers[i].setUpdateHandler(this.updateHandler);
        }
    }

    public boolean isRepaintRequired() {
        return this.repaintNeeded;
    }

    public int getHeight() {
        return this.height;
    }

    public void getClearColor(float[] fArray) {
        fArray[0] = this.clearColor[0];
        fArray[1] = this.clearColor[1];
        fArray[2] = this.clearColor[2];
        fArray[3] = this.clearColor[3];
    }

    public int getFormat(int n) {
        return this.format;
    }

    public int getNumLevels() {
        return 1;
    }

    public void setLayers(Layer[] layerArray, int n) throws InvalidWriteTimingException, CyclicSceneGraphStructureException {
        int n2;
        int n3;
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        for (n3 = 0; n3 < n; ++n3) {
            layerArray[n3].checkForCyclicChild(this);
        }
        n3 = this.layers.length;
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.alive) {
                this.layers[n2].setLive(false);
            }
            this.layers[n2].setUpdateHandler(null);
        }
        if (n3 < n) {
            this.layers = new Layer[n];
        }
        if (n != 0) {
            System.arraycopy(layerArray, 0, this.layers, 0, n);
        }
        for (n2 = n; n2 < n3; ++n2) {
            layerArray[n2] = null;
        }
        this.numLayers = n;
        for (n2 = 0; n2 < n; ++n2) {
            this.layers[n2].setLive(this.alive);
            this.layers[n2].setUpdateHandler(this.updateHandler);
        }
    }

    public int numLayers() {
        return this.numLayers;
    }

    public void getLayers(Layer[] layerArray) throws IllegalArgumentException {
        if (layerArray == null || layerArray.length < this.numLayers) {
            throw new IllegalArgumentException("Array provided is too small");
        }
        System.arraycopy(layerArray, 0, this.layers, 0, this.numLayers);
    }

    public void setRepaintRequired(boolean bl) {
        this.repaintNeeded = bl;
    }

    public void setBoundaryModeT(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.boundaryModeT = n;
        this.stateChanged.setAll(true);
    }

    public int getBoundaryModeT() {
        return this.boundaryModeT;
    }

    public void setClearColor(float f, float f2, float f3, float f4) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.clearColor[0] = f;
        this.clearColor[1] = f2;
        this.clearColor[2] = f3;
        this.clearColor[3] = f4;
    }

    public int compareTo(Texture texture) {
        int n = super.compareTo(texture);
        if (n != 0) {
            return n;
        }
        OffscreenTexture2D offscreenTexture2D = (OffscreenTexture2D)texture;
        if (this.numLayers != offscreenTexture2D.numLayers) {
            return this.numLayers < offscreenTexture2D.numLayers ? -1 : 1;
        }
        for (int i = 0; i < this.numLayers; ++i) {
            n = this.layers[i].compareTo(offscreenTexture2D.layers[i]);
            if (n == 0) continue;
            return n;
        }
        if (this.repaintNeeded != offscreenTexture2D.repaintNeeded) {
            return this.repaintNeeded ? 1 : -1;
        }
        if (this.height != offscreenTexture2D.height) {
            return this.height < offscreenTexture2D.height ? -1 : 1;
        }
        if (this.boundaryModeS != offscreenTexture2D.boundaryModeS) {
            return this.boundaryModeS < offscreenTexture2D.boundaryModeS ? -1 : 1;
        }
        if (this.boundaryModeT != offscreenTexture2D.boundaryModeT) {
            return this.boundaryModeT < offscreenTexture2D.boundaryModeT ? -1 : 1;
        }
        if (this.clearColor[0] != offscreenTexture2D.clearColor[0]) {
            return this.clearColor[0] < offscreenTexture2D.clearColor[0] ? -1 : 1;
        }
        if (this.clearColor[1] != offscreenTexture2D.clearColor[1]) {
            return this.clearColor[1] < offscreenTexture2D.clearColor[1] ? -1 : 1;
        }
        if (this.clearColor[2] != offscreenTexture2D.clearColor[2]) {
            return this.clearColor[2] < offscreenTexture2D.clearColor[2] ? -1 : 1;
        }
        if (this.clearColor[3] != offscreenTexture2D.clearColor[3]) {
            return this.clearColor[3] < offscreenTexture2D.clearColor[3] ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(Texture texture) {
        if (!super.equals(texture)) {
            return false;
        }
        if (!(texture instanceof OffscreenTexture2D)) {
            return false;
        }
        OffscreenTexture2D offscreenTexture2D = (OffscreenTexture2D)texture;
        if (this.height != offscreenTexture2D.height || this.boundaryModeS != offscreenTexture2D.boundaryModeS || this.boundaryModeT != offscreenTexture2D.boundaryModeT || this.numLayers != offscreenTexture2D.numLayers || this.repaintNeeded != offscreenTexture2D.repaintNeeded || this.clearColor[0] != offscreenTexture2D.clearColor[0] || this.clearColor[1] != offscreenTexture2D.clearColor[1] || this.clearColor[2] != offscreenTexture2D.clearColor[2] || this.clearColor[3] != offscreenTexture2D.clearColor[3]) {
            return false;
        }
        for (int i = 0; i < this.numLayers; ++i) {
            if (this.layers[i].equals(offscreenTexture2D.layers[i])) continue;
            return false;
        }
        return true;
    }
}

