/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import org.j3d.aviatrix3d.AlreadyParentedException;
import org.j3d.aviatrix3d.CyclicSceneGraphStructureException;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.SceneGraphObject;

public abstract class ObjectSet
extends SceneGraphObject {
    private static final String CHILD_IDX_ERR = "Index provided > last valid index";
    private static final int LIST_START_SIZE = 5;
    private static final int LIST_INCREMENT = 5;
    protected SceneGraphObject[] childList = new SceneGraphObject[5];
    protected int lastChild = 0;

    protected ObjectSet() {
    }

    protected void checkForCyclicChild(SceneGraphObject sceneGraphObject) throws CyclicSceneGraphStructureException {
        if (sceneGraphObject == this) {
            throw new CyclicSceneGraphStructureException();
        }
        for (int i = 0; i < this.lastChild; ++i) {
            if (this.childList[i] == null) continue;
            this.childList[i].checkForCyclicChild(sceneGraphObject);
        }
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        for (int i = 0; i < this.lastChild; ++i) {
            if (this.childList[i] == null) continue;
            this.childList[i].setUpdateHandler(nodeUpdateHandler);
        }
    }

    protected void setLive(boolean bl) {
        for (int i = 0; i < this.lastChild; ++i) {
            if (this.childList[i] == null) continue;
            this.childList[i].setLive(bl);
        }
        super.setLive(bl);
    }

    public void addChild(SceneGraphObject sceneGraphObject) throws AlreadyParentedException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.resizeList();
        this.childList[this.lastChild++] = sceneGraphObject;
        if (sceneGraphObject != null) {
            if (sceneGraphObject.isLive() != this.alive) {
                sceneGraphObject.setLive(this.alive);
            }
            sceneGraphObject.setUpdateHandler(this.updateHandler);
        }
    }

    public void setChild(SceneGraphObject sceneGraphObject, int n) throws AlreadyParentedException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n > this.lastChild) {
            throw new IndexOutOfBoundsException(CHILD_IDX_ERR);
        }
        if (this.childList[n] != null) {
            this.childList[n].setLive(false);
        }
        this.childList[n] = sceneGraphObject;
        if (sceneGraphObject != null) {
            if (sceneGraphObject.isLive() != this.alive) {
                sceneGraphObject.setLive(this.alive);
            }
            sceneGraphObject.setUpdateHandler(this.updateHandler);
        }
    }

    public void removeChild(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n > this.lastChild) {
            throw new IndexOutOfBoundsException(CHILD_IDX_ERR);
        }
        if (this.childList[n] != null) {
            this.childList[n].setLive(false);
        }
        System.arraycopy(this.childList, n + 1, this.childList, n, this.lastChild - n);
        --this.lastChild;
    }

    public SceneGraphObject getChild(int n) {
        if (n < 0 || n > this.lastChild) {
            throw new IndexOutOfBoundsException(CHILD_IDX_ERR);
        }
        return this.childList[n];
    }

    public SceneGraphObject[] getAllChildren() {
        return this.childList;
    }

    public int numChildren() {
        return this.lastChild;
    }

    public int indexOfChild(SceneGraphObject sceneGraphObject) {
        for (int i = 0; i < this.lastChild; ++i) {
            if (sceneGraphObject != this.childList[i]) continue;
            return i;
        }
        return -1;
    }

    public void removeChild(SceneGraphObject sceneGraphObject) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        int n = this.indexOfChild(sceneGraphObject);
        if (n == -1) {
            return;
        }
        this.removeChild(n);
    }

    public void removeAllChildren() throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        for (int i = 0; i < this.lastChild; ++i) {
            if (this.childList[i] == null) continue;
            this.childList[i].setLive(false);
            this.childList[i] = null;
        }
        this.lastChild = 0;
    }

    private final void resizeList() {
        if (this.lastChild + 1 == this.childList.length) {
            int n = this.childList.length;
            int n2 = n + 5;
            SceneGraphObject[] sceneGraphObjectArray = new SceneGraphObject[n2];
            System.arraycopy(this.childList, 0, sceneGraphObjectArray, 0, n);
            this.childList = sceneGraphObjectArray;
        }
    }
}

