/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import org.j3d.aviatrix3d.AlreadyParentedException;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.MultipassScene;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.Viewport;
import org.j3d.aviatrix3d.rendering.SceneCullable;
import org.j3d.aviatrix3d.rendering.ViewportCullable;
import org.j3d.aviatrix3d.rendering.ViewportLayerCullable;

public class MultipassViewport
extends Viewport
implements ViewportCullable,
ViewportLayerCullable {
    protected static final String HAS_PARENT_MSG = "This scene already has a parent. Scenes cannot be shared amongst layers multiple times.";
    private MultipassScene scene;

    public MultipassViewport() {
        super(2);
    }

    public ViewportLayerCullable getCullableLayer(int n) {
        return this;
    }

    public int numCullableChildren() {
        return this.scene != null ? 1 : 0;
    }

    public boolean isMultipassViewport() {
        return true;
    }

    public boolean isAudioSource() {
        return false;
    }

    public SceneCullable getCullableScene() {
        return this.scene instanceof SceneCullable ? this.scene : null;
    }

    public void setDimensions(int n, int n2, int n3, int n4) throws InvalidWriteTimingException {
        super.setDimensions(n, n2, n3, n4);
        if (this.scene != null) {
            this.scene.setViewportDimensions(n, n2, n3, n4);
        }
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        if (this.scene != null) {
            this.scene.setUpdateHandler(nodeUpdateHandler);
        }
    }

    protected void setLive(boolean bl) {
        super.setLive(bl);
        if (this.scene != null) {
            this.scene.setLive(bl);
        }
    }

    public void setScene(MultipassScene multipassScene) throws InvalidWriteTimingException, AlreadyParentedException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.scene = multipassScene;
        if (multipassScene == null) {
            return;
        }
        if (multipassScene.hasParent()) {
            throw new AlreadyParentedException(HAS_PARENT_MSG);
        }
        multipassScene.setUpdateHandler(this.updateHandler);
        multipassScene.setViewportDimensions(this.viewX, this.viewY, this.viewWidth, this.viewHeight);
        multipassScene.setLive(this.alive);
    }

    public MultipassScene getScene() {
        return this.scene;
    }
}

