/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import org.j3d.aviatrix3d.CyclicSceneGraphStructureException;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.MultipassRenderObserver;
import org.j3d.aviatrix3d.MultipassTextureSource;
import org.j3d.aviatrix3d.NodeComponent;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.ViewportLayer;

public class MultipassTextureComponent
extends NodeComponent
implements MultipassTextureSource {
    protected int format;
    protected ViewportLayer viewLayer;
    protected float[] clearColor;
    protected int numLevels;
    private boolean repaintNeeded;
    protected int[] formats;
    protected MultipassRenderObserver observer;
    protected int glBuffers;
    private int bufferWidth;
    private int bufferHeight;

    public MultipassTextureComponent(int n, int n2) {
        this.bufferWidth = n;
        this.bufferHeight = n2;
        this.clearColor = new float[4];
        this.glBuffers = 16384;
    }

    public MultipassRenderObserver getRenderObserver() {
        return this.observer;
    }

    public int getUsedBuffers() {
        return this.glBuffers;
    }

    public void setNumLevels(int n) throws InvalidWriteTimingException, IllegalArgumentException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.numLevels = n;
    }

    public ViewportLayer getViewportLayer() {
        return this.viewLayer;
    }

    public int getHeight() {
        return this.bufferHeight;
    }

    public boolean isRepaintRequired() {
        return this.repaintNeeded;
    }

    public void getClearColor(float[] fArray) {
        fArray[0] = this.clearColor[0];
        fArray[1] = this.clearColor[1];
        fArray[2] = this.clearColor[2];
        fArray[3] = this.clearColor[3];
    }

    public int getWidth() {
        return this.bufferHeight;
    }

    public int getNumLevels() {
        return this.numLevels;
    }

    public int getFormat(int n) {
        return this.formats[n];
    }

    protected void checkForCyclicChild(SceneGraphObject sceneGraphObject) throws CyclicSceneGraphStructureException {
        if (sceneGraphObject == this) {
            throw new CyclicSceneGraphStructureException();
        }
        if (this.viewLayer != null) {
            this.viewLayer.checkForCyclicChild(sceneGraphObject);
        }
    }

    protected void setLive(boolean bl) {
        if (bl) {
            ++this.liveCount;
        } else if (this.liveCount > 0) {
            --this.liveCount;
        }
        if (this.liveCount == 0 || !this.alive) {
            super.setLive(bl);
            if (this.viewLayer != null) {
                this.viewLayer.setLive(bl);
            }
        }
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        if (this.viewLayer != null) {
            this.viewLayer.setUpdateHandler(this.updateHandler);
        }
    }

    public void setViewportLayer(ViewportLayer viewportLayer) throws InvalidWriteTimingException, CyclicSceneGraphStructureException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.viewLayer != null) {
            this.viewLayer.setLive(false);
        }
        if (viewportLayer != null) {
            viewportLayer.checkForCyclicChild(this);
        }
        this.viewLayer = viewportLayer;
        if (this.viewLayer != null) {
            this.viewLayer.setViewportDimensions(0, 0, this.bufferWidth, this.bufferHeight);
            this.viewLayer.setUpdateHandler(this.updateHandler);
            this.viewLayer.setLive(this.alive);
        }
    }

    public void setRenderObserver(MultipassRenderObserver multipassRenderObserver) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.observer = multipassRenderObserver;
    }

    public void setRepaintRequired(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.repaintNeeded = bl;
    }

    public void setClearColor(float f, float f2, float f3, float f4) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.clearColor[0] = f;
        this.clearColor[1] = f2;
        this.clearColor[2] = f3;
        this.clearColor[3] = f4;
    }

    public void setUsedBuffers(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.glBuffers = n;
    }
}

