/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.util.ArrayList;
import org.j3d.aviatrix3d.Background;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.RenderPass;
import org.j3d.aviatrix3d.Scene;
import org.j3d.aviatrix3d.SharedGroup;
import org.j3d.aviatrix3d.SharedNode;
import org.j3d.aviatrix3d.rendering.RenderPassCullable;
import org.j3d.aviatrix3d.rendering.SceneCullable;
import org.j3d.aviatrix3d.rendering.ViewEnvironmentCullable;

public class MultipassScene
extends Scene
implements SceneCullable {
    private static final String SHARED_BG_MSG = "The path from the root of the scene graph to the background contains a SharedGroup or SharedNode instance. This is not permitted.";
    private static final String PASS_RANGE_MSG = "Request for a RenderPass object that is out of range";
    private static final String NULL_PASS_ERR = "The RenderPass instance cannot be null";
    private ArrayList<RenderPass> renderPasses = new ArrayList();
    private Background currentBackground;

    public boolean isMultipassScene() {
        return true;
    }

    public ViewEnvironmentCullable getViewCullable() {
        return this.viewEnvironment;
    }

    public RenderPassCullable getCullablePass(int n) {
        if (n < 0 || n >= this.renderPasses.size()) {
            return null;
        }
        return this.renderPasses.get(n);
    }

    public int numCullableChildren() {
        return this.renderPasses.size();
    }

    void setViewportDimensions(int n, int n2, int n3, int n4) {
        super.setViewportDimensions(n, n2, n3, n4);
        for (int i = 0; i < this.renderPasses.size(); ++i) {
            RenderPass renderPass = this.renderPasses.get(i);
            renderPass.setViewportDimensions(n, n2, n3, n4);
        }
    }

    protected void setLive(boolean bl) {
        super.setLive(bl);
        for (int i = 0; i < this.renderPasses.size(); ++i) {
            RenderPass renderPass = this.renderPasses.get(i);
            renderPass.setLive(bl);
        }
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        for (int i = 0; i < this.renderPasses.size(); ++i) {
            RenderPass renderPass = this.renderPasses.get(i);
            renderPass.setUpdateHandler(nodeUpdateHandler);
        }
    }

    public void addRenderPass(RenderPass renderPass) throws InvalidWriteTimingException, IllegalArgumentException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isPickingPermitted() && renderPass == null) {
            throw new IllegalArgumentException(NULL_PASS_ERR);
        }
        renderPass.setUpdateHandler(this.updateHandler);
        renderPass.setLive(this.alive);
        this.renderPasses.add(renderPass);
    }

    public void setRenderPass(int n, RenderPass renderPass) throws InvalidWriteTimingException, IllegalArgumentException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isPickingPermitted() && renderPass == null) {
            throw new IllegalArgumentException(NULL_PASS_ERR);
        }
        if (n < 0 || n >= this.renderPasses.size()) {
            throw new IllegalArgumentException(PASS_RANGE_MSG);
        }
        renderPass.setUpdateHandler(this.updateHandler);
        renderPass.setLive(this.alive);
        RenderPass renderPass2 = this.renderPasses.get(n);
        renderPass2.setLive(false);
        this.renderPasses.set(n, renderPass);
    }

    public void removeRenderPass(int n) throws InvalidWriteTimingException, IllegalArgumentException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isPickingPermitted() && (n < 0 || n >= this.renderPasses.size())) {
            throw new IllegalArgumentException(PASS_RANGE_MSG);
        }
        RenderPass renderPass = this.renderPasses.remove(n);
        renderPass.setLive(false);
    }

    public RenderPass getRenderPass(int n) throws IllegalArgumentException {
        if (n < 0 || n >= this.renderPasses.size()) {
            throw new IllegalArgumentException(PASS_RANGE_MSG);
        }
        return this.renderPasses.get(n);
    }

    public void getRenderPasses(RenderPass[] renderPassArray) throws IllegalArgumentException {
        this.renderPasses.toArray(renderPassArray);
    }

    public int numRenderPasses() {
        return this.renderPasses.size();
    }

    public void setActiveBackground(Background background) throws InvalidWriteTimingException, IllegalArgumentException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (background != null) {
            for (Node node = background.getParent(); node != null; node = node.getParent()) {
                if (!(node instanceof SharedGroup) && !(node instanceof SharedNode)) continue;
                throw new IllegalArgumentException(SHARED_BG_MSG);
            }
        }
        this.currentBackground = background;
    }

    public Background getActiveBackground() {
        return this.currentBackground;
    }
}

