/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.io.Serializable;
import java.util.HashMap;
import javax.media.opengl.GL;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.NodeComponent;
import org.j3d.aviatrix3d.rendering.AppearanceAttributeRenderable;

public class LineAttributes
extends NodeComponent
implements AppearanceAttributeRenderable {
    private static final String STIPPLE_SIZE_MSG = "The stipple pattern array must be at least 1024 items in size";
    private static final String LINE_SIZE_MSG = "The line size must be greater than zero";
    public static final short PATTERN_SOLID = 0;
    public static final short PATTERN_DASH = -4370;
    public static final short PATTERN_DOT = -21846;
    public static final short PATTERN_DASH_DOT = -6940;
    public static final short PATTERN_DASH_DOT_DOT = -5398;
    public static final short PATTERN_STITCH_LINE = -13108;
    public static final short PATTERN_CHAIN_LINE = -2314;
    public static final short PATTERN_CENTER_LINE = -1029;
    public static final short PATTERN_PHANTOM_LINE = -4370;
    private float lineSize = 1.0f;
    private boolean antialias = false;
    private boolean stateChanged = true;
    private HashMap<GL, Integer> displayListMap = new HashMap(1);
    private short stipplePattern = 0;
    private int stippleScale = 1;

    public int getAttributeType() {
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(GL gL) {
        Serializable serializable;
        if (this.stateChanged) {
            serializable = this.displayListMap;
            synchronized (serializable) {
                this.displayListMap.clear();
                this.stateChanged = false;
            }
        }
        if ((serializable = this.displayListMap.get(gL)) == null) {
            serializable = new Integer(gL.glGenLists(1));
            gL.glNewList(((Integer)serializable).intValue(), 4864);
            gL.glPushAttrib(4);
            if (this.antialias) {
                gL.glEnable(2848);
            }
            if (this.lineSize != 1.0f) {
                gL.glLineWidth(this.lineSize);
            }
            if (this.stipplePattern != 0) {
                gL.glEnable(2852);
                gL.glLineStipple(this.stippleScale, this.stipplePattern);
            }
            gL.glEndList();
            this.displayListMap.put(gL, (Integer)serializable);
        }
        gL.glCallList(((Integer)serializable).intValue());
    }

    public void postRender(GL gL) {
        if (this.antialias) {
            gL.glDisable(2848);
        }
        if (this.lineSize != 1.0f) {
            gL.glLineWidth(1.0f);
        }
        if (this.stipplePattern != 0) {
            gL.glDisable(2852);
        }
        gL.glPopAttrib();
    }

    public int compareTo(Object object) throws ClassCastException {
        LineAttributes lineAttributes = (LineAttributes)object;
        return this.compareTo(lineAttributes);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LineAttributes)) {
            return false;
        }
        return this.equals((LineAttributes)object);
    }

    public void setAntiAliased(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.antialias != bl) {
            this.antialias = bl;
            this.stateChanged = true;
        }
    }

    public boolean isAntiAliased() {
        return this.antialias;
    }

    public void setLineWidth(float f) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException(LINE_SIZE_MSG);
        }
        if (this.lineSize != f) {
            this.lineSize = f;
            this.stateChanged = true;
        }
    }

    public float getLineWidth() {
        return this.lineSize;
    }

    public void setStipplePattern(short s) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.stipplePattern != s) {
            this.stateChanged = true;
            this.stipplePattern = s;
        }
    }

    public short getStipplePattern() {
        return this.stipplePattern;
    }

    public void setStippleScaleFactor(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.stippleScale != n) {
            this.stateChanged = true;
            this.stippleScale = n;
        }
    }

    public int getStippleScaleFactor() {
        return this.stippleScale;
    }

    public int compareTo(LineAttributes lineAttributes) {
        if (lineAttributes == null) {
            return 1;
        }
        if (lineAttributes == this) {
            return 0;
        }
        if (this.antialias != lineAttributes.antialias) {
            return this.antialias ? 1 : -1;
        }
        if (this.lineSize != lineAttributes.lineSize) {
            return this.lineSize < lineAttributes.lineSize ? -1 : 1;
        }
        if (this.stipplePattern != lineAttributes.stipplePattern) {
            return this.stipplePattern < lineAttributes.stipplePattern ? -1 : 1;
        }
        if (this.stippleScale != lineAttributes.stippleScale) {
            return this.stippleScale < lineAttributes.stippleScale ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(LineAttributes lineAttributes) {
        if (lineAttributes == this) {
            return true;
        }
        return lineAttributes != null && this.antialias == lineAttributes.antialias && this.lineSize == lineAttributes.lineSize && this.stipplePattern == lineAttributes.stipplePattern && this.stippleScale == lineAttributes.stippleScale;
    }
}

