/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Leaf;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.j3d.aviatrix3d.rendering.ComponentRenderable;
import org.j3d.aviatrix3d.rendering.EffectRenderable;
import org.j3d.aviatrix3d.rendering.LeafCullable;
import org.j3d.aviatrix3d.rendering.Renderable;

public abstract class Light
extends Leaf
implements LeafCullable,
ComponentRenderable,
EffectRenderable {
    protected static final int SPOT_TYPE = 1;
    protected static final int POINT_TYPE = 2;
    protected static final int DIRECTIONAL_TYPE = 3;
    protected static final int AMBIENT_TYPE = 4;
    protected float[] ambientColor;
    protected float[] diffuseColor;
    protected float[] specularColor;
    protected boolean enabled;
    protected boolean globalOnly;
    protected BoundingVolume effectBounds;
    private final int lightType;

    protected Light(int n) {
        this.lightType = n;
        this.diffuseColor = new float[4];
        this.diffuseColor[3] = 1.0f;
        this.specularColor = new float[4];
        this.specularColor[3] = 1.0f;
        this.ambientColor = new float[4];
        this.ambientColor[3] = 1.0f;
        this.enabled = false;
        this.globalOnly = false;
    }

    protected Light(int n, float[] fArray) throws IllegalArgumentException {
        this(n);
        if (fArray[0] < 0.0f || fArray[0] > 1.0f) {
            throw new IllegalArgumentException("Red component out of range");
        }
        if (fArray[1] < 0.0f || fArray[1] > 1.0f) {
            throw new IllegalArgumentException("Green component out of range");
        }
        if (fArray[2] < 0.0f || fArray[2] > 1.0f) {
            throw new IllegalArgumentException("Blue component out of range");
        }
        this.diffuseColor[0] = fArray[0];
        this.diffuseColor[1] = fArray[1];
        this.diffuseColor[2] = fArray[2];
    }

    public int getCullableType() {
        return 2;
    }

    public Renderable getRenderable() {
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isGlobalOnly() {
        return this.globalOnly;
    }

    public BoundingVolume getEffectBounds() {
        return this.effectBounds;
    }

    public int compareTo(Object object) throws ClassCastException {
        Light light = (Light)object;
        return this.compareTo(light);
    }

    public void setEnabled(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.enabled = bl;
    }

    public void setGlobalOnly(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.globalOnly = bl;
    }

    public void setEffectBounds(BoundingVolume boundingVolume) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.effectBounds = boundingVolume;
        this.bounds = boundingVolume;
    }

    public void setAmbientColor(float[] fArray) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (fArray[0] < 0.0f || fArray[0] > 1.0f) {
            throw new IllegalArgumentException("Red component out of range");
        }
        if (fArray[1] < 0.0f || fArray[1] > 1.0f) {
            throw new IllegalArgumentException("Green component out of range");
        }
        if (fArray[2] < 0.0f || fArray[2] > 1.0f) {
            throw new IllegalArgumentException("Blue component out of range");
        }
        this.ambientColor[0] = fArray[0];
        this.ambientColor[1] = fArray[1];
        this.ambientColor[2] = fArray[2];
    }

    public void getAmbientColor(float[] fArray) {
        fArray[0] = this.ambientColor[0];
        fArray[1] = this.ambientColor[1];
        fArray[2] = this.ambientColor[2];
    }

    public void setDiffuseColor(float[] fArray) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (fArray[0] < 0.0f || fArray[0] > 1.0f) {
            throw new IllegalArgumentException("Red component out of range");
        }
        if (fArray[1] < 0.0f || fArray[1] > 1.0f) {
            throw new IllegalArgumentException("Green component out of range");
        }
        if (fArray[2] < 0.0f || fArray[2] > 1.0f) {
            throw new IllegalArgumentException("Blue component out of range");
        }
        this.diffuseColor[0] = fArray[0];
        this.diffuseColor[1] = fArray[1];
        this.diffuseColor[2] = fArray[2];
    }

    public void getDiffuseColor(float[] fArray) {
        fArray[0] = this.diffuseColor[0];
        fArray[1] = this.diffuseColor[1];
        fArray[2] = this.diffuseColor[2];
    }

    public void setSpecularColor(float[] fArray) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (fArray[0] < 0.0f || fArray[0] > 1.0f) {
            throw new IllegalArgumentException("Red component out of range");
        }
        if (fArray[1] < 0.0f || fArray[1] > 1.0f) {
            throw new IllegalArgumentException("Green component out of range");
        }
        if (fArray[2] < 0.0f || fArray[2] > 1.0f) {
            throw new IllegalArgumentException("Blue component out of range");
        }
        this.specularColor[0] = fArray[0];
        this.specularColor[1] = fArray[1];
        this.specularColor[2] = fArray[2];
    }

    public void getSpecularColor(float[] fArray) {
        fArray[0] = this.specularColor[0];
        fArray[1] = this.specularColor[1];
        fArray[2] = this.specularColor[2];
    }

    public int compareTo(Light light) {
        if (light == null) {
            return 1;
        }
        if (light == this) {
            return 0;
        }
        if (light.lightType != this.lightType) {
            return this.lightType < light.lightType ? -1 : 1;
        }
        if (this.enabled != light.enabled) {
            return this.enabled ? 1 : -1;
        }
        if (this.globalOnly != light.globalOnly) {
            return this.globalOnly ? 1 : -1;
        }
        int n = this.compareColor3(this.diffuseColor, light.diffuseColor);
        if (n != 0) {
            return n;
        }
        n = this.compareColor3(this.specularColor, light.specularColor);
        if (n != 0) {
            return n;
        }
        return this.compareColor3(this.ambientColor, light.ambientColor);
    }

    protected int compareColor3(float[] fArray, float[] fArray2) {
        if (fArray[0] < fArray2[0]) {
            return -1;
        }
        if (fArray[0] > fArray2[0]) {
            return 1;
        }
        if (fArray[1] < fArray2[1]) {
            return -1;
        }
        if (fArray[1] > fArray2[1]) {
            return 1;
        }
        if (fArray[2] < fArray2[2]) {
            return -1;
        }
        if (fArray[2] > fArray2[2]) {
            return 1;
        }
        return 0;
    }
}

