/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.HashMap;
import javax.media.opengl.GL;
import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.VertexGeometry;

public abstract class IndexedVertexGeometry
extends VertexGeometry {
    private static final String MAX_INDEX_MSG = "The maximum index value provided is greater than the number of coordinates provided to this geometry object.";
    protected int[] indices;
    protected int numIndices;
    protected int numIndicesUsed;
    protected IntBuffer indexBuffer;
    protected HashMap<GL, Integer> vboElementIdMap;

    protected IndexedVertexGeometry() {
        this(false, 35044);
    }

    protected IndexedVertexGeometry(boolean bl, int n) {
        super(bl, n);
        if (bl) {
            this.vboElementIdMap = new HashMap();
        }
    }

    protected boolean isVisible() {
        return super.isVisible() && this.numIndices != 0;
    }

    protected void recomputeBounds() {
        if (this.numIndicesUsed == 0) {
            return;
        }
        int n = this.indices[0];
        float f = this.coordinates[n];
        float f2 = this.coordinates[n + 1];
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = this.coordinates[n];
        float f6 = this.coordinates[n + 1];
        float f7 = 0.0f;
        float f8 = 0.0f;
        switch (this.vertexFormat & 7) {
            case 2: {
                int n2;
                for (n2 = 1; n2 < this.numIndicesUsed; ++n2) {
                    n = this.indices[n2] * 2;
                    if (this.coordinates[n] < f) {
                        f = this.coordinates[n];
                    }
                    if (this.coordinates[n] > f5) {
                        f5 = this.coordinates[n];
                    }
                    if (this.coordinates[n + 1] < f2) {
                        f2 = this.coordinates[n + 1];
                    }
                    if (!(this.coordinates[n + 1] > f6)) continue;
                    f6 = this.coordinates[n + 1];
                }
                break;
            }
            case 3: {
                int n2;
                f3 = this.coordinates[n + 2];
                f7 = this.coordinates[n + 2];
                for (n2 = 1; n2 < this.numIndicesUsed; ++n2) {
                    n = this.indices[n2] * 3;
                    if (this.coordinates[n] < f) {
                        f = this.coordinates[n];
                    }
                    if (this.coordinates[n] > f5) {
                        f5 = this.coordinates[n];
                    }
                    if (this.coordinates[n + 1] < f2) {
                        f2 = this.coordinates[n + 1];
                    }
                    if (this.coordinates[n + 1] > f6) {
                        f6 = this.coordinates[n + 1];
                    }
                    if (this.coordinates[n + 2] < f3) {
                        f3 = this.coordinates[n + 2];
                    }
                    if (!(this.coordinates[n + 2] > f7)) continue;
                    f7 = this.coordinates[n + 2];
                }
                break;
            }
            case 4: {
                int n2;
                f3 = this.coordinates[n + 2];
                f7 = this.coordinates[n + 2];
                f4 = this.coordinates[n + 3];
                f8 = this.coordinates[n + 3];
                for (n2 = 1; n2 < this.numIndicesUsed; ++n2) {
                    n = this.indices[n2] * 4;
                    if (this.coordinates[n] < f) {
                        f = this.coordinates[n];
                    }
                    if (this.coordinates[n] > f5) {
                        f5 = this.coordinates[n];
                    }
                    if (this.coordinates[n + 1] < f2) {
                        f2 = this.coordinates[n + 1];
                    }
                    if (this.coordinates[n + 1] > f6) {
                        f6 = this.coordinates[n + 1];
                    }
                    if (this.coordinates[n + 2] < f3) {
                        f3 = this.coordinates[n + 2];
                    }
                    if (!(this.coordinates[n + 2] > f7)) continue;
                    f7 = this.coordinates[n + 2];
                }
                break;
            }
        }
        BoundingBox boundingBox = (BoundingBox)this.bounds;
        boundingBox.setMinimum(f, f2, f3);
        boundingBox.setMaximum(f5, f6, f7);
    }

    protected void setVertexStateVBO(GL gL) {
        Integer n = this.vboElementIdMap.get(gL);
        if (n == null) {
            int[] nArray = new int[1];
            gL.glGenBuffers(1, nArray, 0);
            this.vboElementIdMap.put(gL, new Integer(nArray[0]));
            gL.glBindBuffer(34963, nArray[0]);
            this.dataChanged.put(gL, true);
        }
        super.setVertexStateVBO(gL);
    }

    protected int fillBufferData(GL gL) {
        int n = super.fillBufferData(gL);
        Integer n2 = this.vboElementIdMap.get(gL);
        gL.glBindBuffer(34963, n2.intValue());
        gL.glBufferData(34963, this.numIndices * 4, (Buffer)null, this.vboHint);
        gL.glBufferSubData(34963, 0, this.numIndices * 4, (Buffer)this.indexBuffer);
        return this.numIndices;
    }

    public void cleanup(GL gL) {
        Integer n;
        super.cleanup(gL);
        if (this.useVbo && (n = this.vboElementIdMap.get(gL)) != null) {
            int[] nArray = new int[]{n};
            gL.glDeleteBuffers(1, nArray, 0);
            this.vboElementIdMap.remove(gL);
        }
    }

    public void setIndices(int[] nArray, int n) throws InvalidWriteTimingException, IllegalArgumentException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] <= n2) continue;
            n2 = nArray[i];
        }
        if (n2 + 1 > this.numCoords) {
            throw new IllegalArgumentException(MAX_INDEX_MSG);
        }
        this.numRequiredCoords = n2 + 1;
        this.numIndices = n;
        if (this.indices == null || this.indices.length < this.numIndices) {
            this.indices = new int[this.numIndices];
        }
        if (this.numIndices > 0) {
            System.arraycopy(nArray, 0, this.indices, 0, this.numIndices);
        }
        if (this.indexBuffer == null || this.numIndices > this.indexBuffer.capacity()) {
            this.indexBuffer = this.createBuffer(this.numIndices);
        } else {
            this.indexBuffer.clear();
        }
        this.indexBuffer.put(nArray, 0, this.numIndices);
        this.indexBuffer.rewind();
    }

    public int getValidIndexCount() {
        return this.numIndices;
    }

    public void getIndices(int[] nArray) {
        System.arraycopy(this.indices, 0, nArray, 0, this.numIndices);
    }

    public void setVBOEnabled(boolean bl) throws InvalidWriteTimingException {
        super.setVBOEnabled(bl);
        if (vboQueryComplete && !vboAvailable) {
            return;
        }
        if (bl && this.vboElementIdMap == null) {
            this.vboElementIdMap = new HashMap();
        }
    }

    private IntBuffer createBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        return intBuffer;
    }
}

