/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.media.opengl.GL;
import org.j3d.aviatrix3d.IndexedVertexGeometry;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.picking.NotPickableException;

public class IndexedQuadArray
extends IndexedVertexGeometry {
    private ByteBuffer edgeBuffer = ByteBuffer.allocate(0);
    private boolean[] edgeFlags;
    private long edgeOffset = -1L;

    public IndexedQuadArray() {
        this.initPolygonDetails(4);
    }

    public IndexedQuadArray(boolean bl, int n) {
        super(bl, n);
        this.initPolygonDetails(4);
    }

    public void render(GL gL) {
        if ((this.vertexFormat & 7) == 0 || this.numCoords == 0 || this.numIndices == 0) {
            return;
        }
        this.setVertexState(gL);
        if ((this.vertexFormat & 0x10000) != 0) {
            gL.glEnableClientState(32889);
        }
        if (vboAvailable && this.useVbo) {
            Integer n = (Integer)this.vboElementIdMap.get(gL);
            gL.glBindBuffer(34963, n.intValue());
            if ((this.vertexFormat & 0x10000) != 0) {
                gL.glEdgeFlagPointer(0, this.edgeOffset);
            }
            gL.glDrawElements(7, this.numIndices, 5125, 0L);
            gL.glBindBuffer(34963, 0);
        } else {
            if ((this.vertexFormat & 0x10000) != 0) {
                gL.glEdgeFlagPointer(0, (Buffer)this.edgeBuffer);
            }
            gL.glDrawElements(7, this.numIndices, 5125, (Buffer)this.indexBuffer);
        }
        if ((this.vertexFormat & 0x10000) != 0) {
            gL.glDisableClientState(32889);
            gL.glEdgeFlag(true);
        }
        this.clearVertexState(gL);
    }

    protected int computeBufferSize() {
        int n = super.computeBufferSize();
        if ((this.vertexFormat & 0x10000) != 0) {
            n += this.numCoords;
        }
        return n;
    }

    protected int fillBufferData(GL gL) {
        int n = super.fillBufferData(gL);
        if ((this.vertexFormat & 0x10000) != 0) {
            this.edgeOffset = n;
            gL.glBufferSubData(34962, n, this.numCoords, (Buffer)this.edgeBuffer);
            n += this.numCoords;
        }
        return n;
    }

    public boolean pickLineSegment(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        super.pickLineSegment(fArray, fArray2, bl, fArray3, n);
        float f = Float.POSITIVE_INFINITY;
        boolean bl2 = false;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = fArray2[0];
        float f6 = fArray2[1];
        float f7 = fArray2[2];
        float f8 = fArray2[0] - fArray[0];
        float f9 = fArray2[1] - fArray[1];
        float f10 = fArray2[2] - fArray[2];
        float f11 = (float)Math.sqrt(f8 * f8 + f9 * f9 + f10 * f10);
        fArray2[0] = f8;
        fArray2[1] = f9;
        fArray2[2] = f10;
        int n2 = 0;
        int n3 = this.vertexFormat & 7;
        int n4 = this.numCoords / 4;
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            switch (n3) {
                case 2: {
                    n2 = this.indices[n5] * 2;
                    this.wkPolygon[0] = this.coordinates[n2];
                    this.wkPolygon[1] = this.coordinates[n2 + 1];
                    this.wkPolygon[2] = 0.0f;
                    n2 = this.indices[n5 + 1] * 2;
                    this.wkPolygon[3] = this.coordinates[n2];
                    this.wkPolygon[4] = this.coordinates[n2 + 1];
                    this.wkPolygon[5] = 0.0f;
                    n2 = this.indices[n5 + 2] * 2;
                    this.wkPolygon[6] = this.coordinates[n2];
                    this.wkPolygon[7] = this.coordinates[n2 + 1];
                    this.wkPolygon[8] = 0.0f;
                    n2 = this.indices[n5 + 3] * 2;
                    this.wkPolygon[9] = this.coordinates[n2];
                    this.wkPolygon[10] = this.coordinates[n2 + 1];
                    this.wkPolygon[11] = 0.0f;
                    break;
                }
                case 3: {
                    n2 = this.indices[n5] * 3;
                    this.wkPolygon[0] = this.coordinates[n2];
                    this.wkPolygon[1] = this.coordinates[n2 + 1];
                    this.wkPolygon[2] = this.coordinates[n2 + 2];
                    n2 = this.indices[n5 + 1] * 3;
                    this.wkPolygon[3] = this.coordinates[n2];
                    this.wkPolygon[4] = this.coordinates[n2 + 1];
                    this.wkPolygon[5] = this.coordinates[n2 + 2];
                    n2 = this.indices[n5 + 2] * 3;
                    this.wkPolygon[6] = this.coordinates[n2];
                    this.wkPolygon[7] = this.coordinates[n2 + 1];
                    this.wkPolygon[8] = this.coordinates[n2 + 2];
                    n2 = this.indices[n5 + 3] * 3;
                    this.wkPolygon[9] = this.coordinates[n2];
                    this.wkPolygon[10] = this.coordinates[n2 + 1];
                    this.wkPolygon[11] = this.coordinates[n2 + 2];
                    break;
                }
                case 4: {
                    n2 = this.indices[n5] * 4;
                    this.wkPolygon[0] = this.coordinates[n2];
                    this.wkPolygon[1] = this.coordinates[n2 + 1];
                    this.wkPolygon[2] = this.coordinates[n2 + 2];
                    n2 = this.indices[n5 + 1] * 4;
                    this.wkPolygon[3] = this.coordinates[n2];
                    this.wkPolygon[4] = this.coordinates[n2 + 1];
                    this.wkPolygon[5] = this.coordinates[n2 + 2];
                    n2 = this.indices[n5 + 2] * 4;
                    this.wkPolygon[6] = this.coordinates[n2];
                    this.wkPolygon[7] = this.coordinates[n2 + 1];
                    this.wkPolygon[8] = this.coordinates[n2 + 2];
                    n2 = this.indices[n5 + 3] * 4;
                    this.wkPolygon[9] = this.coordinates[n2];
                    this.wkPolygon[10] = this.coordinates[n2 + 1];
                    this.wkPolygon[11] = this.coordinates[n2 + 2];
                }
            }
            n5 += 4;
            if (!this.ray3DQuadChecked(fArray, fArray2, f11, fArray3)) continue;
            bl2 = true;
            if (bl) break;
            float f12 = fArray[0] - fArray3[0];
            float f13 = fArray[1] - fArray3[1];
            float f14 = fArray[2] - fArray3[2];
            float f15 = f12 * f12 + f13 * f13 + f14 * f14;
            if (!(f15 < f)) continue;
            f = f15;
            f2 = fArray3[0];
            f3 = fArray3[1];
            f4 = fArray3[2];
        }
        fArray3[0] = f2;
        fArray3[1] = f3;
        fArray3[2] = f4;
        fArray2[0] = f5;
        fArray2[1] = f6;
        fArray2[2] = f7;
        return bl2;
    }

    public boolean pickLineRay(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        super.pickLineRay(fArray, fArray2, bl, fArray3, n);
        float f = Float.POSITIVE_INFINITY;
        boolean bl2 = false;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        int n2 = 0;
        int n3 = this.vertexFormat & 7;
        int n4 = this.numCoords / 4;
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            switch (n3) {
                case 2: {
                    n2 = this.indices[n5] * 2;
                    this.wkPolygon[0] = this.coordinates[n2];
                    this.wkPolygon[1] = this.coordinates[n2 + 1];
                    this.wkPolygon[2] = 0.0f;
                    n2 = this.indices[n5 + 1] * 2;
                    this.wkPolygon[3] = this.coordinates[n2];
                    this.wkPolygon[4] = this.coordinates[n2 + 1];
                    this.wkPolygon[5] = 0.0f;
                    n2 = this.indices[n5 + 2] * 2;
                    this.wkPolygon[6] = this.coordinates[n2];
                    this.wkPolygon[7] = this.coordinates[n2 + 1];
                    this.wkPolygon[8] = 0.0f;
                    n2 = this.indices[n5 + 3] * 2;
                    this.wkPolygon[9] = this.coordinates[n2];
                    this.wkPolygon[10] = this.coordinates[n2 + 1];
                    this.wkPolygon[11] = 0.0f;
                    break;
                }
                case 3: {
                    n2 = this.indices[n5] * 3;
                    this.wkPolygon[0] = this.coordinates[n2];
                    this.wkPolygon[1] = this.coordinates[n2 + 1];
                    this.wkPolygon[2] = this.coordinates[n2 + 2];
                    n2 = this.indices[n5 + 1] * 3;
                    this.wkPolygon[3] = this.coordinates[n2];
                    this.wkPolygon[4] = this.coordinates[n2 + 1];
                    this.wkPolygon[5] = this.coordinates[n2 + 2];
                    n2 = this.indices[n5 + 2] * 3;
                    this.wkPolygon[6] = this.coordinates[n2];
                    this.wkPolygon[7] = this.coordinates[n2 + 1];
                    this.wkPolygon[8] = this.coordinates[n2 + 2];
                    n2 = this.indices[n5 + 3] * 3;
                    this.wkPolygon[9] = this.coordinates[n2];
                    this.wkPolygon[10] = this.coordinates[n2 + 1];
                    this.wkPolygon[11] = this.coordinates[n2 + 2];
                    break;
                }
                case 4: {
                    n2 = this.indices[n5] * 4;
                    this.wkPolygon[0] = this.coordinates[n2];
                    this.wkPolygon[1] = this.coordinates[n2 + 1];
                    this.wkPolygon[2] = this.coordinates[n2 + 2];
                    n2 = this.indices[n5 + 1] * 4;
                    this.wkPolygon[3] = this.coordinates[n2];
                    this.wkPolygon[4] = this.coordinates[n2 + 1];
                    this.wkPolygon[5] = this.coordinates[n2 + 2];
                    n2 = this.indices[n5 + 2] * 4;
                    this.wkPolygon[6] = this.coordinates[n2];
                    this.wkPolygon[7] = this.coordinates[n2 + 1];
                    this.wkPolygon[8] = this.coordinates[n2 + 2];
                    n2 = this.indices[n5 + 3] * 4;
                    this.wkPolygon[9] = this.coordinates[n2];
                    this.wkPolygon[10] = this.coordinates[n2 + 1];
                    this.wkPolygon[11] = this.coordinates[n2 + 2];
                }
            }
            n5 += 4;
            if (!this.ray3DQuadChecked(fArray, fArray2, 0.0f, fArray3)) continue;
            bl2 = true;
            if (bl) break;
            float f5 = fArray[0] - fArray3[0];
            float f6 = fArray[1] - fArray3[1];
            float f7 = fArray[2] - fArray3[2];
            float f8 = f5 * f5 + f6 * f6 + f7 * f7;
            if (!(f8 < f)) continue;
            f = f8;
            f2 = fArray3[0];
            f3 = fArray3[1];
            f4 = fArray3[2];
        }
        fArray3[0] = f2;
        fArray3[1] = f3;
        fArray3[2] = f4;
        return bl2;
    }

    protected void recomputeBounds() {
        this.numIndicesUsed = this.numIndices;
        super.recomputeBounds();
    }

    public int compareTo(Object object) throws ClassCastException {
        IndexedQuadArray indexedQuadArray = (IndexedQuadArray)object;
        return this.compareTo(indexedQuadArray);
    }

    public boolean equals(Object object) {
        if (!(object instanceof IndexedQuadArray)) {
            return false;
        }
        return this.equals((IndexedQuadArray)object);
    }

    public void setEdgeFlags(boolean[] blArray) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (blArray != null && blArray.length < this.numCoords) {
            throw new IllegalArgumentException("Edge flag array too short");
        }
        this.edgeFlags = blArray;
        if (this.numCoords > this.edgeBuffer.capacity()) {
            this.edgeBuffer = this.createBuffer(this.numCoords);
        } else {
            this.edgeBuffer.clear();
        }
        if (blArray == null) {
            this.vertexFormat &= 0xFFFEFFFF;
        } else {
            for (int i = 0; i < this.numCoords; ++i) {
                this.edgeBuffer.put((byte)(blArray[i] ? 1 : 0));
            }
            this.vertexFormat |= 0x10000;
            this.edgeBuffer.rewind();
        }
        this.dataChanged.setAll(true);
    }

    public int compareTo(IndexedQuadArray indexedQuadArray) {
        if (indexedQuadArray == null) {
            return 1;
        }
        if (indexedQuadArray == this) {
            return 0;
        }
        return 0;
    }

    public boolean equals(IndexedQuadArray indexedQuadArray) {
        return indexedQuadArray == this;
    }

    private ByteBuffer createBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer;
    }
}

