/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.TextureComponent3D;

public class ImageTextureComponent3D
extends TextureComponent3D {
    private static final String MATCH_FORMAT_MSG = "Not all images have the same format";
    private int[] pixelTmp;
    private RenderedImage[] images;

    public ImageTextureComponent3D() {
        this(0, 0, 0, 0, null);
    }

    public ImageTextureComponent3D(boolean bl) {
        this(0, 0, 0, 0, null);
        this.invertY = !bl;
    }

    public ImageTextureComponent3D(int n, int n2, int n3, int n4, RenderedImage[] renderedImageArray) {
        super(1);
        this.images = renderedImageArray;
        this.width = n2;
        this.height = n3;
        this.format = n;
        this.depth = n4;
        this.checkFormats();
    }

    public ImageTextureComponent3D(int n, int n2, int n3, int n4, RenderedImage[] renderedImageArray, boolean bl) {
        this(n, n2, n3, n4, renderedImageArray);
        this.invertY = !bl;
    }

    public ImageTextureComponent3D(int n, RenderedImage[] renderedImageArray) {
        super(1);
        this.format = n;
        this.images = renderedImageArray;
        this.checkFormats();
        if (!(renderedImageArray[0] instanceof BufferedImage)) {
            System.out.println("Can't handle RenderedImage in Image3D");
            return;
        }
        BufferedImage bufferedImage = (BufferedImage)renderedImageArray[0];
        this.width = renderedImageArray[0].getWidth();
        this.height = renderedImageArray[0].getHeight();
        this.depth = renderedImageArray.length;
    }

    public ImageTextureComponent3D(int n, RenderedImage[] renderedImageArray, boolean bl) {
        this(n, renderedImageArray);
        this.invertY = !bl;
    }

    public void updateSubImage(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, RenderedImage renderedImage) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (renderedImage instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)renderedImage;
            this.convertForSubImage(bufferedImage, n, n2, n6, n7, 1, 0);
            this.sendTextureUpdate(n3, n4, n5, n6, n7, 1, n8, this.copyBuffer);
        }
    }

    public void updateSubImage(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, RenderedImage[] renderedImageArray) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        int n10 = 0;
        for (int i = 0; i < n8; ++i) {
            if (!(renderedImageArray[i] instanceof BufferedImage)) continue;
            BufferedImage bufferedImage = (BufferedImage)renderedImageArray[i];
            n10 = this.convertForSubImage(bufferedImage, n, n2, n6, n7, n8, n10);
        }
        this.sendTextureUpdate(n3, n4, n5, n6, n7, n8, n9, this.copyBuffer);
    }

    public void clearLocalData() {
        int n = this.images.length;
        for (int i = 0; i < n; ++i) {
            if (this.data[i] == null) {
                this.data[i] = this.convertImage(i);
            }
            if (!(this.images[i] instanceof BufferedImage)) continue;
            ((BufferedImage)this.images[i]).flush();
        }
        this.images = null;
    }

    private void checkFormats() throws IllegalArgumentException {
        if (this.images == null || this.images.length == 0) {
            return;
        }
        int n = ((BufferedImage)this.images[0]).getType();
        for (int i = 1; i < this.images.length; ++i) {
            if (n == ((BufferedImage)this.images[i]).getType()) continue;
            throw new IllegalArgumentException(MATCH_FORMAT_MSG);
        }
    }

    protected ByteBuffer convertImage(int n) {
        return this.convertImage(this.images);
    }

    private ByteBuffer convertImage(RenderedImage[] renderedImageArray) {
        Object object;
        if (!(renderedImageArray[0] instanceof BufferedImage)) {
            return null;
        }
        ByteBuffer byteBuffer = null;
        int n = 0;
        boolean bl = false;
        BufferedImage bufferedImage = (BufferedImage)renderedImageArray[0];
        switch (bufferedImage.getType()) {
            case 1: 
            case 5: 
            case 8: 
            case 9: {
                n = 3;
                break;
            }
            case 2: 
            case 6: {
                n = 4;
                bl = true;
                break;
            }
            case 12: 
            case 13: {
                object = bufferedImage.getColorModel();
                n = ((ColorModel)object).getNumComponents();
                if (n != 4) break;
                bl = true;
                break;
            }
            case 10: {
                n = 1;
                break;
            }
            case 11: {
                System.out.println("ImageTextureComponent3D Short gray Image conversion not implemented yet");
                break;
            }
            default: {
                System.out.println("ImageTextureComponent3D Unsupported image type " + bufferedImage.getType());
            }
        }
        byteBuffer = ByteBuffer.allocateDirect(this.width * this.height * this.depth * n);
        byteBuffer.order(ByteOrder.nativeOrder());
        if (bl) {
            object = byteBuffer.asIntBuffer();
            for (int i = 0; i < renderedImageArray.length; ++i) {
                this.convertImage((IntBuffer)object, (BufferedImage)renderedImageArray[i]);
            }
        } else {
            for (int i = 0; i < renderedImageArray.length; ++i) {
                this.convertImage(byteBuffer, (BufferedImage)renderedImageArray[i]);
            }
        }
        return byteBuffer;
    }

    private void convertImage(ByteBuffer byteBuffer, BufferedImage bufferedImage) {
        int n = bufferedImage.getHeight(null);
        int n2 = bufferedImage.getWidth(null);
        ColorModel colorModel = bufferedImage.getColorModel();
        if (this.pixelTmp == null || this.pixelTmp.length < n2) {
            this.pixelTmp = new int[n2];
        }
        block0 : switch (bufferedImage.getType()) {
            case 1: 
            case 5: 
            case 8: 
            case 9: {
                this.format = 1;
                if (this.invertY) {
                    int n3 = n - 1;
                    for (int i = 0; i < n; ++i) {
                        bufferedImage.getRGB(0, n3, n2, 1, this.pixelTmp, 0, n2);
                        for (int j = 0; j < n2; ++j) {
                            int n4 = this.pixelTmp[j];
                            byteBuffer.put((byte)(n4 >> 16 & 0xFF));
                            byteBuffer.put((byte)(n4 >> 8 & 0xFF));
                            byteBuffer.put((byte)(n4 & 0xFF));
                        }
                        --n3;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        bufferedImage.getRGB(0, i, n2, 1, this.pixelTmp, 0, n2);
                        for (int j = 0; j < n2; ++j) {
                            int n5 = this.pixelTmp[j];
                            byteBuffer.put((byte)(n5 >> 16 & 0xFF));
                            byteBuffer.put((byte)(n5 >> 8 & 0xFF));
                            byteBuffer.put((byte)(n5 & 0xFF));
                        }
                    }
                }
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 0: 
            case 12: 
            case 13: {
                int n6 = colorModel.getNumComponents();
                boolean bl = colorModel.hasAlpha();
                switch (n6) {
                    case 1: {
                        if (this.invertY) {
                            int n7 = n - 1;
                            for (int i = 0; i < n; ++i) {
                                bufferedImage.getRGB(0, n7, n2, 1, this.pixelTmp, 0, n2);
                                for (int j = 0; j < n2; ++j) {
                                    int n8 = this.pixelTmp[j];
                                    byteBuffer.put((byte)(n8 & 0xFF));
                                }
                                --n7;
                            }
                        } else {
                            for (int i = 0; i < n; ++i) {
                                bufferedImage.getRGB(0, i, n2, 1, this.pixelTmp, 0, n2);
                                for (int j = 0; j < n2; ++j) {
                                    int n9 = this.pixelTmp[j];
                                    byteBuffer.put((byte)(n9 & 0xFF));
                                }
                            }
                        }
                        break block0;
                    }
                    case 2: {
                        this.format = 5;
                        if (this.invertY) {
                            int n10 = n - 1;
                            for (int i = 0; i < n; ++i) {
                                bufferedImage.getRGB(0, n10, n2, 1, this.pixelTmp, 0, n2);
                                for (int j = 0; j < n2; ++j) {
                                    int n11 = this.pixelTmp[j];
                                    byteBuffer.put((byte)(n11 >> 8 & 0xFF));
                                    byteBuffer.put((byte)(n11 & 0xFF));
                                }
                                --n10;
                            }
                        } else {
                            for (int i = 0; i < n; ++i) {
                                bufferedImage.getRGB(0, i, n2, 1, this.pixelTmp, 0, n2);
                                for (int j = 0; j < n2; ++j) {
                                    int n12 = this.pixelTmp[j];
                                    byteBuffer.put((byte)(n12 >> 8 & 0xFF));
                                    byteBuffer.put((byte)(n12 & 0xFF));
                                }
                            }
                        }
                        break block0;
                    }
                    case 3: {
                        this.format = 1;
                        if (this.invertY) {
                            int n13 = n - 1;
                            for (int i = 0; i < n; ++i) {
                                bufferedImage.getRGB(0, n13, n2, 1, this.pixelTmp, 0, n2);
                                for (int j = 0; j < n2; ++j) {
                                    int n14 = this.pixelTmp[j];
                                    byteBuffer.put((byte)(n14 >> 16 & 0xFF));
                                    byteBuffer.put((byte)(n14 >> 8 & 0xFF));
                                    byteBuffer.put((byte)(n14 & 0xFF));
                                }
                                --n13;
                            }
                        } else {
                            for (int i = 0; i < n; ++i) {
                                bufferedImage.getRGB(0, i, n2, 1, this.pixelTmp, 0, n2);
                                for (int j = 0; j < n2; ++j) {
                                    int n15 = this.pixelTmp[j];
                                    byteBuffer.put((byte)(n15 >> 16 & 0xFF));
                                    byteBuffer.put((byte)(n15 >> 8 & 0xFF));
                                    byteBuffer.put((byte)(n15 & 0xFF));
                                }
                            }
                        }
                        break block0;
                    }
                }
                break;
            }
            case 10: {
                if (this.invertY) {
                    int n16 = n - 1;
                    for (int i = 0; i < n; ++i) {
                        bufferedImage.getRGB(0, n16, n2, 1, this.pixelTmp, 0, n2);
                        for (int j = 0; j < n2; ++j) {
                            int n17 = this.pixelTmp[j];
                            byteBuffer.put((byte)(n17 & 0xFF));
                        }
                        --n16;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        bufferedImage.getRGB(0, i, n2, 1, this.pixelTmp, 0, n2);
                        for (int j = 0; j < n2; ++j) {
                            int n18 = this.pixelTmp[j];
                            byteBuffer.put((byte)(n18 & 0xFF));
                        }
                    }
                }
                break;
            }
            case 11: {
                System.out.println("ImageTextureComponent3D Short gray Image conversion not implemented yet");
                break;
            }
            default: {
                System.out.println("ImageTextureComponent3D Unsupported image type " + bufferedImage.getType());
            }
        }
        byteBuffer.rewind();
    }

    private void convertImage(IntBuffer intBuffer, BufferedImage bufferedImage) {
        int n = bufferedImage.getHeight(null);
        int n2 = bufferedImage.getWidth(null);
        ColorModel colorModel = bufferedImage.getColorModel();
        if (this.pixelTmp == null || this.pixelTmp.length < n2) {
            this.pixelTmp = new int[n2];
        }
        switch (bufferedImage.getType()) {
            case 1: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 2: 
            case 6: {
                this.format = 2;
                if (this.invertY) {
                    int n3 = n - 1;
                    for (int i = 0; i < n; ++i) {
                        bufferedImage.getRGB(0, n3, n2, 1, this.pixelTmp, 0, n2);
                        for (int j = 0; j < n2; ++j) {
                            int n4 = this.pixelTmp[j] >> 24 & 0xFF;
                            int n5 = this.pixelTmp[j] << 8;
                            intBuffer.put(n5 | n4);
                        }
                        --n3;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        bufferedImage.getRGB(0, i, n2, 1, this.pixelTmp, 0, n2);
                        for (int j = 0; j < n2; ++j) {
                            int n6 = this.pixelTmp[j] >> 24 & 0xFF;
                            int n7 = this.pixelTmp[j] << 8;
                            intBuffer.put(n7 | n6);
                        }
                    }
                }
                break;
            }
            case 0: 
            case 12: 
            case 13: {
                this.format = 2;
                if (this.invertY) {
                    int n8 = n - 1;
                    for (int i = 0; i < n; ++i) {
                        bufferedImage.getRGB(0, n8, n2, 1, this.pixelTmp, 0, n2);
                        for (int j = 0; j < n2; ++j) {
                            int n9 = this.pixelTmp[j] >> 24 & 0xFF;
                            int n10 = this.pixelTmp[j] << 8;
                            intBuffer.put(n10 | n9);
                        }
                        --n8;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        bufferedImage.getRGB(i, 0, n2, 1, this.pixelTmp, 0, n2);
                        for (int j = 0; j < n2; ++j) {
                            int n11 = this.pixelTmp[j] >> 24 & 0xFF;
                            int n12 = this.pixelTmp[j] << 8;
                            intBuffer.put(n12 | n11);
                        }
                    }
                }
                break;
            }
            case 10: {
                System.out.println("ImageTextureComponent3D Grayscale Image conversion not implemented yet");
                break;
            }
            case 11: {
                System.out.println("ImageTextureComponent3D Short gray Image conversion not implemented yet");
                break;
            }
            default: {
                System.out.println("Unsupported image type " + bufferedImage.getType());
            }
        }
    }

    private int convertForSubImage(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = bufferedImage.getHeight(null);
        ColorModel colorModel = bufferedImage.getColorModel();
        int n8 = n6;
        if (this.pixelTmp == null || this.pixelTmp.length < n3) {
            this.pixelTmp = new int[n3];
        }
        block0 : switch (bufferedImage.getType()) {
            case 1: 
            case 5: 
            case 8: 
            case 9: {
                this.format = 1;
                if (n6 == 0) {
                    this.checkCopyBufferSize(n3 * n4 * n5 * 3);
                }
                if (this.invertY) {
                    int n9 = n7 - 1 - n2;
                    for (int i = 0; i < n4; ++i) {
                        bufferedImage.getRGB(n, n9, n3, 1, this.pixelTmp, 0, n3);
                        for (int j = 0; j < n3; ++j) {
                            int n10 = this.pixelTmp[j];
                            this.copyBuffer[n8++] = (byte)(n10 >> 16 & 0xFF);
                            this.copyBuffer[n8++] = (byte)(n10 >> 8 & 0xFF);
                            this.copyBuffer[n8++] = (byte)(n10 & 0xFF);
                        }
                        --n9;
                    }
                } else {
                    for (int i = n2; i < n2 + n4; ++i) {
                        bufferedImage.getRGB(n, i, n3, 1, this.pixelTmp, 0, n3);
                        for (int j = 0; j < n3; ++j) {
                            int n11 = this.pixelTmp[j];
                            this.copyBuffer[n8++] = (byte)(n11 >> 16 & 0xFF);
                            this.copyBuffer[n8++] = (byte)(n11 >> 8 & 0xFF);
                            this.copyBuffer[n8++] = (byte)(n11 & 0xFF);
                        }
                    }
                }
                break;
            }
            case 2: 
            case 6: {
                this.format = 2;
                if (n6 == 0) {
                    this.checkCopyBufferSize(n3 * n4 * n5 * 4);
                }
                if (this.invertY) {
                    int n12 = n7 - 1 - n2;
                    for (int i = 0; i < n4; ++i) {
                        bufferedImage.getRGB(n, n12, n3, 1, this.pixelTmp, 0, n3);
                        for (int j = 0; j < n3; ++j) {
                            int n13 = this.pixelTmp[j];
                            this.copyBuffer[n8++] = (byte)(n13 >> 16 & 0xFF);
                            this.copyBuffer[n8++] = (byte)(n13 >> 8 & 0xFF);
                            this.copyBuffer[n8++] = (byte)(n13 & 0xFF);
                            this.copyBuffer[n8++] = (byte)(n13 >> 24 & 0xFF);
                        }
                        --n12;
                    }
                } else {
                    for (int i = n2; i < n2 + n4; ++i) {
                        bufferedImage.getRGB(n, i, n3, 1, this.pixelTmp, 0, n3);
                        for (int j = 0; j < n3; ++j) {
                            int n14 = this.pixelTmp[j];
                            this.copyBuffer[n8++] = (byte)(n14 >> 16 & 0xFF);
                            this.copyBuffer[n8++] = (byte)(n14 >> 8 & 0xFF);
                            this.copyBuffer[n8++] = (byte)(n14 & 0xFF);
                            this.copyBuffer[n8++] = (byte)(n14 >> 24 & 0xFF);
                        }
                    }
                }
                break;
            }
            case 0: 
            case 12: 
            case 13: {
                int n15 = colorModel.getNumComponents();
                boolean bl = colorModel.hasAlpha();
                switch (n15) {
                    case 1: {
                        if (n6 == 0) {
                            this.checkCopyBufferSize(n3 * n4 * n5);
                        }
                        if (this.invertY) {
                            int n16 = n7 - 1 - n2;
                            for (int i = 0; i < n4; ++i) {
                                bufferedImage.getRGB(n, n16, n3, 1, this.pixelTmp, 0, n3);
                                for (int j = 0; j < n3; ++j) {
                                    int n17 = this.pixelTmp[j];
                                    this.copyBuffer[n8++] = (byte)(n17 & 0xFF);
                                }
                                --n16;
                            }
                        } else {
                            for (int i = n2; i < n2 + n4; ++i) {
                                bufferedImage.getRGB(n, i, n3, 1, this.pixelTmp, 0, n3);
                                for (int j = 0; j < n3; ++j) {
                                    int n18 = this.pixelTmp[j];
                                    this.copyBuffer[n8++] = (byte)(n18 & 0xFF);
                                }
                            }
                        }
                        break block0;
                    }
                    case 2: {
                        this.format = 5;
                        if (n6 == 0) {
                            this.checkCopyBufferSize(n3 * n4 * n5 * 2);
                        }
                        if (this.invertY) {
                            int n19 = n7 - 1 - n2;
                            for (int i = 0; i < n4; ++i) {
                                bufferedImage.getRGB(n, n19, n3, 1, this.pixelTmp, 0, n3);
                                for (int j = 0; j < n3; ++j) {
                                    int n20 = this.pixelTmp[j];
                                    this.copyBuffer[n8++] = (byte)(n20 >> 8 & 0xFF);
                                    this.copyBuffer[n8++] = (byte)(n20 & 0xFF);
                                }
                                --n19;
                            }
                        } else {
                            for (int i = n2; i < n2 + n4; ++i) {
                                bufferedImage.getRGB(n, i, n3, 1, this.pixelTmp, 0, n3);
                                for (int j = 0; j < n3; ++j) {
                                    int n21 = this.pixelTmp[j];
                                    this.copyBuffer[n8++] = (byte)(n21 >> 8 & 0xFF);
                                    this.copyBuffer[n8++] = (byte)(n21 & 0xFF);
                                }
                            }
                        }
                        break block0;
                    }
                    case 3: {
                        this.format = 1;
                        if (n6 == 0) {
                            this.checkCopyBufferSize(n3 * n4 * n5 * 3);
                        }
                        if (this.invertY) {
                            int n22 = n7 - 1 - n2;
                            for (int i = 0; i < n4; ++i) {
                                bufferedImage.getRGB(n, n22, n3, 1, this.pixelTmp, 0, n3);
                                for (int j = 0; j < n3; ++j) {
                                    int n23 = this.pixelTmp[j];
                                    byte by = (byte)(n23 >> 16 & 0xFF);
                                    byte by2 = (byte)(n23 >> 8 & 0xFF);
                                    byte by3 = (byte)(n23 & 0xFF);
                                    this.copyBuffer[n8++] = by;
                                    this.copyBuffer[n8++] = by2;
                                    this.copyBuffer[n8++] = by3;
                                }
                                --n22;
                            }
                        } else {
                            for (int i = n2; i < n2 + n4; ++i) {
                                bufferedImage.getRGB(n, i, n3, 1, this.pixelTmp, 0, n3);
                                for (int j = 0; j < n3; ++j) {
                                    int n24 = this.pixelTmp[j];
                                    this.copyBuffer[n8++] = (byte)(n24 >> 16 & 0xFF);
                                    this.copyBuffer[n8++] = (byte)(n24 >> 8 & 0xFF);
                                    this.copyBuffer[n8++] = (byte)(n24 & 0xFF);
                                }
                            }
                        }
                        break block0;
                    }
                    case 4: {
                        this.format = 2;
                        if (n6 == 0) {
                            this.checkCopyBufferSize(n3 * n4 * n5 * 4);
                        }
                        if (this.invertY) {
                            int n25 = n7 - 1 - n2;
                            for (int i = 0; i < n4; ++i) {
                                bufferedImage.getRGB(n, n25, n3, 1, this.pixelTmp, 0, n3);
                                for (int j = 0; j < n3; ++j) {
                                    int n26 = this.pixelTmp[j];
                                    this.copyBuffer[n8++] = (byte)(n26 >> 16 & 0xFF);
                                    this.copyBuffer[n8++] = (byte)(n26 >> 8 & 0xFF);
                                    this.copyBuffer[n8++] = (byte)(n26 & 0xFF);
                                    this.copyBuffer[n8++] = (byte)(n26 >> 24 & 0xFF);
                                }
                                --n25;
                            }
                            break block0;
                        }
                        for (int i = n2; i < n2 + n4; ++i) {
                            bufferedImage.getRGB(n, i, n3, 1, this.pixelTmp, 0, n3);
                            for (int j = 0; j < n3; ++j) {
                                int n27 = this.pixelTmp[j];
                                this.copyBuffer[n8++] = (byte)(n27 >> 16 & 0xFF);
                                this.copyBuffer[n8++] = (byte)(n27 >> 8 & 0xFF);
                                this.copyBuffer[n8++] = (byte)(n27 & 0xFF);
                                this.copyBuffer[n8++] = (byte)(n27 >> 24 & 0xFF);
                            }
                        }
                    }
                }
                break;
            }
            case 10: {
                if (n6 == 0) {
                    this.checkCopyBufferSize(n3 * n4 * n5);
                }
                if (this.invertY) {
                    int n28 = n7 - 1 - n2;
                    for (int i = 0; i < n4; ++i) {
                        bufferedImage.getRGB(n, n28, n3, 1, this.pixelTmp, 0, n3);
                        for (int j = 0; j < n3; ++j) {
                            int n29 = this.pixelTmp[j];
                            this.copyBuffer[n8++] = (byte)(n29 & 0xFF);
                        }
                        --n28;
                    }
                } else {
                    for (int i = n2; i < n2 + n4; ++i) {
                        bufferedImage.getRGB(n, i, n3, 1, this.pixelTmp, 0, n3);
                        for (int j = 0; j < n3; ++j) {
                            int n30 = this.pixelTmp[j];
                            this.copyBuffer[n8++] = (byte)(n30 & 0xFF);
                        }
                    }
                }
                break;
            }
            case 11: {
                System.out.println("ImageTextureComponent3D Short gray Image conversion not implemented yet");
                break;
            }
            case 3: {
                System.out.println("ImageTextureComponent3D ARGB-premult Image conversion not implemented yet");
            }
            default: {
                System.out.println("ImageTextureComponent3D Unsupported image type " + bufferedImage.getType());
            }
        }
        return n8;
    }
}

