/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.TextureComponent2D;

public class ImageTextureComponent2D
extends TextureComponent2D {
    private int[] pixelTmp;
    private RenderedImage[] images;

    public ImageTextureComponent2D() {
        this(0, 0, 0, null);
    }

    public ImageTextureComponent2D(boolean bl) {
        this(0, 0, 0, null);
        this.invertY = !bl;
    }

    public ImageTextureComponent2D(int n, int n2, int n3, RenderedImage renderedImage) {
        super(1);
        this.width = n2;
        this.height = n3;
        this.format = n;
        this.images = new RenderedImage[1];
        this.images[0] = renderedImage;
    }

    public ImageTextureComponent2D(int n, int n2, int n3, RenderedImage renderedImage, boolean bl) {
        this(n, n2, n3, renderedImage);
        this.invertY = !bl;
    }

    public ImageTextureComponent2D(int n, RenderedImage renderedImage) {
        super(1);
        this.format = n;
        this.images = new RenderedImage[1];
        this.images[0] = renderedImage;
        if (renderedImage instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)renderedImage;
            this.width = bufferedImage.getWidth(null);
            this.height = bufferedImage.getHeight(null);
        } else {
            System.out.println("Can't handle RenderedImage in Image2D");
        }
    }

    public ImageTextureComponent2D(int n, RenderedImage[] renderedImageArray) {
        super(renderedImageArray.length);
        this.format = n;
        this.images = new RenderedImage[this.numLevels];
        for (int i = 0; i < this.numLevels; ++i) {
            this.images[i] = renderedImageArray[i];
        }
        if (renderedImageArray[0] instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)renderedImageArray[0];
            this.width = bufferedImage.getWidth(null);
            this.height = bufferedImage.getHeight(null);
        } else {
            System.out.println("Can't handle RenderedImage in Image2D");
        }
    }

    public ImageTextureComponent2D(int n, RenderedImage renderedImage, boolean bl) {
        this(n, renderedImage);
        this.invertY = !bl;
    }

    public ImageTextureComponent2D(int n, RenderedImage[] renderedImageArray, boolean bl) {
        this(n, renderedImageArray);
        this.invertY = !bl;
    }

    public void updateSubImage(int n, int n2, int n3, int n4, int n5, int n6, int n7, RenderedImage renderedImage) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (renderedImage instanceof BufferedImage) {
            this.convertForSubImage((BufferedImage)renderedImage, n, n2, n5, n6);
        }
        this.sendTextureUpdate(n3, n4, 0, n5, n6, 1, n7, this.copyBuffer);
    }

    public void clearLocalData() {
        int n = this.images.length;
        for (int i = 0; i < n; ++i) {
            if (this.data[i] == null) {
                this.data[i] = this.convertImage(i);
            }
            if (!(this.images[i] instanceof BufferedImage)) continue;
            ((BufferedImage)this.images[i]).flush();
        }
        this.images = null;
    }

    protected ByteBuffer convertImage(int n) {
        return this.convertImage((BufferedImage)this.images[n]);
    }

    private ByteBuffer convertImage(BufferedImage bufferedImage) {
        ByteBuffer byteBuffer = null;
        int n = bufferedImage.getHeight(null);
        int n2 = bufferedImage.getWidth(null);
        ColorModel colorModel = bufferedImage.getColorModel();
        if (this.pixelTmp == null || this.pixelTmp.length < n2) {
            this.pixelTmp = new int[n2];
        }
        block0 : switch (bufferedImage.getType()) {
            case 1: 
            case 5: 
            case 8: 
            case 9: {
                this.format = 1;
                byteBuffer = ByteBuffer.allocateDirect(n2 * n * 3);
                byteBuffer.order(ByteOrder.nativeOrder());
                if (this.invertY) {
                    int n3 = n - 1;
                    for (int i = 0; i < n; ++i) {
                        bufferedImage.getRGB(0, n3, n2, 1, this.pixelTmp, 0, n2);
                        for (int j = 0; j < n2; ++j) {
                            int n4 = this.pixelTmp[j];
                            byteBuffer.put((byte)(n4 >> 16 & 0xFF));
                            byteBuffer.put((byte)(n4 >> 8 & 0xFF));
                            byteBuffer.put((byte)(n4 & 0xFF));
                        }
                        --n3;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        bufferedImage.getRGB(0, i, n2, 1, this.pixelTmp, 0, n2);
                        for (int j = 0; j < n2; ++j) {
                            int n5 = this.pixelTmp[j];
                            byteBuffer.put((byte)(n5 >> 16 & 0xFF));
                            byteBuffer.put((byte)(n5 >> 8 & 0xFF));
                            byteBuffer.put((byte)(n5 & 0xFF));
                        }
                    }
                }
                break;
            }
            case 2: 
            case 6: {
                this.format = 2;
                byteBuffer = ByteBuffer.allocateDirect(n2 * n * 4);
                byteBuffer.order(ByteOrder.nativeOrder());
                if (this.invertY) {
                    int n6 = n - 1;
                    for (int i = 0; i < n; ++i) {
                        bufferedImage.getRGB(0, n6, n2, 1, this.pixelTmp, 0, n2);
                        for (int j = 0; j < n2; ++j) {
                            int n7 = this.pixelTmp[j];
                            byteBuffer.put((byte)(n7 >> 16 & 0xFF));
                            byteBuffer.put((byte)(n7 >> 8 & 0xFF));
                            byteBuffer.put((byte)(n7 & 0xFF));
                            byteBuffer.put((byte)(n7 >> 24 & 0xFF));
                        }
                        --n6;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        bufferedImage.getRGB(0, i, n2, 1, this.pixelTmp, 0, n2);
                        for (int j = 0; j < n2; ++j) {
                            int n8 = this.pixelTmp[j];
                            byteBuffer.put((byte)(n8 >> 16 & 0xFF));
                            byteBuffer.put((byte)(n8 >> 8 & 0xFF));
                            byteBuffer.put((byte)(n8 & 0xFF));
                            byteBuffer.put((byte)(n8 >> 24 & 0xFF));
                        }
                    }
                }
                break;
            }
            case 0: 
            case 12: 
            case 13: {
                int n9 = colorModel.getNumComponents();
                boolean bl = colorModel.hasAlpha();
                switch (n9) {
                    case 1: {
                        byteBuffer = ByteBuffer.allocateDirect(n2 * n);
                        byteBuffer.order(ByteOrder.nativeOrder());
                        if (this.invertY) {
                            int n10 = n - 1;
                            for (int i = 0; i < n; ++i) {
                                bufferedImage.getRGB(0, n10, n2, 1, this.pixelTmp, 0, n2);
                                for (int j = 0; j < n2; ++j) {
                                    int n11 = this.pixelTmp[j];
                                    byteBuffer.put((byte)(n11 & 0xFF));
                                }
                                --n10;
                            }
                        } else {
                            for (int i = 0; i < n; ++i) {
                                bufferedImage.getRGB(0, i, n2, 1, this.pixelTmp, 0, n2);
                                for (int j = 0; j < n2; ++j) {
                                    int n12 = this.pixelTmp[j];
                                    byteBuffer.put((byte)(n12 & 0xFF));
                                }
                            }
                        }
                        break block0;
                    }
                    case 2: {
                        this.format = 5;
                        byteBuffer = ByteBuffer.allocateDirect(n2 * n * 2);
                        byteBuffer.order(ByteOrder.nativeOrder());
                        if (this.invertY) {
                            int n13 = n - 1;
                            for (int i = 0; i < n; ++i) {
                                bufferedImage.getRGB(0, n13, n2, 1, this.pixelTmp, 0, n2);
                                for (int j = 0; j < n2; ++j) {
                                    int n14 = this.pixelTmp[j];
                                    byteBuffer.put((byte)(n14 >> 8 & 0xFF));
                                    byteBuffer.put((byte)(n14 & 0xFF));
                                }
                                --n13;
                            }
                        } else {
                            for (int i = 0; i < n; ++i) {
                                bufferedImage.getRGB(0, i, n2, 1, this.pixelTmp, 0, n2);
                                for (int j = 0; j < n2; ++j) {
                                    int n15 = this.pixelTmp[j];
                                    byteBuffer.put((byte)(n15 >> 8 & 0xFF));
                                    byteBuffer.put((byte)(n15 & 0xFF));
                                }
                            }
                        }
                        break block0;
                    }
                    case 3: {
                        this.format = 1;
                        byteBuffer = ByteBuffer.allocateDirect(n2 * n * 3);
                        byteBuffer.order(ByteOrder.nativeOrder());
                        if (this.invertY) {
                            int n16 = n - 1;
                            for (int i = 0; i < n; ++i) {
                                bufferedImage.getRGB(0, n16, n2, 1, this.pixelTmp, 0, n2);
                                for (int j = 0; j < n2; ++j) {
                                    int n17 = this.pixelTmp[j];
                                    byte by = (byte)(n17 >> 16 & 0xFF);
                                    byte by2 = (byte)(n17 >> 8 & 0xFF);
                                    byte by3 = (byte)(n17 & 0xFF);
                                    byteBuffer.put(by);
                                    byteBuffer.put(by2);
                                    byteBuffer.put(by3);
                                }
                                --n16;
                            }
                        } else {
                            for (int i = 0; i < n; ++i) {
                                bufferedImage.getRGB(0, i, n2, 1, this.pixelTmp, 0, n2);
                                for (int j = 0; j < n2; ++j) {
                                    int n18 = this.pixelTmp[j];
                                    byteBuffer.put((byte)(n18 >> 16 & 0xFF));
                                    byteBuffer.put((byte)(n18 >> 8 & 0xFF));
                                    byteBuffer.put((byte)(n18 & 0xFF));
                                }
                            }
                        }
                        break block0;
                    }
                    case 4: {
                        this.format = 2;
                        byteBuffer = ByteBuffer.allocateDirect(n2 * n * 4);
                        byteBuffer.order(ByteOrder.nativeOrder());
                        if (this.invertY) {
                            int n19 = n - 1;
                            for (int i = 0; i < n; ++i) {
                                bufferedImage.getRGB(0, n19, n2, 1, this.pixelTmp, 0, n2);
                                for (int j = 0; j < n2; ++j) {
                                    int n20 = this.pixelTmp[j];
                                    byteBuffer.put((byte)(n20 >> 16 & 0xFF));
                                    byteBuffer.put((byte)(n20 >> 8 & 0xFF));
                                    byteBuffer.put((byte)(n20 & 0xFF));
                                    byteBuffer.put((byte)(n20 >> 24 & 0xFF));
                                }
                                --n19;
                            }
                            break block0;
                        }
                        for (int i = 0; i < n; ++i) {
                            bufferedImage.getRGB(0, i, n2, 1, this.pixelTmp, 0, n2);
                            for (int j = 0; j < n2; ++j) {
                                int n21 = this.pixelTmp[j];
                                byteBuffer.put((byte)(n21 >> 16 & 0xFF));
                                byteBuffer.put((byte)(n21 >> 8 & 0xFF));
                                byteBuffer.put((byte)(n21 & 0xFF));
                                byteBuffer.put((byte)(n21 >> 24 & 0xFF));
                            }
                        }
                    }
                }
                break;
            }
            case 10: {
                Raster raster = bufferedImage.getData();
                DataBuffer dataBuffer = raster.getDataBuffer();
                if (dataBuffer instanceof DataBufferByte) {
                    byte[] byArray = ((DataBufferByte)dataBuffer).getData();
                    byteBuffer = ByteBuffer.allocateDirect(n2 * n);
                    byteBuffer.order(ByteOrder.nativeOrder());
                    if (this.invertY) {
                        int n22 = n - 1;
                        for (int i = 0; i < n; ++i) {
                            for (int j = 0; j < n2; ++j) {
                                byteBuffer.put(byArray[n22 * n2 + j]);
                            }
                            --n22;
                        }
                    } else {
                        byteBuffer.put(byArray);
                    }
                    return byteBuffer;
                }
                byteBuffer = ByteBuffer.allocateDirect(n2 * n);
                byteBuffer.order(ByteOrder.nativeOrder());
                if (this.invertY) {
                    int n23 = n - 1;
                    for (int i = 0; i < n; ++i) {
                        bufferedImage.getRGB(0, n23, n2, 1, this.pixelTmp, 0, n2);
                        for (int j = 0; j < n2; ++j) {
                            int n24 = this.pixelTmp[j];
                            byteBuffer.put((byte)(n24 & 0xFF));
                        }
                        --n23;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        bufferedImage.getRGB(0, i, n2, 1, this.pixelTmp, 0, n2);
                        for (int j = 0; j < n2; ++j) {
                            int n25 = this.pixelTmp[j];
                            byteBuffer.put((byte)(n25 & 0xFF));
                        }
                    }
                }
                break;
            }
            case 11: {
                System.out.println("ImageTextureComponent2D Short gray Image conversion not implemented yet");
                break;
            }
            case 3: {
                System.out.println("ImageTextureComponent2D ARGB-premult Image conversion not implemented yet");
            }
            default: {
                System.out.println("ImageTextureComponent2D Unsupported image type " + bufferedImage.getType());
            }
        }
        byteBuffer.rewind();
        return byteBuffer;
    }

    private void convertForSubImage(BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
        int n5 = bufferedImage.getHeight(null);
        ColorModel colorModel = bufferedImage.getColorModel();
        int n6 = 0;
        if (this.pixelTmp == null || this.pixelTmp.length < n3) {
            this.pixelTmp = new int[n3];
        }
        block0 : switch (bufferedImage.getType()) {
            case 1: 
            case 5: 
            case 8: 
            case 9: {
                this.format = 1;
                this.checkCopyBufferSize(n3 * n4 * 3);
                if (this.invertY) {
                    int n7 = n5 - 1 - n2;
                    for (int i = 0; i < n4; ++i) {
                        bufferedImage.getRGB(n, n7, n3, 1, this.pixelTmp, 0, n3);
                        for (int j = 0; j < n3; ++j) {
                            int n8 = this.pixelTmp[j];
                            this.copyBuffer[n6++] = (byte)(n8 >> 16 & 0xFF);
                            this.copyBuffer[n6++] = (byte)(n8 >> 8 & 0xFF);
                            this.copyBuffer[n6++] = (byte)(n8 & 0xFF);
                        }
                        --n7;
                    }
                } else {
                    for (int i = n2; i < n2 + n4; ++i) {
                        bufferedImage.getRGB(n, i, n3, 1, this.pixelTmp, 0, n3);
                        for (int j = 0; j < n3; ++j) {
                            int n9 = this.pixelTmp[j];
                            this.copyBuffer[n6++] = (byte)(n9 >> 16 & 0xFF);
                            this.copyBuffer[n6++] = (byte)(n9 >> 8 & 0xFF);
                            this.copyBuffer[n6++] = (byte)(n9 & 0xFF);
                        }
                    }
                }
                break;
            }
            case 2: 
            case 6: {
                this.format = 2;
                this.checkCopyBufferSize(n3 * n4 * 4);
                if (this.invertY) {
                    int n10 = n5 - 1 - n2;
                    for (int i = 0; i < n4; ++i) {
                        bufferedImage.getRGB(n, n10, n3, 1, this.pixelTmp, 0, n3);
                        for (int j = 0; j < n3; ++j) {
                            int n11 = this.pixelTmp[j];
                            this.copyBuffer[n6++] = (byte)(n11 >> 16 & 0xFF);
                            this.copyBuffer[n6++] = (byte)(n11 >> 8 & 0xFF);
                            this.copyBuffer[n6++] = (byte)(n11 & 0xFF);
                            this.copyBuffer[n6++] = (byte)(n11 >> 24 & 0xFF);
                        }
                        --n10;
                    }
                } else {
                    for (int i = n2; i < n2 + n4; ++i) {
                        bufferedImage.getRGB(n, i, n3, 1, this.pixelTmp, 0, n3);
                        for (int j = 0; j < n3; ++j) {
                            int n12 = this.pixelTmp[j];
                            this.copyBuffer[n6++] = (byte)(n12 >> 16 & 0xFF);
                            this.copyBuffer[n6++] = (byte)(n12 >> 8 & 0xFF);
                            this.copyBuffer[n6++] = (byte)(n12 & 0xFF);
                            this.copyBuffer[n6++] = (byte)(n12 >> 24 & 0xFF);
                        }
                    }
                }
                break;
            }
            case 0: 
            case 12: 
            case 13: {
                int n13 = colorModel.getNumComponents();
                boolean bl = colorModel.hasAlpha();
                switch (n13) {
                    case 1: {
                        this.checkCopyBufferSize(n3 * n4);
                        if (this.invertY) {
                            int n14 = n5 - 1 - n2;
                            for (int i = 0; i < n4; ++i) {
                                bufferedImage.getRGB(n, n14, n3, 1, this.pixelTmp, 0, n3);
                                for (int j = 0; j < n3; ++j) {
                                    int n15 = this.pixelTmp[j];
                                    this.copyBuffer[n6++] = (byte)(n15 & 0xFF);
                                }
                                --n14;
                            }
                        } else {
                            for (int i = n2; i < n2 + n4; ++i) {
                                bufferedImage.getRGB(n, i, n3, 1, this.pixelTmp, 0, n3);
                                for (int j = 0; j < n3; ++j) {
                                    int n16 = this.pixelTmp[j];
                                    this.copyBuffer[n6++] = (byte)(n16 & 0xFF);
                                }
                            }
                        }
                        break block0;
                    }
                    case 2: {
                        this.format = 5;
                        this.checkCopyBufferSize(n3 * n4 * 2);
                        if (this.invertY) {
                            int n17 = n5 - 1 - n2;
                            for (int i = 0; i < n4; ++i) {
                                bufferedImage.getRGB(n, n17, n3, 1, this.pixelTmp, 0, n3);
                                for (int j = 0; j < n3; ++j) {
                                    int n18 = this.pixelTmp[j];
                                    this.copyBuffer[n6++] = (byte)(n18 >> 8 & 0xFF);
                                    this.copyBuffer[n6++] = (byte)(n18 & 0xFF);
                                }
                                --n17;
                            }
                        } else {
                            for (int i = n2; i < n2 + n4; ++i) {
                                bufferedImage.getRGB(n, i, n3, 1, this.pixelTmp, 0, n3);
                                for (int j = 0; j < n3; ++j) {
                                    int n19 = this.pixelTmp[j];
                                    this.copyBuffer[n6++] = (byte)(n19 >> 8 & 0xFF);
                                    this.copyBuffer[n6++] = (byte)(n19 & 0xFF);
                                }
                            }
                        }
                        break block0;
                    }
                    case 3: {
                        this.format = 1;
                        this.checkCopyBufferSize(n3 * n4 * 3);
                        if (this.invertY) {
                            int n20 = n5 - 1 - n2;
                            for (int i = 0; i < n4; ++i) {
                                bufferedImage.getRGB(n, n20, n3, 1, this.pixelTmp, 0, n3);
                                for (int j = 0; j < n3; ++j) {
                                    int n21 = this.pixelTmp[j];
                                    byte by = (byte)(n21 >> 16 & 0xFF);
                                    byte by2 = (byte)(n21 >> 8 & 0xFF);
                                    byte by3 = (byte)(n21 & 0xFF);
                                    this.copyBuffer[n6++] = by;
                                    this.copyBuffer[n6++] = by2;
                                    this.copyBuffer[n6++] = by3;
                                }
                                --n20;
                            }
                        } else {
                            for (int i = n2; i < n2 + n4; ++i) {
                                bufferedImage.getRGB(n, i, n3, 1, this.pixelTmp, 0, n3);
                                for (int j = 0; j < n3; ++j) {
                                    int n22 = this.pixelTmp[j];
                                    this.copyBuffer[n6++] = (byte)(n22 >> 16 & 0xFF);
                                    this.copyBuffer[n6++] = (byte)(n22 >> 8 & 0xFF);
                                    this.copyBuffer[n6++] = (byte)(n22 & 0xFF);
                                }
                            }
                        }
                        break block0;
                    }
                    case 4: {
                        this.format = 2;
                        this.checkCopyBufferSize(n3 * n4 * 4);
                        if (this.invertY) {
                            int n23 = n5 - 1 - n2;
                            for (int i = 0; i < n4; ++i) {
                                bufferedImage.getRGB(n, n23, n3, 1, this.pixelTmp, 0, n3);
                                for (int j = 0; j < n3; ++j) {
                                    int n24 = this.pixelTmp[j];
                                    this.copyBuffer[n6++] = (byte)(n24 >> 16 & 0xFF);
                                    this.copyBuffer[n6++] = (byte)(n24 >> 8 & 0xFF);
                                    this.copyBuffer[n6++] = (byte)(n24 & 0xFF);
                                    this.copyBuffer[n6++] = (byte)(n24 >> 24 & 0xFF);
                                }
                                --n23;
                            }
                            break block0;
                        }
                        for (int i = n2; i < n2 + n4; ++i) {
                            bufferedImage.getRGB(n, i, n3, 1, this.pixelTmp, 0, n3);
                            for (int j = 0; j < n3; ++j) {
                                int n25 = this.pixelTmp[j];
                                this.copyBuffer[n6++] = (byte)(n25 >> 16 & 0xFF);
                                this.copyBuffer[n6++] = (byte)(n25 >> 8 & 0xFF);
                                this.copyBuffer[n6++] = (byte)(n25 & 0xFF);
                                this.copyBuffer[n6++] = (byte)(n25 >> 24 & 0xFF);
                            }
                        }
                    }
                }
                break;
            }
            case 10: {
                this.checkCopyBufferSize(n3 * n4);
                if (this.invertY) {
                    int n26 = n5 - 1 - n2;
                    for (int i = 0; i < n4; ++i) {
                        bufferedImage.getRGB(n, n26, n3, 1, this.pixelTmp, 0, n3);
                        for (int j = 0; j < n3; ++j) {
                            int n27 = this.pixelTmp[j];
                            this.copyBuffer[n6++] = (byte)(n27 & 0xFF);
                        }
                        --n26;
                    }
                } else {
                    for (int i = n2; i < n2 + n4; ++i) {
                        bufferedImage.getRGB(n, i, n3, 1, this.pixelTmp, 0, n3);
                        for (int j = 0; j < n3; ++j) {
                            int n28 = this.pixelTmp[j];
                            this.copyBuffer[n6++] = (byte)(n28 & 0xFF);
                        }
                    }
                }
                break;
            }
            case 11: {
                System.out.println("ImageTextureComponent2D Short gray Image conversion not implemented yet");
                break;
            }
            case 3: {
                System.out.println("ImageTextureComponent2D ARGB-premult Image conversion not implemented yet");
            }
            default: {
                System.out.println("ImageTextureComponent2D Unsupported image type " + bufferedImage.getType());
            }
        }
    }
}

