/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Raster;
import org.j3d.aviatrix3d.picking.NotPickableException;

public class ImageRaster
extends Raster {
    public static final int FORMAT_RGB = 1;
    public static final int FORMAT_RGBA = 2;
    public static final int FORMAT_BGR = 3;
    public static final int FORMAT_BGRA = 4;
    public static final int FORMAT_INTENSITY_ALPHA = 5;
    public static final int FORMAT_INTENSITY = 6;
    private static final String NEG_WIDTH_MSG = "Bitmap width provided is less than or equal to zero: ";
    private static final String NEG_HEIGHT_MSG = "Bitmap height provided is less than or equal to zero: ";
    private static final String BIT_ARRAY_SIZE_ERR = "The provided array of bits is too small for the current width and height specified";
    private static final String INVALID_FORMAT_MSG = "An unknown format identifier has been supplied.";
    private ByteBuffer pixelBuffer;
    private int pixelFormat;
    private int bytesPerPixel;
    private int glPixelFormat;
    private byte[] pixels;
    private int pixelWidth;
    private int pixelHeight;

    public ImageRaster(int n, int n2, int n3) {
        if (n <= 0) {
            throw new IllegalArgumentException(NEG_WIDTH_MSG + n);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException(NEG_HEIGHT_MSG + n2);
        }
        int n4 = this.getBytesPerPixel(n3);
        if (n4 == -1) {
            throw new IllegalArgumentException(INVALID_FORMAT_MSG);
        }
        this.glPixelFormat = this.getPixelFormat(n3);
        this.pixelWidth = n;
        this.pixelHeight = n2;
        this.pixelFormat = n3;
        this.bytesPerPixel = n4;
        this.pixelBuffer = ByteBuffer.allocateDirect(n2 * n * this.bytesPerPixel);
    }

    public void render(GL gL) {
        gL.glDrawPixels(this.pixelWidth, this.pixelHeight, this.glPixelFormat, 5121, (Buffer)this.pixelBuffer);
    }

    public boolean pickLineSegment(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        super.pickLineSegment(fArray, fArray2, bl, fArray3, n);
        return false;
    }

    public boolean pickLineRay(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        super.pickLineRay(fArray, fArray2, bl, fArray3, n);
        return false;
    }

    protected void updateBounds() {
        if (this.pixels != null) {
            super.updateBounds();
        }
    }

    protected void recomputeBounds() {
        if (this.pixels != null) {
            return;
        }
        BoundingBox boundingBox = (BoundingBox)this.bounds;
        if (this.bounds == null) {
            boundingBox = new BoundingBox();
            this.bounds = boundingBox;
        }
        boundingBox.setMinimum(0.0f, 0.0f, 0.0f);
        boundingBox.setMaximum(this.pixelWidth, this.pixelHeight, 0.0f);
    }

    protected void setLive(boolean bl) {
        boolean bl2 = this.alive;
        super.setLive(bl);
        if (!bl2 && bl) {
            this.recomputeBounds();
        }
    }

    public int compareTo(Object object) throws ClassCastException {
        ImageRaster imageRaster = (ImageRaster)object;
        return this.compareTo(imageRaster);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ImageRaster)) {
            return false;
        }
        return this.equals((ImageRaster)object);
    }

    public int getHeight() {
        return this.pixelHeight;
    }

    public int getWidth() {
        return this.pixelWidth;
    }

    public void setBits(byte[] byArray) throws InvalidWriteTimingException, IllegalArgumentException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (byArray == null) {
            this.pixelBuffer.clear();
            return;
        }
        if (byArray.length < this.pixelHeight * this.pixelWidth * this.bytesPerPixel) {
            throw new IllegalArgumentException(BIT_ARRAY_SIZE_ERR);
        }
        this.pixelBuffer.put(byArray, 0, this.pixelHeight * this.pixelWidth * this.bytesPerPixel);
        this.pixelBuffer.rewind();
    }

    public void setBits(byte[] byArray, int n, int n2, int n3) throws InvalidWriteTimingException, IllegalArgumentException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException(NEG_WIDTH_MSG + n);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException(NEG_HEIGHT_MSG + n2);
        }
        int n4 = this.getBytesPerPixel(n3);
        if (n4 == -1) {
            throw new IllegalArgumentException(INVALID_FORMAT_MSG);
        }
        if (byArray == null) {
            this.pixelBuffer.clear();
            return;
        }
        this.glPixelFormat = this.getPixelFormat(n3);
        this.pixelWidth = n;
        this.pixelHeight = n2;
        this.pixelFormat = n3;
        this.bytesPerPixel = n4;
        this.pixelBuffer = ByteBuffer.allocateDirect(n * n2 * this.bytesPerPixel);
        this.pixelBuffer.put(byArray, 0, n * n2 * this.bytesPerPixel);
        this.pixelBuffer.rewind();
    }

    public void getBits(byte[] byArray) {
        System.arraycopy(this.pixels, 0, byArray, 0, this.pixelHeight * this.pixelWidth * this.bytesPerPixel);
    }

    public int compareTo(ImageRaster imageRaster) {
        if (imageRaster == null) {
            return 1;
        }
        if (imageRaster == this) {
            return 0;
        }
        return 0;
    }

    public boolean equals(ImageRaster imageRaster) {
        return imageRaster == this;
    }

    private int getBytesPerPixel(int n) {
        int n2 = -1;
        switch (n) {
            case 1: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 4;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 4;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
            case 6: {
                n2 = 1;
            }
        }
        return n2;
    }

    private int getPixelFormat(int n) {
        int n2 = -1;
        switch (n) {
            case 1: {
                n2 = 6407;
                break;
            }
            case 2: {
                n2 = 6408;
                break;
            }
            case 3: {
                n2 = 32992;
                break;
            }
            case 4: {
                n2 = 32993;
                break;
            }
            case 5: {
                n2 = 6410;
                break;
            }
            case 6: {
                n2 = 6409;
            }
        }
        return n2;
    }
}

