/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import org.j3d.aviatrix3d.AlreadyParentedException;
import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.BoundingVoid;
import org.j3d.aviatrix3d.CyclicSceneGraphStructureException;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.TransformHierarchy;
import org.j3d.aviatrix3d.picking.GroupPickTarget;
import org.j3d.aviatrix3d.picking.InvalidPickTimingException;
import org.j3d.aviatrix3d.picking.NotPickableException;
import org.j3d.aviatrix3d.picking.PickRequest;
import org.j3d.aviatrix3d.picking.PickTarget;
import org.j3d.aviatrix3d.picking.PickableObject;
import org.j3d.aviatrix3d.picking.PickingManager;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.j3d.aviatrix3d.rendering.Cullable;
import org.j3d.aviatrix3d.rendering.GroupCullable;

public class Group
extends Node
implements TransformHierarchy,
PickableObject,
GroupPickTarget,
GroupCullable {
    private static final String CHILD_IDX_ERR = "Index provided > last valid index";
    private static final String PICK_TIMING_MSG = "Picking not permitted right now. Picking is only permitted during the update observer callbacks.";
    private static final String PICKABLE_FALSE_MSG = "This node has been marked as not pickable by the user";
    private static final int LIST_START_SIZE = 5;
    private static final int LIST_INCREMENT = 5;
    protected Node[] childList;
    protected int lastChild = 0;
    protected int dirtyBoundsCount = 0;
    protected float[] wkVec1;
    protected float[] wkVec2;
    protected int pickFlags = -1;
    protected PickTarget[] pickableList;
    protected Cullable[] cullList = new Cullable[5];

    public Group() {
        this.childList = new Node[5];
        this.pickableList = new PickTarget[5];
        this.wkVec1 = new float[3];
        this.wkVec2 = new float[3];
    }

    public Cullable[] getCullableChildren() {
        return this.cullList;
    }

    public int numCullableChildren() {
        return this.lastChild;
    }

    public boolean hasMultipleParents() {
        return false;
    }

    public Cullable getCullableParent() {
        return this.parent instanceof Cullable ? (Cullable)((Object)this.parent) : null;
    }

    public void setBounds(BoundingVolume boundingVolume) {
        super.setBounds(boundingVolume);
        this.dirtyBoundsCount = 0;
    }

    protected void markBoundsDirty() {
        if (this.dirtyBoundsCount < this.lastChild) {
            ++this.dirtyBoundsCount;
        }
        if (this.parent != null && this.implicitBounds && this.dirtyBoundsCount == 1) {
            this.parent.markBoundsDirty();
        }
    }

    protected void updateBounds() {
        if (this.dirtyBoundsCount > 1) {
            --this.dirtyBoundsCount;
            return;
        }
        if (!this.implicitBounds) {
            return;
        }
        if (this.lastChild == 0) {
            this.bounds = INVALID_BOUNDS;
        } else {
            this.recomputeBounds();
        }
        this.dirtyBoundsCount = 0;
        if (this.parent != null) {
            this.parent.updateBounds();
        }
    }

    protected void recomputeBounds() {
        int n;
        if (!this.implicitBounds) {
            return;
        }
        if (this.lastChild == 0) {
            this.bounds = INVALID_BOUNDS;
            return;
        }
        BoundingVolume boundingVolume = null;
        for (n = 0; n < this.lastChild && (this.childList[n] == null || (boundingVolume = this.childList[n].getBounds()) instanceof BoundingVoid); ++n) {
        }
        if (n == this.lastChild) {
            this.bounds = INVALID_BOUNDS;
            return;
        }
        boundingVolume.getExtents(this.wkVec1, this.wkVec2);
        float f = this.wkVec1[0];
        float f2 = this.wkVec1[1];
        float f3 = this.wkVec1[2];
        float f4 = this.wkVec2[0];
        float f5 = this.wkVec2[1];
        float f6 = this.wkVec2[2];
        for (int i = n; i < this.lastChild; ++i) {
            if (this.childList[i] == null || (boundingVolume = this.childList[i].getBounds()) instanceof BoundingVoid) continue;
            boundingVolume.getExtents(this.wkVec1, this.wkVec2);
            if (this.wkVec1[0] < f) {
                f = this.wkVec1[0];
            }
            if (this.wkVec1[1] < f2) {
                f2 = this.wkVec1[1];
            }
            if (this.wkVec1[2] < f3) {
                f3 = this.wkVec1[2];
            }
            if (this.wkVec2[0] > f4) {
                f4 = this.wkVec2[0];
            }
            if (this.wkVec2[1] > f5) {
                f5 = this.wkVec2[1];
            }
            if (!(this.wkVec2[2] > f6)) continue;
            f6 = this.wkVec2[2];
        }
        if (this.bounds instanceof BoundingVoid || this.bounds == null) {
            this.bounds = new BoundingBox();
        }
        BoundingBox boundingBox = (BoundingBox)this.bounds;
        boundingBox.setMinimum(f, f2, f3);
        boundingBox.setMaximum(f4, f5, f6);
    }

    public void requestBoundsUpdate() {
        if (this.alive || this.lastChild == 0 || !this.implicitBounds) {
            return;
        }
        for (int i = 0; i < this.lastChild; ++i) {
            this.childList[i].requestBoundsUpdate();
        }
        this.recomputeBounds();
        this.dirtyBoundsCount = 0;
    }

    protected void checkForCyclicChild(SceneGraphObject sceneGraphObject) throws CyclicSceneGraphStructureException {
        if (sceneGraphObject == this) {
            throw new CyclicSceneGraphStructureException();
        }
        for (int i = 0; i < this.lastChild; ++i) {
            if (this.childList[i] == null) continue;
            this.childList[i].checkForCyclicChild(sceneGraphObject);
        }
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        for (int i = 0; i < this.lastChild; ++i) {
            if (this.childList[i] == null) continue;
            this.childList[i].setUpdateHandler(nodeUpdateHandler);
        }
    }

    protected void setLive(boolean bl) {
        for (int i = 0; i < this.lastChild; ++i) {
            if (this.childList[i] == null) continue;
            this.childList[i].setLive(bl);
        }
        super.setLive(bl);
        this.dirtyBoundsCount = 0;
    }

    public void setPickMask(int n) {
        this.pickFlags = n;
    }

    public int getPickMask() {
        return this.pickFlags;
    }

    public void pickBatch(PickRequest[] pickRequestArray, int n) throws NotPickableException, InvalidPickTimingException {
        if (this.updateHandler == null || !this.updateHandler.isPickingPermitted()) {
            throw new InvalidPickTimingException(PICK_TIMING_MSG);
        }
        if (this.pickFlags == 0) {
            throw new NotPickableException(PICKABLE_FALSE_MSG);
        }
        PickingManager pickingManager = this.updateHandler.getPickingManager();
        pickingManager.pickBatch(this, pickRequestArray, n);
    }

    public void pickSingle(PickRequest pickRequest) throws NotPickableException, InvalidPickTimingException {
        if (this.updateHandler == null || !this.updateHandler.isPickingPermitted()) {
            throw new InvalidPickTimingException(PICK_TIMING_MSG);
        }
        if (this.pickFlags == 0) {
            throw new NotPickableException(PICKABLE_FALSE_MSG);
        }
        PickingManager pickingManager = this.updateHandler.getPickingManager();
        pickingManager.pickSingle(this, pickRequest);
    }

    public int numPickableChildren() {
        return this.lastChild + 1;
    }

    public PickTarget[] getPickableChildren() {
        return this.pickableList;
    }

    public PickTarget getPickableChild(int n) {
        return this.pickableList[n];
    }

    public final int getPickTargetType() {
        return 1;
    }

    public boolean checkPickMask(int n) {
        return (this.pickFlags & n) != 0;
    }

    public BoundingVolume getPickableBounds() {
        return this.bounds;
    }

    public void addChild(Node node) throws AlreadyParentedException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.resizeList();
        this.childList[this.lastChild] = node;
        this.pickableList[this.lastChild] = node instanceof PickTarget ? (PickTarget)((Object)node) : null;
        this.cullList[this.lastChild] = node instanceof Cullable ? (Cullable)((Object)node) : null;
        ++this.lastChild;
        if (node != null) {
            node.setParent(this);
            if (node.isLive() != this.alive) {
                node.setLive(this.alive);
            }
            node.setUpdateHandler(this.updateHandler);
        }
    }

    public void setChild(Node node, int n) throws AlreadyParentedException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n > this.lastChild) {
            throw new IndexOutOfBoundsException(CHILD_IDX_ERR);
        }
        if (this.childList[n] != null) {
            this.childList[n].setLive(false);
            this.childList[n].removeParent(this);
        }
        this.childList[n] = node;
        if (node != null) {
            node.setParent(this);
            if (node.isLive() != this.alive) {
                node.setLive(this.alive);
            }
            node.setUpdateHandler(this.updateHandler);
        }
        this.pickableList[n] = node instanceof PickTarget ? (PickTarget)((Object)node) : null;
        this.cullList[n] = node instanceof Cullable ? (Cullable)((Object)node) : null;
    }

    public void removeChild(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n > this.lastChild) {
            throw new IndexOutOfBoundsException(CHILD_IDX_ERR);
        }
        int n2 = this.lastChild - n;
        --this.lastChild;
        Node node = this.childList[n];
        System.arraycopy(this.cullList, n + 1, this.cullList, n, n2);
        System.arraycopy(this.childList, n + 1, this.childList, n, n2);
        System.arraycopy(this.pickableList, n + 1, this.pickableList, n, n2);
        if (node != null) {
            node.removeParent(this);
            node.setLive(false);
        }
    }

    public Node getChild(int n) {
        if (n < 0 || n > this.lastChild) {
            throw new IndexOutOfBoundsException(CHILD_IDX_ERR);
        }
        return this.childList[n];
    }

    public Node[] getAllChildren() {
        return this.childList;
    }

    public int numChildren() {
        return this.lastChild;
    }

    public int indexOfChild(Node node) {
        for (int i = 0; i < this.lastChild; ++i) {
            if (node != this.childList[i]) continue;
            return i;
        }
        return -1;
    }

    public void removeChild(Node node) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        int n = this.indexOfChild(node);
        if (n == -1) {
            return;
        }
        this.removeChild(n);
    }

    public void removeAllChildren() throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        for (int i = 0; i < this.lastChild; ++i) {
            if (this.childList[i] == null) continue;
            this.childList[i].setLive(false);
            this.childList[i].removeParent(this);
            this.childList[i] = null;
            this.pickableList[i] = null;
            this.cullList[i] = null;
        }
        this.lastChild = 0;
    }

    private final void resizeList() {
        if (this.lastChild + 1 == this.childList.length) {
            int n = this.childList.length;
            int n2 = n + 5;
            Node[] nodeArray = new Node[n2];
            PickTarget[] pickTargetArray = new PickTarget[n2];
            Cullable[] cullableArray = new Cullable[n2];
            System.arraycopy(this.cullList, 0, cullableArray, 0, n);
            System.arraycopy(this.childList, 0, nodeArray, 0, n);
            System.arraycopy(this.pickableList, 0, pickTargetArray, 0, n);
            this.cullList = cullableArray;
            this.childList = nodeArray;
            this.pickableList = pickTargetArray;
        }
    }
}

