/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import org.j3d.aviatrix3d.AlreadyParentedException;
import org.j3d.aviatrix3d.BoundingVoid;
import org.j3d.aviatrix3d.InternalNodeUpdateListener;
import org.j3d.aviatrix3d.InvalidListenerSetTimingException;
import org.j3d.aviatrix3d.InvalidNodeTypeException;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeComponent;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.picking.InvalidPickTimingException;
import org.j3d.aviatrix3d.picking.LeafPickTarget;
import org.j3d.aviatrix3d.picking.NotPickableException;
import org.j3d.aviatrix3d.picking.PickRequest;
import org.j3d.aviatrix3d.picking.PickableObject;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.j3d.aviatrix3d.rendering.GeometryRenderable;

public abstract class Geometry
extends NodeComponent
implements PickableObject,
LeafPickTarget,
GeometryRenderable {
    private static final String NULL_PARENT_MSG = "Attempting to set a null parent into a geometry node";
    private static final String PICK_TIMING_MSG = "Picking not permitted right now. Picking is only permitted during the update observer callbacks.";
    private static final String PICKABLE_FALSE_MSG = "This node has been marked as not pickable by the user";
    private static final int LIST_START_SIZE = 5;
    private static final int LIST_INCREMENT = 5;
    protected static final BoundingVoid INVALID_BOUNDS = new BoundingVoid();
    protected Node[] parentList = new Node[5];
    protected int lastParentList = 0;
    protected InternalNodeUpdateListener internalUpdater;
    protected BoundingVolume bounds;
    protected boolean implicitBounds = true;
    protected int pickFlags = -1;
    protected boolean validAlpha = false;

    public boolean hasTransparency() {
        return this.validAlpha;
    }

    public void setPickMask(int n) {
        this.pickFlags = n;
    }

    public int getPickMask() {
        return this.pickFlags;
    }

    public void pickBatch(PickRequest[] pickRequestArray, int n) throws NotPickableException, InvalidPickTimingException {
        if (this.updateHandler == null || !this.updateHandler.isPickingPermitted()) {
            throw new InvalidPickTimingException(PICK_TIMING_MSG);
        }
        if (this.pickFlags == 0) {
            throw new NotPickableException(PICKABLE_FALSE_MSG);
        }
    }

    public void pickSingle(PickRequest pickRequest) throws NotPickableException, InvalidPickTimingException {
        if (this.updateHandler == null || !this.updateHandler.isPickingPermitted()) {
            throw new InvalidPickTimingException(PICK_TIMING_MSG);
        }
        if (this.pickFlags == 0) {
            throw new NotPickableException(PICKABLE_FALSE_MSG);
        }
    }

    public final int getPickTargetType() {
        return 3;
    }

    public boolean pickLineSegment(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        if (this.pickFlags == 0) {
            throw new NotPickableException(PICKABLE_FALSE_MSG);
        }
        return false;
    }

    public boolean pickLineRay(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        if (this.pickFlags == 0) {
            throw new NotPickableException(PICKABLE_FALSE_MSG);
        }
        return false;
    }

    public boolean checkPickMask(int n) {
        return (this.pickFlags & n) != 0;
    }

    public BoundingVolume getPickableBounds() {
        return this.bounds;
    }

    protected void addParent(Node node) throws AlreadyParentedException, InvalidNodeTypeException {
        if (node == null) {
            throw new InvalidNodeTypeException(NULL_PARENT_MSG);
        }
        for (int i = 0; i < this.lastParentList; ++i) {
            if (this.parentList[i] != node) continue;
            return;
        }
        this.resizeList();
        this.parentList[this.lastParentList++] = node;
    }

    protected void removeParent(Node node) {
        for (int i = 0; i < this.lastParentList; ++i) {
            if (this.parentList[i] != node) continue;
            int n = this.lastParentList - i;
            if (n == 0) break;
            System.arraycopy(this.parentList, i, this.parentList, i + 1, n);
            break;
        }
    }

    protected abstract void recomputeBounds();

    public abstract boolean is2D();

    protected void updateBounds() {
        this.recomputeBounds();
        for (int i = 0; i < this.lastParentList; ++i) {
            this.parentList[i].updateBounds();
        }
    }

    protected void markBoundsDirty() {
        for (int i = 0; i < this.lastParentList; ++i) {
            this.parentList[i].markBoundsDirty();
        }
    }

    protected boolean isVisible() {
        return true;
    }

    public void boundsChanged(NodeUpdateListener nodeUpdateListener) throws InvalidListenerSetTimingException {
        if (!this.isLive()) {
            throw new InvalidListenerSetTimingException("Attempting to set a listener to this node when it is not live. Listeners can only be set once the node is live. When it is not live just directly set the values.");
        }
        if (this.updateHandler == null) {
            return;
        }
        if (this.internalUpdater == null) {
            this.internalUpdater = new InternalUpdater();
        }
        if (this.updateHandler.boundsChanged(nodeUpdateListener, this, this.internalUpdater)) {
            for (int i = 0; i < this.lastParentList; ++i) {
                this.parentList[i].markBoundsDirty();
            }
        }
    }

    public void setBounds(BoundingVolume boundingVolume) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.bounds = boundingVolume;
        this.implicitBounds = this.bounds == null;
    }

    public BoundingVolume getBounds() {
        if (this.implicitBounds && this.bounds == null) {
            this.recomputeBounds();
        }
        return this.bounds;
    }

    private final void resizeList() {
        if (this.lastParentList + 1 == this.parentList.length) {
            int n = this.parentList.length;
            int n2 = n + 5;
            Node[] nodeArray = new Node[n2];
            System.arraycopy(this.parentList, 0, nodeArray, 0, n);
            this.parentList = nodeArray;
        }
    }

    private class InternalUpdater
    implements InternalNodeUpdateListener {
        private InternalUpdater() {
        }

        public void updateBoundsAndNotify() {
            Geometry.this.updateBounds();
        }
    }
}

