/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import javax.media.opengl.GL;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Light;

public class DirectionalLight
extends Light {
    private float[] direction;

    public DirectionalLight() {
        super(3);
        this.direction = new float[4];
    }

    public DirectionalLight(float[] fArray) throws IllegalArgumentException {
        super(3, fArray);
        this.direction = new float[4];
    }

    public DirectionalLight(float[] fArray, float[] fArray2) throws IllegalArgumentException {
        super(3, fArray);
        this.direction = new float[]{fArray2[0], fArray2[1], fArray2[2], 0.0f};
    }

    public void render(GL gL, Object object) {
        int n = (Integer)object;
        gL.glLightfv(n, 4608, this.ambientColor, 0);
        gL.glLightfv(n, 4611, this.direction, 0);
        gL.glLightfv(n, 4609, this.diffuseColor, 0);
        gL.glLightfv(n, 4610, this.specularColor, 0);
        gL.glEnable(n);
    }

    public void postRender(GL gL, Object object) {
        gL.glDisable(((Integer)object).intValue());
    }

    protected void markBoundsDirty() {
        if (this.parent != null) {
            this.parent.markBoundsDirty();
        }
    }

    public void setDirection(float[] fArray) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.direction[0] = fArray[0];
        this.direction[1] = fArray[1];
        this.direction[2] = fArray[2];
    }

    public void setDirection(float f, float f2, float f3) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.direction[0] = f;
        this.direction[1] = f2;
        this.direction[2] = f3;
    }

    public void getDirection(float[] fArray) {
        fArray[0] = this.direction[0];
        fArray[1] = this.direction[1];
        fArray[2] = this.direction[2];
    }

    public int compareTo(Light light) {
        int n = super.compareTo(light);
        if (n != 0) {
            return n;
        }
        DirectionalLight directionalLight = (DirectionalLight)light;
        return this.compareColor3(this.direction, directionalLight.direction);
    }
}

