/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import javax.media.opengl.GL;
import org.j3d.aviatrix3d.BufferState;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.rendering.BufferStateRenderable;

public class DepthBufferState
extends BufferState
implements BufferStateRenderable {
    private static final String INVALID_RANGE_MSG = "The depth range provided is outside the value range of [0,1]: ";
    private static final String INVALID_FUNCTION_MSG = "The function requested is not a standard type: ";
    public static final int FUNCTION_NEVER = 512;
    public static final int FUNCTION_LESS = 513;
    public static final int FUNCTION_LESS_OR_EQUAL = 515;
    public static final int FUNCTION_GREATER = 516;
    public static final int FUNCTION_GREATER_OR_EQUAL = 518;
    public static final int FUNCTION_EQUAL = 514;
    public static final int FUNCTION_NOTEQUAL = 517;
    public static final int FUNCTION_ALWAYS = 519;
    private float minRange = 0.0f;
    private float maxRange = 1.0f;
    private float clearDepth = 1.0f;
    private int function = 513;
    private boolean clearState = true;
    private boolean depthTest = true;
    private boolean depthWrite = true;
    private boolean currentDepthTestState;

    public int getBufferType() {
        return 3;
    }

    public int getBufferBitMask() {
        return 256;
    }

    public boolean checkClearBufferState() {
        return this.clearState;
    }

    public void setBufferState(GL gL) {
        this.currentDepthTestState = gL.glIsEnabled(2929);
        if (this.depthTest != this.currentDepthTestState) {
            if (this.depthTest) {
                gL.glEnable(2929);
            } else {
                gL.glDisable(2929);
            }
        }
        gL.glDepthMask(this.depthWrite);
        gL.glDepthFunc(this.function);
        gL.glDepthRange((double)this.minRange, (double)this.maxRange);
        gL.glClearDepth((double)this.clearDepth);
    }

    public void updateBufferState(GL gL) {
        gL.glDepthMask(this.depthWrite);
        gL.glDepthFunc(this.function);
        gL.glDepthRange((double)this.minRange, (double)this.maxRange);
        gL.glClearDepth((double)this.clearDepth);
    }

    public void clearBufferState(GL gL) {
        if (this.depthTest != this.currentDepthTestState) {
            if (this.currentDepthTestState) {
                gL.glEnable(2929);
            } else {
                gL.glDisable(2929);
            }
        }
        gL.glDepthMask(true);
        gL.glDepthFunc(513);
        gL.glDepthRange(0.0, 1.0);
        gL.glClearDepth(1.0);
    }

    public int compareTo(Object object) throws ClassCastException {
        DepthBufferState depthBufferState = (DepthBufferState)object;
        return this.compareTo(depthBufferState);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DepthBufferState)) {
            return false;
        }
        return this.equals((DepthBufferState)object);
    }

    public void setClearBufferState(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.clearState = bl;
    }

    public void enableDepthTest(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.depthTest = bl;
    }

    public boolean isDepthTestEnabled() {
        return this.depthTest;
    }

    public void enableDepthWrite(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.depthWrite = bl;
    }

    public boolean isDepthWriteEnabled() {
        return this.depthWrite;
    }

    public void setMinRange(float f) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException(INVALID_RANGE_MSG + f);
        }
        this.minRange = f;
    }

    public float getMinRange() {
        return this.minRange;
    }

    public void setMaxRange(float f) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException(INVALID_RANGE_MSG + f);
        }
        this.maxRange = f;
    }

    public float getMaxRange() {
        return this.maxRange;
    }

    public void setClearDepth(float f) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException(INVALID_RANGE_MSG + f);
        }
        this.clearDepth = f;
    }

    public float getClearDepth() {
        return this.clearDepth;
    }

    public void setDepthFunction(int n) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        switch (n) {
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: {
                this.function = n;
                break;
            }
            default: {
                throw new IllegalArgumentException(INVALID_FUNCTION_MSG + n);
            }
        }
    }

    public int getDepthFunction() {
        return this.function;
    }

    public int compareTo(DepthBufferState depthBufferState) {
        if (depthBufferState == null) {
            return 1;
        }
        if (depthBufferState == this) {
            return 0;
        }
        if (this.clearState != depthBufferState.clearState) {
            return this.clearState ? 1 : -1;
        }
        if (this.depthTest != depthBufferState.depthTest) {
            return this.depthTest ? 1 : -1;
        }
        if (this.depthWrite != depthBufferState.depthWrite) {
            return this.depthWrite ? 1 : -1;
        }
        if (this.minRange != depthBufferState.minRange) {
            return this.minRange < depthBufferState.minRange ? -1 : 1;
        }
        if (this.maxRange != depthBufferState.maxRange) {
            return this.maxRange < depthBufferState.maxRange ? -1 : 1;
        }
        if (this.clearDepth != depthBufferState.clearDepth) {
            return this.clearDepth < depthBufferState.clearDepth ? -1 : 1;
        }
        if (this.function != depthBufferState.function) {
            return this.function < depthBufferState.function ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(DepthBufferState depthBufferState) {
        if (depthBufferState == this) {
            return true;
        }
        return depthBufferState != null && this.clearState == depthBufferState.clearState && this.depthTest == depthBufferState.depthTest && this.depthWrite == depthBufferState.depthWrite && this.minRange == depthBufferState.minRange && this.maxRange == depthBufferState.maxRange && this.clearDepth == depthBufferState.clearDepth && this.function == depthBufferState.function;
    }
}

