/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import javax.media.opengl.GL;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.NodeComponent;
import org.j3d.aviatrix3d.rendering.AppearanceAttributeRenderable;

public class DepthAttributes
extends NodeComponent
implements AppearanceAttributeRenderable {
    private static final String INVALID_RANGE_MSG = "The depth range provided is outside the value range of [0,1]: ";
    private static final String INVALID_FUNCTION_MSG = "The function requested is not a standard type: ";
    public static final int FUNCTION_NEVER = 512;
    public static final int FUNCTION_LESS = 513;
    public static final int FUNCTION_LESS_OR_EQUAL = 515;
    public static final int FUNCTION_GREATER = 516;
    public static final int FUNCTION_GREATER_OR_EQUAL = 518;
    public static final int FUNCTION_EQUAL = 514;
    public static final int FUNCTION_NOTEQUAL = 517;
    public static final int FUNCTION_ALWAYS = 519;
    private float minRange = 0.0f;
    private float maxRange = 1.0f;
    private int function = 513;
    private boolean depthTest = true;
    private boolean depthWrite = true;

    public int getAttributeType() {
        return 2;
    }

    public void render(GL gL) {
        if (this.depthTest) {
            gL.glEnable(2929);
        } else {
            gL.glDisable(2929);
        }
        gL.glDepthMask(this.depthWrite);
        gL.glDepthFunc(this.function);
        gL.glDepthRange((double)this.minRange, (double)this.maxRange);
    }

    public void postRender(GL gL) {
        if (!this.depthTest) {
            gL.glEnable(2929);
        }
        gL.glDepthMask(true);
        gL.glDepthFunc(513);
        gL.glDepthRange(0.0, 1.0);
    }

    public int compareTo(Object object) throws ClassCastException {
        DepthAttributes depthAttributes = (DepthAttributes)object;
        return this.compareTo(depthAttributes);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DepthAttributes)) {
            return false;
        }
        return this.equals((DepthAttributes)object);
    }

    public void enableDepthTest(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.depthTest = bl;
    }

    public boolean isDepthTestEnabled() {
        return this.depthTest;
    }

    public void enableDepthWrite(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.depthWrite = bl;
    }

    public boolean isDepthWriteEnabled() {
        return this.depthWrite;
    }

    public void setMinRange(float f) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException(INVALID_RANGE_MSG + f);
        }
        this.minRange = f;
    }

    public float getMinRange() {
        return this.minRange;
    }

    public void setMaxRange(float f) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException(INVALID_RANGE_MSG + f);
        }
        this.maxRange = f;
    }

    public float getMaxRange() {
        return this.maxRange;
    }

    public void setDepthFunction(int n) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        switch (n) {
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: {
                this.function = n;
                break;
            }
            default: {
                throw new IllegalArgumentException(INVALID_FUNCTION_MSG + n);
            }
        }
    }

    public int getDepthFunction() {
        return this.function;
    }

    public int compareTo(DepthAttributes depthAttributes) {
        if (depthAttributes == null) {
            return 1;
        }
        if (depthAttributes == this) {
            return 0;
        }
        if (this.depthTest != depthAttributes.depthTest) {
            return this.depthTest ? 1 : -1;
        }
        if (this.depthWrite != depthAttributes.depthWrite) {
            return this.depthWrite ? 1 : -1;
        }
        if (this.minRange != depthAttributes.minRange) {
            return this.minRange < depthAttributes.minRange ? -1 : 1;
        }
        if (this.maxRange != depthAttributes.maxRange) {
            return this.maxRange < depthAttributes.maxRange ? -1 : 1;
        }
        if (this.function != depthAttributes.function) {
            return this.function < depthAttributes.function ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(DepthAttributes depthAttributes) {
        if (depthAttributes == this) {
            return true;
        }
        return depthAttributes != null && this.depthTest == depthAttributes.depthTest && this.depthWrite == depthAttributes.depthWrite && this.minRange == depthAttributes.minRange && this.maxRange == depthAttributes.maxRange && this.function == depthAttributes.function;
    }
}

