/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import net.java.games.joal.AL;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.PointSound;

public class ConeSound
extends PointSound {
    private int source;
    private Point3f position = new Point3f();
    private Point3f tmpPoint = new Point3f();
    private Matrix4f tmpMatrix = new Matrix4f();
    private float[] direction;
    private float innerAngle;
    private float outerAngle;

    public ConeSound() {
        this.refDistance = 0.0f;
        this.maxDistance = Float.MAX_VALUE;
        this.innerAngle = 360.0f;
        this.outerAngle = 360.0f;
        this.direction = new float[]{0.0f, 0.0f, 0.0f};
        this.rolloffFactor = 1.0f;
    }

    public void render(AL aL, Matrix4f matrix4f) {
        matrix4f.transform(this.position, this.tmpPoint);
        if (this.dataChanged) {
            this.buffer = this.soundSource.getBufferId(aL, this.seq);
            if (this.buffer == -1) {
                return;
            }
            this.dataChanged = false;
            this.playChanged = true;
            this.values.rewind();
            aL.alGenSources(1, this.values);
            this.source = this.values.get(0);
            if (aL.alGetError() != 0) {
                System.out.println("Error creating OpenAL Source");
            }
            aL.alSourcei(this.source, 4105, this.buffer);
            aL.alSourcef(this.source, 4128, this.refDistance);
            aL.alSourcef(this.source, 4129, this.rolloffFactor);
            aL.alSourcef(this.source, 4131, this.maxDistance);
            aL.alSourcef(this.source, 4097, this.innerAngle);
            aL.alSourcef(this.source, 4098, this.outerAngle);
            aL.alSourcefv(this.source, 4101, this.direction, 0);
            aL.alSourcef(this.source, 4106, 1.0f);
            aL.alSourcei(this.source, 4103, this.loop ? 1 : 0);
            aL.alSourcef(this.source, 4099, this.pitch);
            aL.alSource3f(this.source, 4100, this.tmpPoint.x, this.tmpPoint.y, this.tmpPoint.z);
            if (aL.alGetError() != 0) {
                System.out.println("Error setting OpenAL Source params");
            }
        }
        if (this.paramsChanged) {
            aL.alSourcef(this.source, 4099, this.pitch);
            aL.alSourcei(this.source, 4103, this.loop ? 1 : 0);
            this.paramsChanged = false;
        }
        aL.alSource3f(this.source, 4100, this.tmpPoint.x, this.tmpPoint.y, this.tmpPoint.z);
        if (this.playChanged) {
            if (this.playing && this.paused) {
                aL.alSourcePlay(this.source);
            }
            if (this.playing) {
                if (this.paused) {
                    aL.alSourcePause(this.source);
                } else {
                    aL.alSourcePlay(this.source);
                }
            } else {
                aL.alSourceStop(this.source);
            }
            this.playChanged = false;
        } else if (this.playing) {
            this.values.rewind();
            aL.alGetSourcei(this.source, 4112, this.values);
            if (this.values.get(0) == 4116) {
                this.playing = false;
            }
        }
    }

    public void postRender(AL aL) {
    }

    public int compareTo(Object object) throws ClassCastException {
        ConeSound coneSound = (ConeSound)object;
        return this.compareTo(coneSound);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConeSound)) {
            return false;
        }
        return this.equals((ConeSound)object);
    }

    public void setRefDistance(float[] fArray) {
        if (this.alive && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.direction[0] = fArray[0];
        this.direction[1] = fArray[1];
        this.direction[2] = fArray[2];
    }

    public void getRefDistance(float[] fArray) {
        fArray[0] = this.direction[0];
        fArray[1] = this.direction[1];
        fArray[2] = this.direction[2];
    }

    public void setInnerAngle(float f) {
        if (this.alive && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.innerAngle = f;
    }

    public void setOuterAngle(float f) {
        if (this.alive && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.outerAngle = f;
    }

    public int compareTo(ConeSound coneSound) {
        if (coneSound == null) {
            return 1;
        }
        if (coneSound == this) {
            return 0;
        }
        int n = super.compareTo(coneSound);
        if (n != 0) {
            return n;
        }
        n = this.compareVector(this.direction, coneSound.direction);
        if (n != 0) {
            return n;
        }
        if (this.innerAngle != coneSound.innerAngle) {
            return this.innerAngle < coneSound.innerAngle ? -1 : 1;
        }
        if (this.outerAngle != coneSound.outerAngle) {
            return this.outerAngle < coneSound.outerAngle ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(ConeSound coneSound) {
        if (coneSound == this) {
            return true;
        }
        if (coneSound == null) {
            return false;
        }
        if (!super.equals(coneSound)) {
            return false;
        }
        return this.innerAngle == coneSound.innerAngle && this.outerAngle == coneSound.outerAngle && this.direction[0] == coneSound.direction[0] && this.direction[1] == coneSound.direction[1] && this.direction[2] == coneSound.direction[2];
    }

    private int compareVector(float[] fArray, float[] fArray2) {
        if (fArray[0] < fArray2[0]) {
            return -1;
        }
        if (fArray[0] > fArray2[0]) {
            return 1;
        }
        if (fArray[1] < fArray2[1]) {
            return -1;
        }
        if (fArray[1] > fArray2[1]) {
            return 1;
        }
        if (fArray[2] < fArray2[2]) {
            return -1;
        }
        if (fArray[2] > fArray2[2]) {
            return 1;
        }
        return 0;
    }
}

