/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.util.ArrayList;
import org.j3d.aviatrix3d.AlreadyParentedException;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.Viewport;
import org.j3d.aviatrix3d.ViewportLayer;
import org.j3d.aviatrix3d.rendering.ViewportCullable;
import org.j3d.aviatrix3d.rendering.ViewportLayerCullable;

public class CompositeViewport
extends Viewport
implements ViewportCullable {
    private static final String HAS_PARENT_MSG = "This layer already has a parent. Layers cannot be shared amongst layers multiple times.";
    private ArrayList<ViewportLayer> layers = new ArrayList();

    public CompositeViewport() {
        super(1);
    }

    public ViewportLayerCullable getCullableLayer(int n) {
        if (n < 0 || n >= this.layers.size()) {
            return null;
        }
        return (ViewportLayerCullable)((Object)this.layers.get(n));
    }

    public int numCullableChildren() {
        return this.layers.size();
    }

    public void setDimensions(int n, int n2, int n3, int n4) throws InvalidWriteTimingException {
        super.setDimensions(n, n2, n3, n4);
        int n5 = this.layers.size();
        for (int i = 0; i < n5; ++i) {
            ViewportLayer viewportLayer = this.layers.get(i);
            viewportLayer.setViewportDimensions(n, n2, n3, n4);
        }
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        int n = this.layers.size();
        for (int i = 0; i < n; ++i) {
            this.layers.get(i).setUpdateHandler(nodeUpdateHandler);
        }
    }

    protected void setLive(boolean bl) {
        super.setLive(bl);
        int n = this.layers.size();
        for (int i = 0; i < n; ++i) {
            this.layers.get(i).setLive(bl);
        }
    }

    public void addViewportLayer(ViewportLayer viewportLayer) throws InvalidWriteTimingException, AlreadyParentedException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (viewportLayer == null) {
            return;
        }
        if (viewportLayer.hasParent()) {
            throw new AlreadyParentedException(HAS_PARENT_MSG);
        }
        viewportLayer.setViewportDimensions(this.viewX, this.viewY, this.viewWidth, this.viewHeight);
        viewportLayer.setUpdateHandler(this.updateHandler);
        viewportLayer.setLive(this.alive);
        this.layers.add(viewportLayer);
    }

    public void removeViewportLayer(ViewportLayer viewportLayer) {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (viewportLayer == null) {
            return;
        }
        if (!this.layers.remove(viewportLayer)) {
            viewportLayer.setUpdateHandler(null);
            viewportLayer.setLive(false);
        }
    }

    public ViewportLayer removeViewportLayer(int n) {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n < 0 || n > this.layers.size()) {
            return null;
        }
        ViewportLayer viewportLayer = this.layers.remove(n);
        viewportLayer.setUpdateHandler(null);
        viewportLayer.setLive(false);
        return viewportLayer;
    }

    public void clearViewportLayers() {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        int n = this.layers.size();
        for (int i = n - 1; i >= 0; --i) {
            ViewportLayer viewportLayer = this.layers.remove(n);
            viewportLayer.setUpdateHandler(null);
            viewportLayer.setLive(false);
        }
    }

    public ViewportLayer getViewportLayer(int n) {
        return this.layers.get(n);
    }

    public int numViewportLayers() {
        return this.layers.size();
    }
}

