/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.util.ArrayList;
import org.j3d.aviatrix3d.AlreadyParentedException;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Layer;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.Viewport;
import org.j3d.aviatrix3d.Viewport2D;
import org.j3d.aviatrix3d.rendering.ViewportCullable;

public class CompositeLayer2D
extends Layer {
    private static final String HAS_PARENT_MSG = "This viewport already has a parent. Viewports cannot be shared amongst layers multiple times.";
    private ArrayList<Viewport> viewports = new ArrayList();

    public CompositeLayer2D() {
        super(3);
    }

    public ViewportCullable getCullableViewport(int n) {
        if (n < 0 || n >= this.viewports.size()) {
            return null;
        }
        Viewport viewport = this.viewports.get(n);
        return viewport instanceof ViewportCullable ? (ViewportCullable)((Object)viewport) : null;
    }

    public int numCullableChildren() {
        return this.viewports.size();
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        int n = this.viewports.size();
        for (int i = 0; i < n; ++i) {
            this.viewports.get(i).setUpdateHandler(nodeUpdateHandler);
        }
    }

    protected void setLive(boolean bl) {
        super.setLive(bl);
        int n = this.viewports.size();
        for (int i = 0; i < n; ++i) {
            this.viewports.get(i).setLive(bl);
        }
    }

    public void addViewport(Viewport2D viewport2D) throws InvalidWriteTimingException, AlreadyParentedException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (viewport2D == null) {
            return;
        }
        if (viewport2D.hasParent()) {
            throw new AlreadyParentedException(HAS_PARENT_MSG);
        }
        viewport2D.setUpdateHandler(this.updateHandler);
        viewport2D.setLive(this.alive);
        this.viewports.add(viewport2D);
    }

    public void removeViewport(Viewport2D viewport2D) {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (viewport2D == null) {
            return;
        }
        if (!this.viewports.remove(viewport2D)) {
            viewport2D.setUpdateHandler(null);
            viewport2D.setLive(false);
        }
    }

    public Viewport2D removeViewport(int n) {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n < 0 || n > this.viewports.size()) {
            return null;
        }
        Viewport2D viewport2D = (Viewport2D)this.viewports.remove(n);
        viewport2D.setUpdateHandler(null);
        viewport2D.setLive(false);
        return viewport2D;
    }

    public void clearViewports() {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        int n = this.viewports.size();
        for (int i = n - 1; i >= 0; --i) {
            Viewport2D viewport2D = (Viewport2D)this.viewports.remove(n);
            viewport2D.setUpdateHandler(null);
            viewport2D.setLive(false);
        }
    }

    public Viewport2D getViewport(int n) {
        return (Viewport2D)this.viewports.get(n);
    }

    public int numViewports() {
        return this.viewports.size();
    }
}

