/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.util.ArrayList;
import org.j3d.aviatrix3d.AlreadyParentedException;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Layer;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.Viewport;
import org.j3d.aviatrix3d.rendering.ViewportCullable;

public class CompositeLayer
extends Layer {
    private static final String HAS_PARENT_MSG = "This viewport already has a parent. Viewports cannot be shared amongst layers multiple times.";
    private ArrayList<Viewport> viewports = new ArrayList();

    public CompositeLayer() {
        super(1);
    }

    public ViewportCullable getCullableViewport(int n) {
        if (n < 0 || n >= this.viewports.size()) {
            return null;
        }
        Viewport viewport = this.viewports.get(n);
        return viewport instanceof ViewportCullable ? (ViewportCullable)((Object)viewport) : null;
    }

    public int numCullableChildren() {
        return this.viewports.size();
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        int n = this.viewports.size();
        for (int i = 0; i < n; ++i) {
            this.viewports.get(i).setUpdateHandler(nodeUpdateHandler);
        }
    }

    protected void setLive(boolean bl) {
        super.setLive(bl);
        int n = this.viewports.size();
        for (int i = 0; i < n; ++i) {
            this.viewports.get(i).setLive(bl);
        }
    }

    public void addViewport(Viewport viewport) throws InvalidWriteTimingException, AlreadyParentedException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (viewport == null) {
            return;
        }
        if (viewport.hasParent()) {
            throw new AlreadyParentedException(HAS_PARENT_MSG);
        }
        viewport.setUpdateHandler(this.updateHandler);
        viewport.setLive(this.alive);
        this.viewports.add(viewport);
    }

    public void removeViewport(Viewport viewport) {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (viewport == null) {
            return;
        }
        if (!this.viewports.remove(viewport)) {
            viewport.setUpdateHandler(null);
            viewport.setLive(false);
        }
    }

    public Viewport removeViewport(int n) {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n < 0 || n > this.viewports.size()) {
            return null;
        }
        Viewport viewport = this.viewports.remove(n);
        viewport.setUpdateHandler(null);
        viewport.setLive(false);
        return viewport;
    }

    public void clearViewports() {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        int n = this.viewports.size();
        for (int i = n - 1; i >= 0; --i) {
            Viewport viewport = this.viewports.remove(n);
            viewport.setUpdateHandler(null);
            viewport.setLive(false);
        }
    }

    public Viewport getViewport(int n) {
        return this.viewports.get(n);
    }

    public int numViewports() {
        return this.viewports.size();
    }
}

