/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import javax.media.opengl.GL;
import org.j3d.aviatrix3d.BufferState;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.rendering.BufferStateRenderable;

public class ColorBufferState
extends BufferState
implements BufferStateRenderable {
    private boolean redEnabled = true;
    private boolean greenEnabled = true;
    private boolean blueEnabled = true;
    private boolean alphaEnabled = true;
    private float red = 0.0f;
    private float green = 0.0f;
    private float blue = 0.0f;
    private float alpha = 0.0f;
    private boolean clearState = true;

    public int getBufferType() {
        return 4;
    }

    public int getBufferBitMask() {
        return 16384;
    }

    public boolean checkClearBufferState() {
        return this.clearState;
    }

    public void setBufferState(GL gL) {
        gL.glClearColor(this.red, this.green, this.blue, this.alpha);
        gL.glColorMask(this.redEnabled, this.greenEnabled, this.blueEnabled, this.alphaEnabled);
    }

    public void updateBufferState(GL gL) {
        gL.glClearColor(this.red, this.green, this.blue, this.alpha);
        gL.glColorMask(this.redEnabled, this.greenEnabled, this.blueEnabled, this.alphaEnabled);
    }

    public void clearBufferState(GL gL) {
        gL.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gL.glColorMask(true, true, true, true);
    }

    public int compareTo(Object object) throws ClassCastException {
        ColorBufferState colorBufferState = (ColorBufferState)object;
        return this.compareTo(colorBufferState);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ColorBufferState)) {
            return false;
        }
        return this.equals((ColorBufferState)object);
    }

    public void setClearBufferState(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.clearState = bl;
    }

    public void setColorMask(boolean bl, boolean bl2, boolean bl3, boolean bl4) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.redEnabled = bl;
        this.greenEnabled = bl2;
        this.blueEnabled = bl3;
        this.alphaEnabled = bl4;
    }

    public boolean isRedEnabled() {
        return this.redEnabled;
    }

    public boolean isGreenEnabled() {
        return this.greenEnabled;
    }

    public boolean isBlueEnabled() {
        return this.blueEnabled;
    }

    public boolean isAlphaEnabled() {
        return this.alphaEnabled;
    }

    public void setClearColor(float f, float f2, float f3, float f4) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.red = f;
        this.green = f2;
        this.blue = f3;
        this.alpha = f4;
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public int compareTo(ColorBufferState colorBufferState) {
        if (colorBufferState == null) {
            return 1;
        }
        if (colorBufferState == this) {
            return 0;
        }
        if (this.clearState != colorBufferState.clearState) {
            return this.clearState ? 1 : -1;
        }
        if (this.redEnabled != colorBufferState.redEnabled) {
            return this.redEnabled ? 1 : -1;
        }
        if (this.greenEnabled != colorBufferState.greenEnabled) {
            return this.greenEnabled ? 1 : -1;
        }
        if (this.blueEnabled != colorBufferState.blueEnabled) {
            return this.blueEnabled ? 1 : -1;
        }
        if (this.alphaEnabled != colorBufferState.alphaEnabled) {
            return this.alphaEnabled ? 1 : -1;
        }
        if (this.red != colorBufferState.red) {
            return this.red < colorBufferState.red ? -1 : 1;
        }
        if (this.green != colorBufferState.green) {
            return this.green < colorBufferState.green ? -1 : 1;
        }
        if (this.blue != colorBufferState.blue) {
            return this.blue < colorBufferState.blue ? -1 : 1;
        }
        if (this.alpha != colorBufferState.alpha) {
            return this.alpha < colorBufferState.alpha ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(ColorBufferState colorBufferState) {
        if (colorBufferState == this) {
            return true;
        }
        return colorBufferState != null && this.clearState == colorBufferState.clearState && this.redEnabled == colorBufferState.redEnabled && this.greenEnabled == colorBufferState.greenEnabled && this.blueEnabled == colorBufferState.blueEnabled && this.alphaEnabled == colorBufferState.alphaEnabled && this.red == colorBufferState.red && this.green == colorBufferState.green && this.blue == colorBufferState.blue && this.alpha == colorBufferState.alpha;
    }
}

