/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import javax.media.opengl.GL;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Leaf;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.j3d.aviatrix3d.rendering.ComponentRenderable;
import org.j3d.aviatrix3d.rendering.EffectRenderable;
import org.j3d.aviatrix3d.rendering.LeafCullable;
import org.j3d.aviatrix3d.rendering.Renderable;

public class ClipPlane
extends Leaf
implements LeafCullable,
ComponentRenderable,
EffectRenderable,
Comparable {
    private static final String EQ_SIZE_MSG = "Not enough components were provided for the plane equation. There needs to be at least 4 values";
    private double[] planeEquation = new double[4];
    private boolean enabled = false;
    private boolean globalOnly = false;
    private BoundingVolume effectBounds;

    public int getCullableType() {
        return 3;
    }

    public Renderable getRenderable() {
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isGlobalOnly() {
        return this.globalOnly;
    }

    public BoundingVolume getEffectBounds() {
        return this.effectBounds;
    }

    public void render(GL gL, Object object) {
        gL.glClipPlane(((Integer)object).intValue(), this.planeEquation, 0);
        gL.glEnable(((Integer)object).intValue());
    }

    public void postRender(GL gL, Object object) {
        gL.glDisable(((Integer)object).intValue());
    }

    public int compareTo(Object object) throws ClassCastException {
        ClipPlane clipPlane = (ClipPlane)object;
        return this.compareTo(clipPlane);
    }

    public void setEnabled(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.enabled = bl;
    }

    public void setGlobalOnly(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.globalOnly = bl;
    }

    public void setEffectBounds(BoundingVolume boundingVolume) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.effectBounds = boundingVolume;
    }

    public void setPlaneEquation(double[] dArray) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (dArray == null || dArray.length < 4) {
            throw new IllegalArgumentException(EQ_SIZE_MSG);
        }
        this.planeEquation[0] = dArray[0];
        this.planeEquation[1] = dArray[1];
        this.planeEquation[2] = dArray[2];
        this.planeEquation[3] = dArray[3];
    }

    public void getPlaneEquation(double[] dArray) {
        dArray[0] = this.planeEquation[0];
        dArray[1] = this.planeEquation[1];
        dArray[2] = this.planeEquation[2];
        dArray[3] = this.planeEquation[3];
    }

    public int compareTo(ClipPlane clipPlane) {
        if (clipPlane == null) {
            return 1;
        }
        if (clipPlane == this) {
            return 0;
        }
        if (this.enabled != clipPlane.enabled) {
            return this.enabled ? 1 : -1;
        }
        if (this.globalOnly != clipPlane.globalOnly) {
            return this.globalOnly ? 1 : -1;
        }
        return this.compareVector4(this.planeEquation, clipPlane.planeEquation);
    }

    private int compareVector4(double[] dArray, double[] dArray2) {
        if (dArray[0] < dArray2[0]) {
            return -1;
        }
        if (dArray[0] > dArray2[0]) {
            return 1;
        }
        if (dArray[1] < dArray2[1]) {
            return -1;
        }
        if (dArray[1] > dArray2[1]) {
            return 1;
        }
        if (dArray[2] < dArray2[2]) {
            return -1;
        }
        if (dArray[2] > dArray2[2]) {
            return 1;
        }
        if (dArray[3] < dArray2[3]) {
            return -1;
        }
        if (dArray[3] > dArray2[3]) {
            return 1;
        }
        return 0;
    }
}

