/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.TextureComponent2D;

public class ByteTextureComponent2D
extends TextureComponent2D {
    private byte[][] pixels;

    public ByteTextureComponent2D() {
        this(0, 0, 0, null);
    }

    public ByteTextureComponent2D(boolean bl) {
        this(0, 0, 0, null);
        this.invertY = !bl;
    }

    public ByteTextureComponent2D(int n, int n2, int n3, byte[] byArray) {
        super(1);
        this.width = n2;
        this.height = n3;
        this.format = n;
        int n4 = byArray == null ? 0 : byArray.length;
        this.pixels = new byte[1][n4];
        if (byArray != null) {
            System.arraycopy(byArray, 0, this.pixels[0], 0, n4);
        }
    }

    public ByteTextureComponent2D(int n, int n2, int n3, byte[][] byArray, int n4) {
        super(n4);
        this.width = n2;
        this.height = n3;
        this.format = n;
        this.pixels = new byte[n4][];
        for (int i = 0; i < n4; ++i) {
            int n5 = byArray[i] == null ? 0 : byArray[i].length;
            this.pixels[i] = new byte[n5];
            System.arraycopy(byArray[i], 0, this.pixels[i], 0, n5);
        }
    }

    public ByteTextureComponent2D(int n, int n2, int n3, byte[] byArray, boolean bl) {
        this(n, n2, n3, byArray);
        this.invertY = !bl;
    }

    public void updateSubImage(int n, int n2, int n3, int n4, int n5, byte[] byArray) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.sendTextureUpdate(n, n2, 0, n3, n4, 1, n5, byArray);
    }

    public void clearLocalData() {
    }

    protected ByteBuffer convertImage(int n) {
        ByteBuffer byteBuffer = null;
        byteBuffer = ByteBuffer.allocateDirect(this.pixels[n].length);
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.put(this.pixels[n]);
        return byteBuffer;
    }
}

