/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.TextureComponent1D;

public class ByteTextureComponent1D
extends TextureComponent1D {
    private byte[][] pixels;

    public ByteTextureComponent1D() {
        this(0, 0, null);
    }

    public ByteTextureComponent1D(boolean bl) {
        this(0, 0, null);
        this.invertY = !bl;
    }

    public ByteTextureComponent1D(int n, int n2, byte[] byArray) {
        super(1);
        this.width = n2;
        this.format = n;
        int n3 = byArray == null ? 0 : byArray.length;
        this.pixels = new byte[1][n3];
        System.arraycopy(byArray, 0, this.pixels[0], 0, n3);
    }

    public ByteTextureComponent1D(int n, int n2, byte[][] byArray, int n3) {
        super(n3);
        this.width = n2;
        this.format = n;
        this.pixels = new byte[n3][];
        for (int i = 0; i < n3; ++i) {
            int n4 = byArray[i] == null ? 0 : byArray[i].length;
            this.pixels[i] = new byte[n4];
            System.arraycopy(byArray[i], 0, this.pixels[i], 0, n4);
        }
    }

    public ByteTextureComponent1D(int n, int n2, byte[] byArray, boolean bl) {
        this(n, n2, byArray);
        this.invertY = !bl;
    }

    public void updateSubImage(int n, int n2, int n3, byte[] byArray) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.sendTextureUpdate(n, 0, 0, n2, 1, 1, n3, byArray);
    }

    public void clearLocalData() {
    }

    protected ByteBuffer convertImage(int n) {
        ByteBuffer byteBuffer = null;
        byteBuffer = ByteBuffer.allocateDirect(this.pixels[n].length);
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.put(this.pixels[n]);
        return byteBuffer;
    }
}

