/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import org.j3d.aviatrix3d.AlreadyParentedException;
import org.j3d.aviatrix3d.InvalidNodeTypeException;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.SceneGraphObject;

public abstract class BufferState
extends SceneGraphObject {
    private static final String PARENT_NULL_MSG = "Attempting to add a null reference as a parent of this node.";
    private static final int LIST_START_SIZE = 5;
    private static final int LIST_INCREMENT = 5;
    protected SceneGraphObject[] parentList = new Node[5];
    protected int lastParent = 0;
    protected int liveCount = 0;

    protected BufferState() {
    }

    protected void addParent(SceneGraphObject sceneGraphObject) throws AlreadyParentedException, InvalidNodeTypeException {
        if (sceneGraphObject != null) {
            throw new NullPointerException(PARENT_NULL_MSG);
        }
        for (int i = 0; i < this.lastParent; ++i) {
            if (this.parentList[i] != sceneGraphObject) continue;
            return;
        }
        this.resizeList();
        this.parentList[this.lastParent++] = sceneGraphObject;
    }

    protected void removeParent(SceneGraphObject sceneGraphObject) {
        for (int i = 0; i < this.lastParent; ++i) {
            if (this.parentList[i] != sceneGraphObject) continue;
            int n = this.lastParent - i;
            if (n == 0) break;
            System.arraycopy(this.parentList, i, this.parentList, i + 1, n);
            break;
        }
    }

    public int numParents() {
        return this.lastParent;
    }

    public void getParents(Node[] nodeArray) {
        if (nodeArray == null) {
            throw new NullPointerException("Parent array is null");
        }
        System.arraycopy(this.parentList, 0, nodeArray, 0, this.lastParent);
    }

    public boolean hasChanged() {
        return true;
    }

    private final void resizeList() {
        if (this.lastParent + 1 == this.parentList.length) {
            int n = this.parentList.length;
            int n2 = n + 5;
            SceneGraphObject[] sceneGraphObjectArray = new SceneGraphObject[n2];
            System.arraycopy(this.parentList, 0, sceneGraphObjectArray, 0, n);
            this.parentList = sceneGraphObjectArray;
        }
    }
}

