/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.HashMap;
import javax.media.opengl.GL;
import org.j3d.aviatrix3d.Background;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.TextureComponent2D;
import org.j3d.aviatrix3d.rendering.DeletableRenderable;

public class BoxBackground
extends Background
implements DeletableRenderable {
    private static final float BOX_SIZE = 1.0f;
    private static final float[] BOX_TEX_COORDS = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    private static final float[] BACK_BOX_COORDS = new float[]{1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f};
    private static final float[] BACK_BOX_NORMALS = new float[]{0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f};
    private static final float[] FRONT_BOX_COORDS = new float[]{-1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f};
    private static final float[] FRONT_BOX_NORMALS = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
    private static final float[] LEFT_BOX_COORDS = new float[]{-1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f};
    private static final float[] LEFT_BOX_NORMALS = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
    private static final float[] RIGHT_BOX_COORDS = new float[]{1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private static final float[] RIGHT_BOX_NORMALS = new float[]{-1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f};
    private static final float[] TOP_BOX_COORDS = new float[]{-1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
    private static final float[] TOP_BOX_NORMALS = new float[]{0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f};
    private static final float[] BOTTOM_BOX_COORDS = new float[]{-1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f};
    private static final float[] BOTTOM_BOX_NORMALS = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
    public static final int POSITIVE_X = 0;
    public static final int NEGATIVE_X = 1;
    public static final int POSITIVE_Y = 2;
    public static final int NEGATIVE_Y = 3;
    public static final int POSITIVE_Z = 4;
    public static final int NEGATIVE_Z = 5;
    private TextureComponent2D[] texture = new TextureComponent2D[6];
    private FloatBuffer[] vertexBuffer;
    private FloatBuffer[] normalBuffer;
    private FloatBuffer textureBuffer;
    private boolean stateChanged = false;
    private HashMap<GL, Integer>[] textureIdMap = new HashMap[6];

    public BoxBackground() {
        this(null);
    }

    public BoxBackground(float[] fArray) {
        super(fArray);
        for (int i = 0; i < 6; ++i) {
            this.textureIdMap[i] = new HashMap();
        }
        this.generateBoxGeom();
    }

    public void cleanup(GL gL) {
        for (int i = 0; i < 6; ++i) {
            Integer n = this.textureIdMap[i].remove(gL);
            if (n == null) continue;
            int[] nArray = new int[]{n};
            gL.glDeleteTextures(1, nArray, 0);
        }
    }

    public boolean is2D() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(GL gL) {
        int n;
        if (this.useClearColor) {
            gL.glClearColor(this.color[0], this.color[1], this.color[2], this.color[3]);
            gL.glClear(16384);
        }
        if (this.stateChanged) {
            for (n = 0; n < 6; ++n) {
                HashMap<GL, Integer> hashMap = this.textureIdMap[n];
                synchronized (hashMap) {
                    this.textureIdMap[n].clear();
                    continue;
                }
            }
            this.stateChanged = false;
        }
        gL.glEnable(3553);
        gL.glActiveTexture(33984);
        gL.glTexEnvi(8960, 8704, 7681);
        for (n = 0; n < 6; ++n) {
            this.renderGeom(gL, n);
        }
    }

    public void postRender(GL gL) {
        gL.glDisable(3553);
    }

    public int compareTo(Object object) throws ClassCastException {
        BoxBackground boxBackground = (BoxBackground)object;
        return this.compareTo(boxBackground);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BoxBackground)) {
            return false;
        }
        return this.equals((BoxBackground)object);
    }

    public void setTexture(int n, TextureComponent2D textureComponent2D) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.texture[n] = textureComponent2D;
        this.stateChanged = true;
    }

    public TextureComponent2D getTexture(int n) {
        return this.texture[n];
    }

    private void generateBoxGeom() {
        int n;
        this.textureBuffer = this.createBuffer(BOX_TEX_COORDS.length);
        this.textureBuffer.put(BOX_TEX_COORDS);
        this.textureBuffer.rewind();
        this.vertexBuffer = new FloatBuffer[6];
        this.normalBuffer = new FloatBuffer[6];
        for (n = 0; n < 6; ++n) {
            this.vertexBuffer[n] = this.createBuffer(12);
            this.normalBuffer[n] = this.createBuffer(12);
        }
        this.vertexBuffer[0].put(RIGHT_BOX_COORDS);
        this.normalBuffer[0].put(RIGHT_BOX_NORMALS);
        this.vertexBuffer[1].put(LEFT_BOX_COORDS);
        this.normalBuffer[1].put(LEFT_BOX_NORMALS);
        this.vertexBuffer[2].put(TOP_BOX_COORDS);
        this.normalBuffer[2].put(TOP_BOX_NORMALS);
        this.vertexBuffer[3].put(BOTTOM_BOX_COORDS);
        this.normalBuffer[3].put(BOTTOM_BOX_NORMALS);
        this.vertexBuffer[4].put(BACK_BOX_COORDS);
        this.normalBuffer[4].put(BACK_BOX_NORMALS);
        this.vertexBuffer[5].put(FRONT_BOX_COORDS);
        this.normalBuffer[5].put(FRONT_BOX_NORMALS);
        for (n = 0; n < 6; ++n) {
            this.vertexBuffer[n].rewind();
            this.normalBuffer[n].rewind();
        }
    }

    private FloatBuffer createBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        return floatBuffer;
    }

    private void renderGeom(GL gL, int n) {
        if (this.texture[n] == null) {
            return;
        }
        Integer n2 = this.textureIdMap[n].get(gL);
        if (n2 != null) {
            gL.glBindTexture(3553, n2.intValue());
        } else {
            int[] nArray = new int[1];
            gL.glGenTextures(1, nArray, 0);
            this.textureIdMap[n].put(gL, new Integer(nArray[0]));
            gL.glBindTexture(3553, nArray[0]);
            gL.glPixelStorei(3317, 1);
            gL.glTexParameteri(3553, 10242, 33071);
            gL.glTexParameteri(3553, 10243, 33071);
            gL.glTexParameteri(3553, 10240, 9729);
            gL.glTexParameteri(3553, 10241, 9729);
            ByteBuffer byteBuffer = this.texture[n].getData(0);
            int n3 = this.texture[n].getFormat(0);
            int n4 = this.texture[n].getWidth();
            int n5 = this.texture[n].getHeight();
            int n6 = 6407;
            int n7 = 6407;
            switch (n3) {
                case 1: {
                    n6 = 6407;
                    n7 = 6407;
                    break;
                }
                case 2: {
                    n6 = 6408;
                    n7 = 6408;
                    break;
                }
                case 3: {
                    n6 = 32992;
                    n7 = 32992;
                    break;
                }
                case 4: {
                    n6 = 32993;
                    n7 = 32993;
                    break;
                }
                case 5: {
                    n6 = 6410;
                    n7 = 6410;
                    break;
                }
                case 6: {
                    n6 = 6409;
                    n7 = 6409;
                    break;
                }
            }
            gL.glTexImage2D(3553, 0, n6, n4, n5, 0, n7, 5121, (Buffer)byteBuffer);
        }
        gL.glEnableClientState(32884);
        gL.glEnableClientState(32885);
        gL.glEnableClientState(32888);
        gL.glVertexPointer(3, 5126, 0, (Buffer)this.vertexBuffer[n]);
        gL.glNormalPointer(5126, 0, (Buffer)this.normalBuffer[n]);
        gL.glTexCoordPointer(2, 5126, 0, (Buffer)this.textureBuffer);
        gL.glDrawArrays(7, 0, 4);
        gL.glDisableClientState(32888);
        gL.glDisableClientState(32885);
        gL.glDisableClientState(32884);
    }

    public int compareTo(BoxBackground boxBackground) {
        if (boxBackground == null) {
            return 1;
        }
        if (boxBackground == this) {
            return 0;
        }
        int n = this.compareColor4(this.color, boxBackground.color);
        if (n != 0) {
            return n;
        }
        for (int i = 0; i < 6; ++i) {
            if (this.texture[i] == boxBackground.texture[i]) continue;
            if (this.texture[i] == null) {
                return -1;
            }
            if (boxBackground.texture[i] == null) {
                return 1;
            }
            if (this.texture[i] == boxBackground.texture[i]) continue;
            return this.texture[i].hashCode() < boxBackground.texture[i].hashCode() ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(BoxBackground boxBackground) {
        if (boxBackground == this) {
            return true;
        }
        if (boxBackground == null) {
            return false;
        }
        if (!this.equalsColor4(this.color, boxBackground.color)) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            if (this.texture[i] == boxBackground.texture[i]) continue;
            return false;
        }
        return true;
    }
}

