/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.BoundingSphere;
import org.j3d.aviatrix3d.rendering.BoundingVolume;

public class BoundsUtils {
    private float[] wkVec1 = new float[3];
    private float[] wkVec2 = new float[3];

    public void combine(BoundingVolume boundingVolume, BoundingVolume boundingVolume2) {
        switch (boundingVolume.getType()) {
            case 1: {
                break;
            }
        }
    }

    public void combine(BoundingVolume boundingVolume, float[] fArray) {
        switch (boundingVolume.getType()) {
            case 1: {
                BoundingSphere boundingSphere = (BoundingSphere)boundingVolume;
                boundingVolume.getCenter(this.wkVec1);
                float f = boundingSphere.getRadiusSquared();
                float f2 = fArray[0] - this.wkVec1[0];
                float f3 = fArray[1] - this.wkVec1[1];
                float f4 = fArray[2] - this.wkVec1[2];
                float f5 = f2 * f2 + f3 * f3 + f4 * f4;
                if (!(f5 > f)) break;
                boundingSphere.setRadius((float)Math.sqrt(f5), f5);
                break;
            }
            case 2: {
                BoundingBox boundingBox = (BoundingBox)boundingVolume;
                boundingBox.getExtents(this.wkVec1, this.wkVec2);
                if (this.wkVec1[0] < fArray[0] || this.wkVec1[1] < fArray[1] || this.wkVec1[2] < fArray[2]) {
                    boundingBox.setMinimum(fArray);
                    break;
                }
                if (!(this.wkVec2[0] > fArray[0]) && !(this.wkVec2[1] > fArray[1]) && !(this.wkVec2[2] > fArray[2])) break;
                boundingBox.setMaximum(fArray);
            }
        }
    }

    public void contain(BoundingVolume boundingVolume, BoundingVolume[] boundingVolumeArray) {
        switch (boundingVolume.getType()) {
            case 1: {
                this.contain((BoundingSphere)boundingVolume, boundingVolumeArray);
                break;
            }
            case 2: {
                this.contain((BoundingBox)boundingVolume, boundingVolumeArray);
            }
        }
    }

    private void contain(BoundingSphere boundingSphere, BoundingVolume[] boundingVolumeArray) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i = 0; i < boundingVolumeArray.length; ++i) {
            boundingVolumeArray[i].getCenter(this.wkVec1);
            f += this.wkVec1[0];
            f2 += this.wkVec1[1];
            f3 += this.wkVec1[2];
        }
        float f4 = 1 / boundingVolumeArray.length;
        this.wkVec2[0] = f *= f4;
        this.wkVec2[1] = f2 *= f4;
        this.wkVec2[2] = f3 *= f4;
        boundingSphere.setCenter(this.wkVec2);
        float f5 = 0.0f;
        for (int i = 0; i < boundingVolumeArray.length; ++i) {
            boundingVolumeArray[i].getExtents(this.wkVec1, this.wkVec2);
            float f6 = f - this.wkVec1[0];
            float f7 = f2 - this.wkVec1[1];
            float f8 = f3 - this.wkVec1[2];
            float f9 = f6 * f6 + f7 * f7 + f8 * f8;
            if (f9 > f5) {
                f5 = f9;
            }
            if (!((f9 = (f6 = f - this.wkVec2[0]) * f6 + (f7 = f2 - this.wkVec2[1]) * f7 + (f8 = f3 - this.wkVec2[2]) * f8) > f5)) continue;
            f5 = f9;
        }
        boundingSphere.setRadius((float)Math.sqrt(f5), f5);
    }

    private void contain(BoundingBox boundingBox, BoundingVolume[] boundingVolumeArray) {
        boundingVolumeArray[0].getExtents(this.wkVec1, this.wkVec2);
        float f = this.wkVec1[0];
        float f2 = this.wkVec1[1];
        float f3 = this.wkVec1[2];
        float f4 = this.wkVec2[0];
        float f5 = this.wkVec2[1];
        float f6 = this.wkVec2[2];
        for (int i = 1; i < boundingVolumeArray.length; ++i) {
            boundingVolumeArray[i].getExtents(this.wkVec1, this.wkVec2);
            f4 = f4 > this.wkVec2[0] ? f4 : this.wkVec2[0];
            f5 = f5 > this.wkVec2[1] ? f5 : this.wkVec2[1];
            f6 = f6 > this.wkVec2[2] ? f6 : this.wkVec2[2];
            f = f < this.wkVec1[0] ? f : this.wkVec1[0];
            f2 = f2 < this.wkVec1[1] ? f2 : this.wkVec1[1];
            f3 = f3 < this.wkVec1[2] ? f3 : this.wkVec1[2];
        }
        boundingBox.setMinimum(f, f2, f3);
        boundingBox.setMaximum(f4, f5, f6);
    }
}

